#ifndef _G_STATE_
#define _G_STATE_

#include <string>
#include <iostream>
#include <list>
#include <map>
#include <queue>

#include "p2d.h"

static const unsigned int QUEUE_SIZE=8;

class mob
{	public:
	p2d	pos;
	std::queue<p2d>	old_pos;
	p2d	dir;
	bool	updated;
	int	shot_at;
	int	count_shots;
	mob()
	:pos(),old_pos(),dir()
	{	updated=false;
		shot_at=0;
		count_shots=0;
	}
	mob(const p2d &p)
	:pos(p),old_pos(),dir()
	{	updated=false;
		shot_at=0;
		count_shots=0;
	}
	void set_pos(const p2d&);
};	

class asteroid : public mob
{	public:
	int	type;	//1..4
	int	sf;	// 0 large  15 mid  14 small
	bool	predicted;

	asteroid(const p2d &p,int t,int s)
	:mob(p)
	{	type=t;
		sf=s;
		predicted=false;
	}
};

std::ostream& operator << (std::ostream&,const asteroid&);

class pred_asteroid : public mob
{	public:
	int radius;
	int lifetime;
	pred_asteroid(const p2d &p,const p2d &d,int t,int r)
	:mob(p)
	{	dir=d;
		lifetime=t;
		radius=r;
	}	
};

std::ostream& operator << (std::ostream&,const pred_asteroid&);

class mob_saucer : public mob
{	public:
	int	size;
	mob_saucer()
	:mob()
	{	size=0;
	}
	mob_saucer(const p2d &p,int s)
	:mob(p)
	{	size=s;
	}
};

class mob_ship : public mob
{	public:
	p2d	pic_dir;
	p2d	shot_start;
	mob_ship()
	:mob(),pic_dir()
	{
	}
	mob_ship(const p2d &p,const p2d &pd,const p2d &ps)
	:mob(p),pic_dir(pd),shot_start(ps)
	{
	}
	void set_pos(const p2d &p,const p2d &pd,const p2d shot_start_)
	{	shot_start=shot_start_;
		pic_dir=pd;
		mob::set_pos(p);
	}
};	

class shot : public mob
{	public:
	shot(const p2d &p)
	:mob(p)
	{
	}
};

std::ostream& operator << (std::ostream&,const shot&);

class target
{	public:
	int	id;
	p2d	pos;
	p2d	dir;
	int	radius;
	mob	*source;
	target()
	:pos(),dir()
	{	radius=0;
		source=NULL;
		id=-1;
	}
	target(int id_,const p2d &p,const p2d &d,int r,mob *s)
	:pos(p),dir(d)
	{	id=id_;
		radius=r;
		source=s;
	}
};

std::ostream& operator << (std::ostream&,const target&);

class g_state
{	public:
	
	bool	ship_present;
	unsigned char	ship_rotation_byte;
	mob_ship	ship;

	bool	saucer_present;
	mob_saucer	saucer;

	std::list<asteroid>	asteroids;
	std::list<pred_asteroid>	pred_asteroids;
	std::list<shot>		shots;
	std::map<double,target>	targets;
	int	lifes;
	std::string	message;
	int	score;

	g_state();
	~g_state();

	void interpret(unsigned char*,int=1);
	void compute_targets();
};

std::ostream& operator << (std::ostream&,const g_state&);

double get_required_time(const p2d&,const p2d&,const p2d&);
p2d get_required_shot_dir(const p2d&,const p2d&,const p2d&);
double get_distance_at_t(double,const p2d&,const p2d&,const p2d&,const p2d&);
double get_min_distance(const p2d&,const p2d&,const p2d&,const p2d&);
double get_time_to_hit(const p2d&,const p2d&,const p2d&,const p2d&,double);

std::pair<int,int> get_best_mapping(double);

unsigned char dir_to_wb(const p2d&);
p2d wb_to_dir(unsigned char);
unsigned char ub_diff(unsigned char,unsigned char);

#endif

