// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial products
//                     is not allowed without explicite permission.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.rammi;

/**
 *  Prepare a player.
 *
 *  Used ot set a player so it can ran automatically to figure out parameter settings.
 */
public interface PlayerPreparer
{
  /**
   *  Advance to next setting.
   *  This is called once before the first call to {@link #prepare(AsteroidPlayer)}. 
   *  @return useful settings name or <code>null</code> if there is no further setting
   */
  String advance();

  /**
   *  Prepare the player with the current setting.
   *  @param player  player to prepare
   */
  void prepare(AsteroidPlayer player);
}
