/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingIntegerPreferenceProperty;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class IntegerEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingIntegerPreferenceProperty propertySwing;
    private final JSpinner spinner;

    public IntegerEditor(SwingIntegerPreferenceProperty propertySwing, Locale l) {
        super(propertySwing, l);
        this.propertySwing = propertySwing;
        this.spinner = new JSpinner(new SpinnerNumberModel(propertySwing.getValue(), propertySwing.getMinValue(), propertySwing.getMaxValue(), propertySwing.getStep()));
        Dimension size = this.spinner.getPreferredSize();
        if (size.width > 1000) {
            this.spinner.setPreferredSize(new Dimension(100, size.height));
        }
        propertySwing.addValueChangeListener(this);
    }

    public JComponent getEditor() {
        return this.spinner;
    }

    public void reset() {
        this.spinner.setValue(new Integer(this.propertySwing.getValue()));
    }

    public void save() {
        this.propertySwing.setValue(((Number)this.spinner.getValue()).intValue());
    }

    public void goodBye() {
        this.propertySwing.removeValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        int newValue = ((Number)evt.getNewValue()).intValue();
        if (newValue != ((Number)this.spinner.getValue()).intValue()) {
            this.spinner.setValue(evt.getNewValue());
        }
    }
}

