/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class IconCanvasSwing
extends JComponent {
    protected ImageIcon icon;

    public IconCanvasSwing(Image img) {
        this.setImage(img);
    }

    protected void paintComponent(Graphics g) {
        if (this.icon != null) {
            Dimension size = this.getSize();
            int width = this.icon.getIconWidth();
            int height = this.icon.getIconHeight();
            this.icon.paintIcon(this, g, (size.width - width) / 2, (size.height - height) / 2);
        }
    }

    public Dimension getPreferredSize() {
        if (this.icon != null) {
            int width = this.icon.getIconWidth();
            int height = this.icon.getIconHeight();
            return new Dimension(width, height);
        }
        return new Dimension(1, 1);
    }

    public Dimension getMinimalSize() {
        return this.getPreferredSize();
    }

    public void setImage(Image img) {
        if (img != null) {
            try {
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(img, 0);
                mt.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.icon = new ImageIcon(img);
        this.invalidate();
        this.repaint();
    }
}

