/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.gimmicks.swing.State;
import de.caff.gimmicks.swing.StateManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractState
implements State {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected Map properties = new HashMap();
    protected StateManager manager;

    public AbstractState() {
        this.setPropertyInternal("ACTIVATION", Boolean.FALSE);
        this.setPropertyInternal("ENABLE", Boolean.TRUE);
    }

    void setManager(StateManager stateManager) {
        this.manager = stateManager;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    public boolean activate() {
        if (!this.isActivated()) {
            if (this.manager == null || this.manager.mayActivate(this)) {
                this.setPropertyInternal("ACTIVATION", Boolean.TRUE);
                return true;
            }
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        this.activate();
    }

    public boolean isActivated() {
        return (Boolean)this.properties.get("ACTIVATION");
    }

    protected void deactivate() {
        if (this.isActivated()) {
            this.setPropertyInternal("ACTIVATION", Boolean.FALSE);
        }
    }

    public void setEnabled(boolean state) {
        if (this.isEnabled() != state && this.manager.mayEnable(this, state)) {
            this.setPropertyInternal("ENABLE", state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isEnabled() {
        return (Boolean)this.properties.get("ENABLE");
    }

    public Object getValue(String name) {
        return this.properties.get(name);
    }

    public void putValue(String key, Object value) {
        Object oldValue = this.getValue(key);
        if (oldValue != value || oldValue != null && !oldValue.equals(value)) {
            this.properties.put(key, value);
            this.propertyChangeSupport.firePropertyChange(key, oldValue, value);
        }
    }

    protected void setProperty(String name, Object value) {
        Object oldValue = this.getValue(name);
        if ("ACTIVATION".equals(name) || "ENABLE".equals(name)) {
            throw new RuntimeException("Don't set property " + name + " via setProperty(). Use dedicated method instead.");
        }
        if (!(oldValue == value || value != null && oldValue != null && value.equals(oldValue))) {
            this.properties.put(name, value);
            this.propertyChangeSupport.firePropertyChange(name, oldValue, value);
        }
    }

    private void setPropertyInternal(String name, Object value) {
        Object oldValue = this.getValue(name);
        this.properties.put(name, value);
        this.propertyChangeSupport.firePropertyChange(name, oldValue, value);
    }
}

