/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Communication;
import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameData;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.rammi.AbstractBasicAsteroidPlayer;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.ImprovedVelocityPreparer;
import de.caff.asteroid.rammi.ShootingDirectionFixer;
import de.caff.util.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KleinstplanetenschutzvereinPlayer
extends AbstractBasicAsteroidPlayer
implements FrameListener,
DrawableProvider,
GameData {
    private static final int RADIUS = 20;
    private ShootingDirectionFixer shootingDirectionFixer;

    public KleinstplanetenschutzvereinPlayer() {
        this(null);
    }

    public KleinstplanetenschutzvereinPlayer(Communication com) {
        super(com);
        if (com != null) {
            this.shootingDirectionFixer = new ShootingDirectionFixer();
            com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new ImprovedVelocityPreparer(), new ScoreFixer(), this.shootingDirectionFixer}));
            com.addDatagramListener(this.shootingDirectionFixer);
        }
    }

    @Override
    public void destroy() {
        this.com.removeDatagramListener(this.shootingDirectionFixer);
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        SpaceShip ship = frame.getSpaceShip();
        if (ship != null) {
            SortedMap<Integer, List<MovingGameObject>> dangerous = KleinstplanetenschutzvereinPlayer.getDangerousObjects(frame, ship);
            if (!dangerous.isEmpty()) {
                Integer frames = dangerous.firstKey();
                if (frames < 4) {
                    this.pushButton(1);
                } else {
                    double dirX = ship.getDirX();
                    double dirY = ship.getDirY();
                    double dirLen = Tools.getLength(dirX, dirY);
                    MovingGameObject obj = (MovingGameObject)((List)dangerous.get(frames)).get(0);
                    Point delta = ship.getDelta(obj.getPredictedLocation(frames));
                    double deltaLen = Tools.getLength(delta);
                    double cross = Tools.crossProduct((double)delta.x, (double)delta.y, dirX, dirY) / (dirLen * deltaLen);
                    double scalar = Tools.scalarProduct((double)delta.x, (double)delta.y, dirX, dirY) / (dirLen * deltaLen);
                    if (Math.abs(scalar) < 0.2) {
                        this.pushButton(4);
                    } else if (cross < 0.0) {
                        this.pushButton(scalar < 0.0 ? 16 : 8);
                    } else {
                        this.pushButton(scalar < 0.0 ? 8 : 16);
                    }
                }
            } else {
                Point2D averageVelocity = KleinstplanetenschutzvereinPlayer.getAverageVelocity(frame.getAsteroids());
                double dvx = averageVelocity.getX() - ship.getVelocityX();
                double dvy = averageVelocity.getY() - ship.getVelocityY();
                if (dvx != 0.0 || dvy != 0.0) {
                    double dvlen = Tools.getLength(dvx, dvy);
                    double dirX = ship.getDirX();
                    double dirY = ship.getDirY();
                    double dirLen = Tools.getLength(dirX, dirY);
                    double cross = Tools.crossProduct(dvx, dvy, dirX, dirY) / (dvlen * dirLen);
                    if (Math.abs(cross) > 0.1) {
                        this.pushButton(cross < 0.0 ? 16 : 8);
                    } else if (dvlen > 0.2) {
                        this.pushButton(4);
                    }
                }
            }
        }
    }

    private static SortedMap<Integer, List<MovingGameObject>> getDangerousObjects(FrameInfo frame, SpaceShip ship) {
        TreeMap<Integer, List<MovingGameObject>> dangerous = new TreeMap<Integer, List<MovingGameObject>>();
        KleinstplanetenschutzvereinPlayer.checkCollisions(ship, new ArrayList<MovingGameObject>(frame.getBullets()), dangerous);
        KleinstplanetenschutzvereinPlayer.checkCollisions(ship, new ArrayList<MovingGameObject>(frame.getAsteroids()), dangerous);
        if (frame.getUfo() != null) {
            ArrayList<MovingGameObject> ufoList = new ArrayList<MovingGameObject>(1);
            ufoList.add(frame.getUfo());
            KleinstplanetenschutzvereinPlayer.checkCollisions(ship, ufoList, dangerous);
        }
        return dangerous;
    }

    private static void checkCollisions(SpaceShip ship, Collection<MovingGameObject> objects, SortedMap<Integer, List<MovingGameObject>> result) {
        int maxCheck = 240;
        for (MovingGameObject obj : objects) {
            int frames = AsteroidPlayer.getFramesUntilCollision(ship, obj, 240);
            if (frames <= 0 || frames >= 240) continue;
            Integer iFrames = frames;
            LinkedList<MovingGameObject> entries = (LinkedList<MovingGameObject>)result.get(iFrames);
            if (entries == null) {
                entries = new LinkedList<MovingGameObject>();
                result.put(iFrames, entries);
            }
            entries.add(obj);
        }
    }

    private static Point2D getAverageVelocity(Collection<Asteroid> asteroids) {
        double vx = 0.0;
        double vy = 0.0;
        for (Asteroid ast : asteroids) {
            vx += ast.getVelocityX();
            vy += ast.getVelocityY();
        }
        return asteroids.size() > 0 ? new Point2D.Double(vx / (double)asteroids.size(), vy / (double)asteroids.size()) : new Point2D.Double();
    }

    @Override
    public void draw(Graphics2D g, FrameInfo frame) {
        SpaceShip ship = frame.getSpaceShip();
        if (ship != null) {
            SortedMap<Integer, List<MovingGameObject>> dangerous = KleinstplanetenschutzvereinPlayer.getDangerousObjects(frame, ship);
            Color color = Color.red;
            g.setStroke(new BasicStroke(2.0f));
            for (List<MovingGameObject> objList : dangerous.values()) {
                g.setColor(color);
                color = color.brighter();
                for (MovingGameObject obj : objList) {
                    g.drawOval(obj.getX() - 20, obj.getY() - 20, 40, 40);
                }
            }
        }
    }
}

