/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.util.Tools;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectionPainter
implements GameData {
    private static final int MARGIN_WIDTH = 32;
    private static final int CELL_WIDTH = 16;
    private static final int HOR_CELLS = 68;
    private static final int VER_CELLS = 52;
    private static final int HOR_CENTER = 34;
    private static final int VER_CENTER = 26;
    private static final Comparator<BulletFrameInfo> FRAME_COMPARATOR = new Comparator<BulletFrameInfo>(){

        @Override
        public int compare(BulletFrameInfo o1, BulletFrameInfo o2) {
            return o1.getFrame() - o2.getFrame();
        }
    };
    private static final BulletFrameInfo[][][] area = new BulletFrameInfo[68][52][];

    static Match mapToArea(double x, double y) {
        return DirectionPainter.mapToAreaUnnormalized(GameObject.normalizeDeltaX(x), GameObject.normalizeDeltaY(y));
    }

    private static Match mapToAreaUnnormalized(double x, double y) {
        double nx = GameObject.normalizeDeltaX(x);
        double ny = GameObject.normalizeDeltaY(y);
        int cellX = (int)Math.floor(nx / 16.0);
        int cellY = (int)Math.floor(ny / 16.0);
        return new Match(cellX + 34, cellY + 26, nx - (double)(cellX * 16), ny - (double)(cellY * 16));
    }

    public static Collection<BulletFrameInfo> getBulletFrameInfos(Point2D pos, int size) {
        LinkedList<BulletFrameInfo> result = new LinkedList<BulletFrameInfo>();
        Match match = DirectionPainter.mapToArea(pos.getX(), pos.getY());
        int offset = (2 * size + 3 + 16 - 1) / 16;
        double sizeSquared = size * size;
        for (int x = -offset; x <= offset; ++x) {
            for (int y = -offset; y <= offset; ++y) {
                for (BulletFrameInfo info : area[match.getCellX() + x][match.getCellY() + y]) {
                    if (!(Tools.square(info.getPosition().getX() - pos.getX()) + Tools.square(info.getPosition().getY() - pos.getY()) < sizeSquared)) continue;
                    result.add(info);
                }
            }
        }
        Collections.sort(result, FRAME_COMPARATOR);
        return result;
    }

    static {
        for (int dir = 0; dir < 256; ++dir) {
            byte dirByte = (byte)dir;
            FrameInfo.Direction direction = FrameInfo.getShootingDirection(dir);
            double posX = direction.getDisplacement().x;
            double posY = direction.getDisplacement().y;
            for (int frame = 1; frame <= 70; ++frame) {
                double nx = GameObject.normalizeDeltaX(posX);
                double ny = GameObject.normalizeDeltaY(posY);
                for (int deltaX : new int[]{-1024, 0, 1024}) {
                    for (int deltaY : new int[]{-768, 0, 768}) {
                        int cy;
                        Match m = DirectionPainter.mapToAreaUnnormalized(nx + (double)deltaX, ny + (double)deltaY);
                        if (!m.isValid()) continue;
                        BulletFrameInfo newInfo = new BulletFrameInfo(dirByte, frame, nx + (double)deltaX, ny + (double)deltaY);
                        int cx = m.getCellX();
                        if (area[cx][cy = m.getCellY()] == null) {
                            DirectionPainter.area[cx][cy] = new BulletFrameInfo[]{newInfo};
                            continue;
                        }
                        BulletFrameInfo[] newEntries = new BulletFrameInfo[area[cx][cy].length + 1];
                        System.arraycopy(area[cx][cy], 0, newEntries, 0, area[cx][cy].length);
                        newEntries[DirectionPainter.area[cx][cy].length] = newInfo;
                        DirectionPainter.area[cx][cy] = newEntries;
                    }
                }
                posX += direction.getBulletVelocity().getX();
                posY += direction.getBulletVelocity().getY();
            }
        }
    }

    private static class Match {
        private final int cellX;
        private final int cellY;
        private final double offsetX;
        private final double offsetY;

        private Match(int cellX, int cellY, double offsetX, double offsetY) {
            this.cellX = cellX;
            this.cellY = cellY;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public int getCellX() {
            return this.cellX;
        }

        public int getCellY() {
            return this.cellY;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public boolean isValid() {
            return this.cellX >= 0 && this.cellX < 68 && this.cellY >= 0 && this.cellY < 52;
        }
    }

    public static class BulletFrameInfo {
        private final byte direction;
        private final int frame;
        private final Point2D position;

        BulletFrameInfo(byte direction, int frame, double x, double y) {
            this.direction = direction;
            this.frame = frame;
            this.position = new Point2D.Double(x, y);
        }

        public byte getDirection() {
            return this.direction;
        }

        public int getFrame() {
            return this.frame;
        }

        public Point2D getPosition() {
            return this.position;
        }
    }
}

