/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis.statistics;

import de.caff.asteroid.Property;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.statistics.AnswerTimesStatistics;
import de.caff.asteroid.analysis.statistics.BulletStatistics;
import de.caff.asteroid.analysis.statistics.DumpFileStatistics;
import de.caff.asteroid.analysis.statistics.KeyStatistics;
import de.caff.asteroid.analysis.statistics.StatisticsDialog;
import de.caff.i18n.I18n;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicDumpFileStatistics
implements DumpFileStatistics {
    protected static final String TAG_HTML = "html";
    protected static final String TAG_HEAD = "head";
    protected static final String TAG_TITLE = "title";
    protected static final String TAG_BODY = "body";
    protected static final String TAG_HEADER_MAIN = "h1";
    protected static final String TAG_HEADER_SECTION = "h2";
    protected static final String TAG_HEADER_SUBSECTION = "h3";
    protected static final String TAG_TABLE = "table";
    protected static final String TAG_TABLE_ROW = "tr";
    protected static final String TAG_TABLE_HEAD = "th";
    protected static final String TAG_TABLE_CELL = "td";
    protected static final String TAG_STYLE = "style";
    protected static final String VAL_ALIGN_LEFT = "text-align:left;";
    protected static final String VAL_ALIGN_RIGHT = "text-align:right";

    protected static String escapeHtml(String str) {
        StringBuilder b = new StringBuilder();
        block6: for (char ch : str.toCharArray()) {
            switch (ch) {
                case '&': {
                    b.append("&amp;");
                    continue block6;
                }
                case '<': {
                    b.append("&lt;");
                    continue block6;
                }
                case '>': {
                    b.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    b.append("&quot;");
                    continue block6;
                }
                default: {
                    b.append(ch);
                }
            }
        }
        return b.toString();
    }

    protected static String attr(String name, Object value) {
        return String.format("%s=\"%s\"", name, AbstractBasicDumpFileStatistics.escapeHtml(value.toString()));
    }

    protected static void appendOpenTag(StringBuilder b, String tag, String ... attrs) {
        b.append('<').append(tag);
        for (String att : attrs) {
            b.append(' ').append(att);
        }
        b.append('>');
    }

    protected static void appendCloseTag(StringBuilder b, String tag) {
        b.append("</").append(tag).append('>');
    }

    protected static void appendStandaloneTag(StringBuilder b, String tag, String ... attrs) {
        b.append('<').append(tag);
        for (String att : attrs) {
            b.append(' ').append(att);
        }
        b.append("/>");
    }

    protected static void appendTaggedText(StringBuilder b, String text, String tag, String ... attrs) {
        AbstractBasicDumpFileStatistics.appendOpenTag(b, tag, attrs);
        AbstractBasicDumpFileStatistics.appendText(b, text);
        AbstractBasicDumpFileStatistics.appendCloseTag(b, tag);
    }

    protected static void appendText(StringBuilder b, String text) {
        b.append(AbstractBasicDumpFileStatistics.escapeHtml(text));
    }

    protected void appendContentTable(StringBuilder b, Collection<Property> properties) {
        AbstractBasicDumpFileStatistics.appendOpenTag(b, TAG_TABLE, AbstractBasicDumpFileStatistics.attr("border", 1));
        AbstractBasicDumpFileStatistics.appendOpenTag(b, TAG_TABLE_ROW, new String[0]);
        AbstractBasicDumpFileStatistics.appendTaggedText(b, I18n.getString("abdfsRowHeadName"), TAG_TABLE_HEAD, new String[0]);
        AbstractBasicDumpFileStatistics.appendTaggedText(b, I18n.getString("abdfsRowHeadValue"), TAG_TABLE_HEAD, new String[0]);
        AbstractBasicDumpFileStatistics.appendCloseTag(b, TAG_TABLE_ROW);
        for (Property property : properties) {
            AbstractBasicDumpFileStatistics.appendOpenTag(b, TAG_TABLE_ROW, new String[0]);
            AbstractBasicDumpFileStatistics.appendTaggedText(b, property.getName(), TAG_TABLE_CELL, AbstractBasicDumpFileStatistics.attr(TAG_STYLE, this.getLeftColumnAlign()));
            AbstractBasicDumpFileStatistics.appendTaggedText(b, property.getValueString(), TAG_TABLE_CELL, AbstractBasicDumpFileStatistics.attr(TAG_STYLE, this.getRightColumnAlign()));
            AbstractBasicDumpFileStatistics.appendCloseTag(b, TAG_TABLE_ROW);
        }
        AbstractBasicDumpFileStatistics.appendCloseTag(b, TAG_TABLE);
    }

    @Override
    public void appendToHtml(StringBuilder html) {
        AbstractBasicDumpFileStatistics.appendTaggedText(html, this.getTitle(), TAG_HEADER_SECTION, new String[0]);
        this.appendContentTable(html, this.getProperties());
    }

    @Override
    public String getHtmlReport() {
        StringBuilder b = new StringBuilder();
        AbstractBasicDumpFileStatistics.appendOpenTag(b, TAG_HTML, new String[0]);
        AbstractBasicDumpFileStatistics.appendOpenTag(b, TAG_HEAD, new String[0]);
        AbstractBasicDumpFileStatistics.appendTaggedText(b, this.getTitle(), TAG_TITLE, new String[0]);
        AbstractBasicDumpFileStatistics.appendCloseTag(b, TAG_HEAD);
        AbstractBasicDumpFileStatistics.appendOpenTag(b, TAG_BODY, new String[0]);
        this.appendHtmlBody(b);
        AbstractBasicDumpFileStatistics.appendCloseTag(b, TAG_BODY);
        AbstractBasicDumpFileStatistics.appendCloseTag(b, TAG_HTML);
        return b.toString();
    }

    protected void appendHtmlBody(StringBuilder b) {
        AbstractBasicDumpFileStatistics.appendTaggedText(b, this.getTitle(), TAG_HEADER_MAIN, new String[0]);
        this.appendContentTable(b, this.getProperties());
    }

    protected String getLeftColumnAlign() {
        return VAL_ALIGN_LEFT;
    }

    protected String getRightColumnAlign() {
        return VAL_ALIGN_RIGHT;
    }

    public static JPopupMenu getStatisticsMenu(DumpFile dumpFile) {
        JPopupMenu popup = new JPopupMenu("menuTitleStatistics");
        popup.add(new ShowStatisticsAction(dumpFile, new KeyStatistics()));
        popup.add(new ShowStatisticsAction(dumpFile, new BulletStatistics()));
        popup.add(new ShowStatisticsAction(dumpFile, new AnswerTimesStatistics()));
        return popup;
    }

    protected static String percentify(double part, double total) {
        return total == 0.0 ? "???" : String.format("%3.2f%%", 100.0 * part / total);
    }

    static {
        I18n.addAppResourceBase("de.caff.asteroid.analysis.statistics.resources.AbstractBasicDumpFileStatistics");
    }

    private static class ShowStatisticsAction
    extends AbstractAction {
        private DumpFile dumpFile;
        private DumpFileStatistics statistics;

        ShowStatisticsAction(DumpFile dumpFile, DumpFileStatistics statistics) {
            super(statistics.getTitle());
            this.dumpFile = dumpFile;
            this.statistics = statistics;
        }

        public void actionPerformed(ActionEvent e) {
            this.statistics.analyse(this.dumpFile.getInfos());
            StatisticsDialog dialog = new StatisticsDialog(this.statistics);
            dialog.setVisible(true);
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

