/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Buttons;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.PingKeyProvider;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameKeyInfo {
    private FrameInfo frameInfo;
    private List<ButtonInfo> buttons = new LinkedList<ButtonInfo>();

    public FrameKeyInfo(int index, long timestamp, byte[] frameBytes) throws IOException {
        this(index, timestamp, frameBytes, null);
    }

    public FrameKeyInfo(int index, long timestamp, byte[] frameBytes, PingKeyProvider pinky) throws IOException {
        this.frameInfo = new FrameInfo(index, frameBytes, pinky, timestamp);
    }

    public void addButtons(long timestamp, byte keys, byte ping) {
        this.buttons.add(new ButtonInfo(timestamp, keys, ping));
    }

    public void addButtons(byte keys) {
        this.buttons.add(new ButtonInfo(this.frameInfo.getReceiveTime(), keys));
    }

    public FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    public List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    public static class ButtonInfo {
        private long timestamp;
        private Buttons buttons;
        private byte pingID;

        ButtonInfo(long timestamp, byte keymask) {
            this(timestamp, keymask, 0);
        }

        ButtonInfo(long timestamp, byte keymask, byte ping) {
            this.timestamp = timestamp;
            this.buttons = new Buttons(keymask);
            this.pingID = ping;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Buttons getButtons() {
            return this.buttons;
        }

        public byte getPingID() {
            return this.pingID;
        }
    }
}

