/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.PingKeyProvider;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;

public class AnalysisDisplay
extends JFrame {
    private static String makeTitle(DumpFile dumpFile) {
        StringBuilder b = new StringBuilder("Analysis of ");
        if (dumpFile == null) {
            b.append("???");
        } else {
            b.append(dumpFile.getFilename());
            if (dumpFile.getIpAddress() != null) {
                b.append("[").append(dumpFile.getIpAddress()).append(":").append(dumpFile.getClientPort());
                if (dumpFile.getPlayerName() != null) {
                    b.append("; ").append(dumpFile.getPlayerName());
                }
                b.append("]");
            }
        }
        return b.toString();
    }

    public AnalysisDisplay(final DumpFile dumpFile, FramePreparer velocityPreparer, String drawableProviderClass, boolean simple) throws IOException {
        super(AnalysisDisplay.makeTitle(dumpFile));
        final TimeLine timeLine = new TimeLine(dumpFile);
        FrameKeyInfoDisplay frameKeyInfoDisplay = new FrameKeyInfoDisplay(timeLine, velocityPreparer, AnalysisDisplay.getDrawableProvider(drawableProviderClass), simple);
        timeLine.addFrameListener(new FrameListener(){

            public void frameReceived(FrameInfo frame) {
                AnalysisDisplay.this.setTitle(String.format("%s [%d]", dumpFile.getFilename(), timeLine.getCurrentIndex()));
            }
        });
        this.getContentPane().add((Component)frameKeyInfoDisplay, "Center");
        this.getContentPane().add((Component)timeLine, "South");
        if (simple) {
            this.pack();
        } else {
            this.setSize(1000, 750);
        }
    }

    public static void main(String[] args) throws IOException {
        String filename = null;
        String drawableProvider = "de.caff.asteroid.rammi.AsteroidPlayer";
        boolean simple = false;
        boolean nextIsDrawableProvider = false;
        for (String arg : args) {
            if (nextIsDrawableProvider) {
                nextIsDrawableProvider = false;
                drawableProvider = arg;
                continue;
            }
            if ("-s".equals(arg)) {
                simple = true;
                continue;
            }
            if ("-d".equals(arg)) {
                nextIsDrawableProvider = true;
                continue;
            }
            if (filename == null) {
                filename = arg;
                continue;
            }
            System.err.println(String.format("Unexpected command line argument: '%s'", arg));
            System.exit(1);
        }
        if (nextIsDrawableProvider) {
            System.err.println("Switch -d needs argument!");
        }
        if (filename == null) {
            System.err.println("Need dump file argument!");
            System.exit(1);
        }
        DumpFile dumpFile = AnalysisDisplay.openDumpFile(filename);
        AnalysisDisplay dpy = new AnalysisDisplay(dumpFile, AnalysisDisplay.getBestPreparer(dumpFile), drawableProvider, simple);
        dpy.setDefaultCloseOperation(3);
        dpy.setVisible(true);
    }

    private static DumpFile openDumpFile(String filename) throws IOException {
        try {
            URL url = new URL(filename);
            return new DumpFile(url.openStream(), filename);
        }
        catch (MalformedURLException e) {
            return new DumpFile(filename);
        }
    }

    private static FramePreparer getBestPreparer(PingKeyProvider pinky) {
        try {
            Class<?> veloClass = Class.forName("de.caff.asteroid.rammi.ImprovedVelocityPreparer");
            Class<?> dirClass = Class.forName("de.caff.asteroid.rammi.ShootingDirectionFixer");
            Constructor<?> constr = dirClass.getConstructor(PingKeyProvider.class);
            return new FramePreparerSequence((FramePreparer)veloClass.newInstance(), (FramePreparer)constr.newInstance(pinky));
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new SimpleVelocityPreparer();
    }

    private static DrawableProvider getDrawableProvider(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (DrawableProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }
}

