/*

     ASTEROID.C

     Code File

     Hans-D. Heppner  Juni 2008

*/

#include "asteroid.h"

unsigned char  Tsknam[128]     = { "TestAsteroids" } ;

int            AstUseThreads   =    1  ;

unsigned long  TraceF          =    0  ;
         FILE *TraceFp         = NULL  ;
unsigned long  ServIP          =    0  ;

int            GloSka          =    0  ;
int            AstKeys         =    0  ;
int            AstThreadStatus =    0  ;
int            MaxObjects      =    0  ;

int            AsterAnz        =    0  ;
int            ShotCntr        =    0  ;
int            LeftCntr        =    0  ;
int            RightCntr       =    0  ;
int            ThrustCntr      =    0  ;
int            HyperCntr       =    0  ;

double         AstSafeX        = 512.0 ;
double         AstSafeY        = 512.0 ;

int            ShotTabPtr      =    0  ;

int            SetKeyLeft      = 0 ;
int            SetKeyRight     = 0 ;
int            SetKeyThrust    = 0 ;
int            SetKeyFire      = 0 ;
int            SetKeyHyper     = 0 ;

extern int     LastShotT       =    0 ;
extern double  LastShotX       =  0.0 ;
extern double  LastShotY       =  0.0 ;

int            FrameCounter    = 0 ;
int            FrameMissed     = 0 ;
int            LastFrame       = 0 ;

double         Dtemp ;

SOCKET         Socket      =    0  ;

FRAMEPACK      FrameP      = { 0 } ;
KEYPACK        KeyP        = { 0 } ;

OBJREC         Objects[MAX_OBJECTS] = { 0 } ;
OBJREC         Objecto[MAX_OBJECTS] = { 0 } ;

int            SchiffDa    =   0   ;
int            UFODa       =   0   ;
int            ShotAnz     =   0   ;

int  ast_sock_read  ( SOCKET socket, FRAMEPACK *p, int blklen ) ;
int  ast_sock_write ( SOCKET socket, KEYPACK *p,   int blklen ) ;

void ast_init            ( void ) ;
void ast_sock_init       ( void ) ;
void ast_frame_dump      ( char *txt, OBJREC *pcur, OBJREC *pold ) ;
void ast_frame_decode    ( FRAMEPACK *pf ) ;
void ast_calc_parameters ( void ) ;
void ast_berechnungen    ( void ) ;

static unsigned long  TimeStart = 0 ;
static unsigned long  TimeNow   = 0 ;



static void ast_show_usage ( char *pgm )
/* --------------------------------------------------------------------- */
/*                                                                       */
/* --------------------------------------------------------------------- */
{
    fprintf ( stderr, "\nAufruf: %s [IP-Adresse] [-F=TraceFile] \n", pgm ) ;
	return ;
}



int main ( int argc, char *argv[] )
/* --------------------------------------------------------------------- */
/*                                                                       */
/* --------------------------------------------------------------------- */
{
	int            i      ;
	char           c      ;
	char          *cp     ;
	int            retcod ;
	int            shotct ;
	int            intval ;
    unsigned long  enanob ;

    struct sockaddr_in sockad ;

	/* ------------------------- */
	/* Initialisierungen         */
	/* ------------------------- */

	retcod = 0 ;
	enanob = 1 ; /* "Enable Non-Blocking" */
    memset ( &sockad, 0, sizeof ( sockad ) ) ;

	/* ------------------------- */
	/* Parameterzeile dekodieren */
	/* ------------------------- */

	memset ( Tsknam, 0, sizeof ( Tsknam ) ) ;
	strncpy ( Tsknam, argv[0], sizeof ( Tsknam ) - 1 ) ;

    // TraceF = 0xFFFFFF & ~TRACE_DECODE & ~TRACE_DUMP ;
    // TraceF = TRACE_SHOTS | TRACE_FRAME | TRACE_SEND ;

    if ( 1 == argc ) {
        ServIP = inet_addr ( "127.0.0.1" ) ;
        fprintf ( stderr, "\n%s: IP-Adresse '%s' wird benutzt.\n", Tsknam, "127.0.0.1" ) ;
	}
	else {
    	ServIP = inet_addr ( argv[1] ) ;
	    if ( INADDR_NONE == ServIP ) {
	        fprintf ( stderr, "\n%s: ungueltige IP-Adresse: '%s'\n", Tsknam, argv[1] ) ;
			ast_show_usage ( Tsknam ) ;
	        exit ( 1 ) ;
		}
		i = 2 ;
		while ( i < argc ) {
			cp = argv[i++] ;
			if ( '-' == *cp++ ) {
				c = *cp++ ;
				if ( '=' == *cp++ ) {
				   switch ( c ) {
				   case 'T':
				   case 't':
					  TraceF = atoi ( cp ) ;
					  break ;
				   case 'F':
				   case 'f':
					  TraceFp = fopen ( cp, "w" ) ;
					  if ( NULL == TraceFp ) {
	                     fprintf ( stderr, "\n%s: kann Trace-Datei '%s' nicht zum Schreiben ffnen !\n", Tsknam, cp ) ;
			             ast_show_usage ( Tsknam ) ;
			             exit ( 1 ) ;
					  }
					  else {
	                     fprintf ( stderr, "\n%s: Trace-Datei '%s' geffnet.\n", Tsknam, cp ) ;
					  }
					  break ;
				   default:
			          ast_show_usage ( Tsknam ) ;
			          exit ( 1 ) ;
					  break ;
				   } /* end switch */
				}
				else {
			       ast_show_usage ( Tsknam ) ;
			       exit ( 1 ) ;
				} /* end if ( c == '=' ) */
			}
			else {
			   ast_show_usage ( Tsknam ) ;
			   exit ( 1 ) ;
			} /* end if ( i == '-' ) */
			++ i ;
		} /* end while ( i < argc ) */
	} /* end if ( argc count ?? */

	if ( 0 != TraceF  &&  NULL == TraceFp ) {
		fprintf ( stderr, "\nTrace can not be written.\nInvalid trace file given.\n" ) ;
	}

	ast_sock_init ( ) ;

	ast_init ( ) ;

	Socket = socket ( AF_INET, SOCK_DGRAM, 0 ) ;
	if ( INVALID_SOCKET == Socket )	{   
		fprintf ( stderr, "%s: Fehler %d bei socket().\n", Tsknam, WSAGetLastError());
		exit ( 2 ) ;
	}

	if ( ioctlsocket ( Socket, FIONBIO, &enanob ) ) {
		fprintf ( stderr, "%s: Kann Socket nicht auf nonblocking setzen (%d)", Tsknam, WSAGetLastError() ) ;
		exit ( 3 ) ;
	}

	sockad.sin_family      = AF_INET ;
	sockad.sin_addr.s_addr = 0 ;
	sockad.sin_port        = 0 ;

	if ( bind ( Socket, (struct sockaddr*) &sockad, sizeof ( sockad ) ) ) {
		fprintf ( stderr, "\n%s: Fehler %d bei bind().\n", Tsknam, WSAGetLastError() ) ;
		exit ( 4 ) ;
	}

	retcod =    0 ;
	shotct = (-1) ;

	Dtemp = 0.0 ;

	time ( &TimeStart ) ;
	TimeNow = TimeStart ;
    i = 0 ;

	while ( (10*60+1) >= ( TimeNow - TimeStart ) ) {
	   ++ i ;
       intval = ast_sock_write ( Socket, &KeyP,   sizeof ( KeyP ) ) ;
       intval = ast_sock_read  ( Socket, &FrameP, sizeof ( FrameP ) ) ;

	   ast_frame_decode ( &FrameP ) ;
	   
	   ast_calc_parameters ( ) ;
	   
	   // ast_frame_dump ( "Objects", &Objects[0], &Objecto[0] ) ;
       
	   AstKeys      = 0 ;
	   SetKeyHyper  = 0 ;
	   SetKeyFire   = 0 ;
	   SetKeyThrust = 0 ;
	   SetKeyLeft   = 0 ;
	   SetKeyRight  = 0 ;

	   ast_berechnungen ( ) ;

	   if ( 0 != SchiffDa ) {
 		   if ( 0 != SetKeyLeft ) {
	    	   AstKeys = AstKeys | KEY_LEFT ;
		   }
		   if ( 0 != SetKeyRight ) {
	    	   AstKeys = AstKeys | KEY_RIGHT ;
		   }
		   if ( 0 != SetKeyFire ) {
	    	   AstKeys = AstKeys | KEY_FIRE ;
		   }
		   if ( 0 != SetKeyThrust ) {
	    	   AstKeys = AstKeys | KEY_THRUST ;
		   }
		   if ( 0 != SetKeyHyper ) {
	    	   AstKeys = AstKeys | KEY_HYPER ;
		   }
	   }
	   time ( &TimeNow ) ;
	}

    AstKeys = KEY_LEFT | KEY_THRUST ;
    intval = ast_sock_write ( Socket, &KeyP,   sizeof ( KeyP ) ) ;

	if ( NULL != TraceFp ) {
		fclose ( TraceFp ) ;
	}

	fprintf ( stderr, "\nMaxObjects   = %d\n", MaxObjects ) ;
	fprintf ( stderr, "\nFrameCounter = %d\n", FrameCounter ) ;
	fprintf ( stderr, "\nFramesMissed = %d\n", FrameMissed ) ;
	TimeNow = TimeNow - TimeStart ;
	fprintf ( stderr, "\nTime         = %d min %02d sec\n", TimeNow / 60, TimeNow % 60 ) ;
    fprintf ( stderr, "\npress any key...\n" ) ;
	getch () ;

	return ( retcod ) ;
}