// threading.cpp
// -------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "stdafx.hpp"

#include "threading.hpp"

namespace intrepid
{
    namespace threading
    {
#ifdef BOOST_WINDOWS_API
        namespace
        {
            vector<int> thread_priority_stack_;

            bool set_thread_prio(int prio)
            {
                return ::SetThreadPriority(::GetCurrentThread(), prio) != 0;
            }
        }
#endif

        void pop_priority()
        {
#ifdef BOOST_WINDOWS_API
            assert(!thread_priority_stack_.empty());
            bool succeeded = set_thread_prio(thread_priority_stack_.back());
            assert(succeeded);
            thread_priority_stack_.pop_back();
#endif
        }

        void push_high_priority()
        {
#ifdef BOOST_WINDOWS_API
            int const prio = THREAD_PRIORITY_TIME_CRITICAL;
            if (!set_thread_prio(prio))
            {
                throw system_error(error_code(::GetLastError(),
                                              system_category));
            }
            thread_priority_stack_.push_back(prio);
#endif
        }
    } // end of namespace threading
} // end of namespace intrepid
