// ast_random.cpp
// --------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "stdafx.hpp"

#include "ast_random.hpp"

#include "../algo.hpp"

namespace intrepid
{
    ast_random::ast_random()
    {
        create_random_seq();
        create_index();
    }

    void ast_random::create_index()
    {
        // shapes of the first 8 asteroids as key (2 bits / asteroid)
        for (unsigned int n = 0; n < random_period; ++n)
        {
            unsigned int key = 0;
            for (uint8_t k = 0; k < 8; ++k)
            {
                key |= ((sequence_[n + 7 * k] >> 3) & 0x03) << (7 - k) * 2;
            }
            index_[n] = index_entry(key, n);
        }
        sort(index_);
    }

    void ast_random::create_random_seq()
    {
        uint8_t low = 0, high = 0;
        next_rand_number(low, high);
        next_rand_number(low, high);
        for (size_t n = 0; n < sequence_.size(); ++n)
        {
            next_rand_number(low, high);
            sequence_[n] = low;
        }
    }

    void ast_random::next_rand_number(uint8_t &low, uint8_t &high)
    {
        unsigned int b = low << 1;
        high <<= 1;
        if (b & 0x100)
        {
            high |= 1;
        }
        low = static_cast<uint8_t>(b);
        if (high & 0x80)
        {
            low += 1;
        }
        if (low & 2)
        {
            low ^= 1;
        }
        if (low == 0 && high == 0)
        {
            low = 1;
        }
    }

    ast_random ast_random::instance_;
} // end of namespace intrepid
