// strategy.hpp
// ------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_STRATEGY_HPP
#define INTREPID_STRATEGY_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

#include "game_state.hpp"

namespace intrepid
{
    class screen_state;

    class strategy
    {
    public:
        strategy(screen_state const &screen_st);

        void compute_next_move(int      thread_nr,
                               uint8_t &keys,
                               int     &rating);

    private:
        strategy(strategy const &); // = delete:
        strategy &operator=(strategy const &); // = delete:

        uint8_t advance_gs_until_shot_available(game_state &gs);
        uint8_t capture_new_target();
        void compute_asteroid_mass();
        uint8_t compute_next_keys();
        bool eval_target(game_state gs, int object, int angle,
                         int dist);
        bool fire_now();
        bool match_random(int n, int &steps);
        uint8_t move_ship();
        void reconstruct_random();
        bool target_reachable(uint8_t &keys);
        void will_get_killed();
        bool will_get_shot();

        int asteroid_mass_, start_asteroid_mass_;
        int level_frame_count_;
        bool random_reconstructed_, target_captured_;

        game_state game_state_, next_game_state_;
        screen_state const &screen_state_;

        enum action_t
        {
            action_shoot
        };

        struct target_t
        {
            int type;
            int alert_level;
            int value;
            action_t action;
        };

        target_t target_;
    };

// class strategy
// public:

    inline strategy::strategy(screen_state const &screen_st)
        :   screen_state_(screen_st),
            target_captured_(false),
            level_frame_count_(0)
    {
    }

} // end of namespace intrepid

#endif // include guard
