// app.hpp
// -------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_APP_HPP
#define INTREPID_APP_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

#include "network.hpp"

namespace intrepid
{
    template<class PlayerImpl>
    class app
    {
    public:
        app();

        int main(int argc, char const *argv[]);

    private:

        app(app const &); // = delete;
        app &operator=(app const &); // = delete;

        void main2();
        void parse_cmdline();

        vector<string>      argv_;
        network<PlayerImpl> network_;
        string              server_;
    };

    struct cmdline_error : public runtime_error
    {
        cmdline_error(string const &msg)
            :   runtime_error(msg)
        { }
    };

// class app
// public:

    template<class PlayerImpl>
    inline app<PlayerImpl>::app()
    {
        // empty
    }

    template<class PlayerImpl>
    int app<PlayerImpl>::main(int argc, const char *argv[])
    {
        try
        {
            try
            {
                argv_.assign(argv, argv + argc);
                main2();
            }
            catch (cmdline_error const &ex)
            {
                clog << "Error: " << ex.what() << endl
                     << "Usage: intrepid.exe <server>" << endl;
                return 1;
            }
        }
        catch (thread_interrupted const &)
        {
        }
        catch (exception const &ex)
        {
            clog << "Error: " << ex.what() << endl;
            return 1;
        }
        catch (...)
        {
            clog << "Error: Unknown exception" << endl;
            return 1;
        }
        return 0;
    }

// class app
// private:

    template<class PlayerImpl>
    void app<PlayerImpl>::main2()
    {
        parse_cmdline();
        network_.run(server_);
    }

    template<class PlayerImpl>
    void app<PlayerImpl>::parse_cmdline()
    {
        if (argv_.size() != 2)
        {
            throw cmdline_error("missing arguments");
        }
        server_ = argv_[1];
    }

} // end of namespace intrepid

#endif // include guard
