// /home/epsilon/Projects/CSharpProjects/WebUtils/OutputUtils/LogOutput.cs created with MonoDevelop
// User: epsilon at 18:53 13.03.2008
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//
// project created on 13.03.2008 at 18:53
using System;
using System.Collections.Generic;

public static class LogOutput
{
	// categories
	public enum Categories { Silence = 0, Error = 1, Warning = 2, Info = 3, Debug = 4 };
	
	// fields
	private static Categories theThreshold = Categories.Debug;
	private static System.Collections.Generic.Dictionary<string, Categories> theModuleThresholds
		= new Dictionary<string, Categories>();
	
	// properties
	public static Categories Threshold
	{
		get {return theThreshold;}
		set {theThreshold = value;}
	}
	
	// methods
	/// specify a threshold for one special module
	public static void SetModuleThreshold(string module, Categories threshold)
	{
		if (theModuleThresholds.ContainsKey(module))
			theModuleThresholds[module]=threshold;
		else
			theModuleThresholds.Add(module, threshold);
	}
	
	public static void RemoveModuleThreshold(string module)
	{
		if (theModuleThresholds.ContainsKey(module))
			theModuleThresholds.Remove(module);
		else
			LogOutput.LogError("LogOutput", "No threshold specified for module " + module);			                     
	}
	
	// logging methods
	//-----------------
	public static void LogDebug(string message)
	{
		LogOutput.LogDebug(null, message);
	}
	
	public static void LogDebug(string module, string message)
	{
		LogOutput.LogMessage(module, "Debug: " + message, Categories.Debug);
	}


	public static void LogInfo(string message)
	{
		LogOutput.LogInfo(null, message);
	}

	public static void LogInfo(string module, string message)
	{
		LogOutput.LogMessage(module, "Info: " + message, Categories.Info);
	}
	
	
	public static void LogWarning(string message)
	{
		LogOutput.LogWarning(null, message);
	}

	public static void LogWarning(string module, string message)
	{
		LogOutput.LogMessage(module, "Warning: " + message, Categories.Warning);
	}


	public static void LogError(string message)
	{
		LogOutput.LogError(null, message);
	}

	public static void LogError(string module, string message)
	{
		LogOutput.LogMessage(module, "Error: " + message, Categories.Error);
	}


	/// Writes the messages to the selected destination
	private static void LogMessage(string module, string message, Categories category)
	{
		if (module != null)
		{
			// special threshold defined for this module?
			if (theModuleThresholds.ContainsKey(module))
			{
				if (category <= theModuleThresholds[module])
					System.Console.Write(module + "(T"
					                     + System.Threading.Thread.CurrentThread.GetHashCode()
					                     + ") - " + message + "\n");
			}
			else
			{
				// message above global threshold?
				if (category <= theThreshold)
					System.Console.Write(module + "(T"
					                     + System.Threading.Thread.CurrentThread.GetHashCode()
					                     + ") - " + message + "\n");
			}
		}
		else
		{
			// message above global threshold?
			if (category <= theThreshold)
			{
				System.Console.Write(message + "\n");
			}
		}
	}
}
