// /home/epsilon/Projects/Asteroid/ABot/Framework1/GLVisualizer/GLShip.cs created with MonoDevelop
// User: epsilon at 22:19 20.04.2008
//

using System;
using GLUtils;
using Tao.OpenGl;


namespace GLVisualizer
{
	public class GLShip : GLUtils.GLObject
	{
		private readonly Vector3 theDirectionPointerColor = new Vector3(0.5f, 0.0f, 0.8f);
		private float theDirectionPointerLength = 300.0f;
		private bool theIsCompiled = false;
		private int theDisplayList;
		
        // constructor: position, size
        public GLShip(Vector3 position, Vector3 size)
			: base (position, size)
        {
			this.Color = new Vector3(0.0f, 0.0f, 1.0f);
        }

        // constructor: position
        public GLShip(Vector3 position)
            : base(position, new Vector3(0.15f, 0.10f, 0.0f))
		{
			this.Color = new Vector3(0.0f, 0.0f, 1.0f);
		}
		
		public GLShip()
			: base(new Vector3(0.0f, 0.0f, 0.0f), new Vector3(0.15f, 0.10f, 0.0f))
		{
			this.Color = new Vector3(0.0f, 0.0f, 1.0f);
		}
		
		public override void Draw()
		{
            Gl.glLoadIdentity(); // Reset The Current Modelview Matrix
            Gl.glTranslatef(thePosition.X, thePosition.Y, thePosition.Z);


			// XYZ-rotation
            // rotation angle must be given in degrees
            Gl.glRotatef((float)(180.0 / Math.PI * theRotation.X), 1.0f, 0.0f, 0.0f);
            Gl.glRotatef((float)(180.0 / Math.PI * theRotation.Y), 0.0f, 1.0f, 0.0f);
            Gl.glRotatef((float)(180.0 / Math.PI * theRotation.Z), 0.0f, 0.0f, 1.0f);
			
			// do not use any texture
			GLScreen.UnbindTexture();
			
			if (!theIsCompiled)
			{
				theDisplayList = Gl.glGenLists(1);
				Gl.glNewList(theDisplayList, Gl.GL_COMPILE);
				this.Compile();
				Gl.glEndList();
				
				theIsCompiled = true;
			}
			
			Gl.glCallList(theDisplayList);
		}
		
		private void Compile()
		{
			// draw shooting line
			Gl.glColor3f(theDirectionPointerColor.X, theDirectionPointerColor.Y, theDirectionPointerColor.Z);
			Gl.glBegin(Gl.GL_LINES);
			{
				Gl.glVertex3f(0.0f, 0.0f, 0.0f); // center
				Gl.glVertex3f(theDirectionPointerLength/Visualizer.theScale, 0.0f, 0.0f);
			}
			Gl.glEnd();

			if (theUseAlphaBlending)
            {
                Gl.glEnable(Gl.GL_BLEND);
                Gl.glColor4f(theColor.X, theColor.Y, theColor.Z, theAlphaBlending);
            }
            else
            {
                Gl.glDisable(Gl.GL_BLEND);
                Gl.glColor3f(theColor.X, theColor.Y, theColor.Z);
            }

           
            Gl.glBegin(Gl.GL_TRIANGLE_STRIP); // draw ship using a triangle strip
            {
				// ship is usually pointing to the right
                Gl.glVertex3f(-0.5f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper left corner
                Gl.glVertex3f(0.5f * theSize.X, 0.0f * theSize.Y, 0.0f); // right middle
                Gl.glVertex3f(-0.25f * theSize.X, 0.0f * theSize.Y, 0.0f); // left middle
                Gl.glVertex3f(-0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower left corner
            }
            Gl.glEnd();	// done drawing the triangle strip

			Gl.glDisable(Gl.GL_BLEND);
		}
	}
}
