unit BufferInterpretieren;

interface

uses
  idglobal,sysutils;

Procedure AnalyzeBuffer(Buffer:TBytes);
Procedure AbstandErmitteln;
Procedure NormalXY(Var x,y:integer);


implementation

uses Asteroids_Main;

Procedure AnalyzeBuffer;
Type
  TTyp = set of (Asteroid1,Asteroid2,Asteroid3,Asteroid4,UFO,Credit,Shot,Ship);
Var
  opcode : word;
  i, xkoord, ykoord, dx, dy, dx1, dy1, z, gsf, s, ShipDetect : integer;
  Typ : TTyp;
  RAM                  : array[0..512]of word;
  c : char;
  scoretext : string;
begin
  for i := 0 to 512 do
    ram[i] := buffer[i*2+1]*256+buffer[i*2];         //nimmt Byte2 und Byte1 und generiert ein 16-bit Word

  i 		 		     := 0;                               //erst einmal alles auf 'Null' setzen
  Actual.Asteroids := 0;                             //Anzahl der identifizierten Asteroiden
  Actual.shots   := 0;                                 //Anzahl der identifizierten Schsse
  Credits 		   := 0;                               //Wieviel 'Leben'
  Ships[Akt_Frame].present  := false;
  Ufos[Akt_Frame].present   := false;
  DumpC          := 0;
  ShipDetect     := 0;
  scoretext      := '';

  Akt_Frame := Buffer[1024];
  Frame_Diff := akt_Frame - Last_frame;
  if Frame_Diff < 0 then inc(Frame_diff,256);
  If Frame_Diff > 1 then
    inc(Drop_Frames,Frame_Diff-1);

  repeat
    opcode := ram[i] shr 12;                         //12 Bits nach rechts schieben, bleiben 4 brig
    c              := ' ';

    if doDump then
      DumpLines[DumpC] := inttostr(i)+'  '+inttohex(ram[i],4);

    if opcode = $A then                              //LABS (Strahl wird auf Mitte der Objekte positioniert)
    begin
      ykoord := ram[i] and $03FF;                    //maskiert die 6-hherwertigen Bits aus und bergibt Wert als y-Koordinate
      xkoord := ram[i+1] and $03FF;
      gsf := ram[i+1] shr 12; 		 		 		 		 	  	 //Globaler Skalierungsfaktor sitzt in den oberen 4 Bits

      if doDump then
        Dumplines[DumpC] := Dumplines[DumpC] + ' '+inttohex(ram[i+1],4)+
                          '  LABS ('+inttostr(ykoord)+','+inttostr(xkoord)+
                          '), GSF '+inttostr(gsf);
      i := i+2;
    end;

    if opcode = $B then
    begin
      if doDump then
      begin
        Dumplines[DumpC] := Dumplines[DumpC] + '       HALT'; //HALT (Ende der RAM-Liste)
        inc(DumpC);
      end;
      break;
    end;

    if opcode = $C then		 		 		 		 		 		 		 	 //JSRL (Springt je nach Objekt zu einer Zeichen-Subroutine)
    begin
      if doDump then
        Dumplines[DumpC] := Dumplines[DumpC] + '       JRSL $'+inttohex(ram[i] and $0FFF,3);
      case (ram[i] and $0FFF) of
        $8F3 : Typ := [Asteroid1];
        $8FF : Typ := [Asteroid2];
        $90D : Typ := [Asteroid3];
        $91A : Typ := [Asteroid4];
        $929 : Typ := [UFO];
        $A6D : Typ := [Credit];
        $B2E : C := '1';
        $B32 : c := '2';
        $B3A : c := '3';
        $B41 : c := '4';
        $B48 : c := '5';
        $B4F : c := '6';
        $B56 : c := '7';
        $B5B : c := '8';
        $B63 : c := '9';
        $ADD : c := '0';
      end;
      inc(i);
    end;

    if opcode = $D then
      inc(i);

    if opcode = $E    then                           //JMPL
      inc(i);                                        //einfach das gesamte Word ignorieren und zum nchsten gehen

    if opcode = $F then
      inc(i);

    if opcode < $A then                              //VCTR (Zeichnet relativ zu LABS das Objekt in Vektoren)
    begin
      dy:= ram[i] and $03FF;                         //maskiert die 6-hherwertigen Bits aus
      if (ram[i] and $400) > 0 then                  //wenn 11tes Bit gesetzt, dann negatives Vorzeichen
        dy := -dy;
      dx:= ram[i+1] and $03FF;
      if (ram[i+1] and $400) > 0 then
        dx := -dx;
      z := ram[i+1] shr 12;		 		 	                 //Helligkeit sitzt im zweiten Word in den oberen 4 Bits
      s := opcode;              		                 //Skalierungsfaktor
      if doDump then
        Dumplines[DumpC] := Dumplines[DumpC] + ' '+inttohex(ram[i+1],4)+
                          '  VCTR ('+inttostr(dy)+','+inttostr(dx)+
                          '), S'+inttostr(s)+', Z'+inttostr(z);


      i := i+2;                                      //jetzt noch 2 Wrter weiter
    end;

    // So, jetzt haben wir mit Sicherheit x,y-Koordinaten, Gren (s), Helligkeiten (z) und Typen
    // Jetzt kann man auch die noch fehlenden Typen identifizieren
    // Shot hat z.B. als einziges Objekt immer die Helligkeit 15
    // Ship hat z.B. als einziges Objekt??? immer die Helligkeit 12


    if (dx = 0) and (dy = 0) and (z =15) then
      Typ := [Shot];

    if (opcode = 6) and (z = 12) and (dx <> 0) and (dy <> 0) then
      typ := [Ship];

    if (c > ' ') and (xkoord < ScreenSizeX / 4) and (s = 7) then
      scoretext := scoretext + c;

    if (typ = [asteroid1]) or (typ = [asteroid2]) or
       (typ = [asteroid3]) or (typ = [asteroid4]) then
    begin
      with Asteroids[Akt_Frame,actual.asteroids] do
      begin
        x 		 := xKoord;
        y 		 := yKoord;
        danger := false;
        Dumpline := i-1;
        case gsf of
          0  : Size := 45;
          15 : Size := 25;
          14 : Size := 9;
        end;
      end;
      inc(Actual.Asteroids);
    end;

    If typ = [Shot] then
    begin
      with Shots[Akt_Frame,actual.shots] do
      begin
        x		 := xKoord;
        y		 := yKoord;
        size := 20;
        Dumpline := i-1;
        danger := false;
      end;
      inc(Actual.shots);
    end;

    if Typ = [UFO] then
    begin
      with Ufos[Akt_Frame] do
      begin
       x 		 := xKoord;
       y		 := yKoord;
       Dumpline := i-1;
       case gsf of
         15 : size := 16;
         14 : size := 8;
       end;
       present := true;
      end;
    end;
    if typ = [Ship] then
      if ShipDetect = 0 then
      begin
        dx1 := dx;                                    //der erste Vektor enthlt den Strich vom Fu zur Spitze (Seite links)
        dy1 := dy;
        Ships[Akt_Frame].present := true;
        ShipDetect := 1;
      end
      else if ShipDetect = 1 then
      begin
          Ships[Akt_Frame].x := xKoord;
          Ships[Akt_Frame].y := yKoord;
          Ships[Akt_Frame].Orx := dx1 - dx;                        //jetzt enthlt Orx,Ory die Ausrichtung (Vektor) des Schiffes
          Ships[Akt_Frame].Ory := dy1 - dy;
          Ships[Akt_Frame].Dumpline := i-1;
          ShipDetect := 2;
      end;
    if typ = [Credit] then
      inc(credits);
    if doDump then
      inc(DumpC);
    typ := [];
  until i > 512;

  if scoretext > '' then
  begin
    if sc > strtoint(scoretext) then inc(wrap);
    sc := strtoint(scoretext);
    score := wrap*100000+sc;
    if score > highscore then
      highscore := score;
  end;

  if actual.Asteroids > max.Asteroids then
    max.Asteroids := actual.Asteroids;
  if actual.shots > max.shots then
    max.shots := Actual.shots;

end;

Procedure AbstandErmitteln;
var
  i,ii,abst_alt,abst_neu : integer;
begin

  if ships[akt_frame].present then
    with Ships[akt_frame] do
    begin
      dx := x - ships[last_frame].x;
      dy := y - ships[last_frame].y;
      vx := x + dx*LookAhead;
      vy := y + dy*LookAhead;
      NormalXY(vx,vy);
    end;

  if (Ufos[akt_frame].present) then
    with Ufos[akt_frame] do
    begin
      dx := x - Ufos[last_frame].x;
      dy := y - Ufos[last_frame].y;
      vx := x + dx*LookAhead;
      vy := y + dy*LookAhead;
      NormalXY(vx,vy);
    end;

   for i:= 0 to actual.Asteroids-1 do
    with Asteroids[Akt_Frame,i] do
    begin
      dx := x - asteroids[Last_Frame,i].x;
      dy := y - asteroids[Last_Frame,i].y;
      vx := x + dx*LookAhead;
      vy := y + dy*LookAhead;
      NormalXY(vx,vy);
      abst_alt := Entfernung(x,y,size,Ships[Akt_Frame].x,Ships[Akt_frame].y);
      abst_neu := Entfernung(vx,vy,size,Ships[Akt_Frame].vx,Ships[Akt_frame].vy);

      if abst_neu < abst_alt then
        danger := true
      else
        danger := false;
    end;

    if ufos[akt_frame].present then
    begin
      for i:=0 to actual.shots-1 do
        with shots[akt_frame,i] do
        begin
          abst_alt := Entfernung(x,y,0,Ufos[Akt_Frame].x,Ufos[Akt_frame].y);
          if abst_alt < 40*40 then
            danger := true
          else
            danger :=false;
        end;
    end;

    for i:=0 to last.shots-1 do
      if shots[last_frame,i].danger then
        for ii:= 0 to actual.shots-1 do
          if entfernung(shots[last_frame,i].x,shots[last_frame,i].y,
                        0,shots[akt_frame,ii].x,
                        shots[akt_frame,ii].y) < 20*20 then
            with shots[akt_frame,ii] do
            begin
              dx := x - shots[last_frame,i].x;
              dy := y - shots[last_frame,i].y;
              danger := shots[last_frame,i].danger;
            end;
end;

Procedure NormalXY;
begin
  if x > ScreenSizeX then
    dec(x,ScreenSizeX)
  else if x < 0 then
    inc(x,ScreenSizeX);
  if y > ScreenMaxY then
    dec(y,ScreenSizeY)
  else if y < ScreenMinY then
    inc(y,ScreenSizeY);
end;

end.
