/* prototypes */
int loop();
void sendkeys();
void receiveframe();
void clear_known_objects();
int InterpretScreen();
unsigned char track_wb(unsigned char wb);
void match_asteroids();
void match_shots();
int inline dist_x(short a, short b);
int inline dist_y(short a, short b);
short inline bound_x(short x);
short inline bound_y(short y);
void set_saucer(int vx,int vy, int sz);
short truncate_screen_fractional (short x);
int highscore_entry(char * name);

/* game states */
#define GAME_STANDBY 0
#define GAME_STARTING 1
#define GAME_OVER 2
#define GAME_LISTENTRY 3

/* sizing constants */
#define MAX_ASTEROIDS 26
#define MAX_UFOS 1
#define MAX_ENTRIES 27
#define MAX_SHOTS 6
#define BOOM_EXPIRE 37
#define SHOT_EXPIRE 69
#define MAX_LATENCY 8
#define MAX_TREAT_NUM (MAX_ASTEROIDS+MAX_SHOTS+MAX_UFOS)
#define MAX_PREDICTION_FRAMES 198
#define SHIP_RAD2 ((64*64)*2)
#define FRAME_INFINITY 999
#define UFO_COLLISION_PREDICTION 128
#define SHIP_SAFETY_TIME 5

// definition of control packet
#define BUTTON_START 32
#define BUTTON_LEFT 16
#define BUTTON_RIGHT 8
#define BUTTON_THRUST 4
#define BUTTON_FIRE 2
#define BUTTON_JUMP 1

/* SCREENOBJECT flags */
#define FREE   0x80
#define ROCK   0x40
#define BOOM   0x20
#define SHOT   0x10
#define KNOWN   0x8
#define IGNORE  0x4
#define GARBAGE 0x2
#define HITS    0x1

struct OUTCMD 
{
 char magic[6];
 unsigned char keys;
 unsigned char ping;
};

// definition of input packet
struct INPKT
{
 union
 {
  unsigned char b[1024];
  unsigned short s[512];
 };
 unsigned char frameno;
 unsigned char ping;
};

// structures describing game elements complete with added info
struct SHIP
{
 short x;
 short y;
 short dx; // movement vector x
 short dy; // movement vector y
 short vx; // movement vector x
 short vy; // movement vector y
 short los_x; // sight vector x
 short los_y; // sight vector y
 short old_los_x; // last sight vector x
 short old_los_y; // last sight vector y
 unsigned int rad2; // ship radius squared
 unsigned char wb; // angle offset
 unsigned char detected; // is a ship on screen?
};

struct POSITION
{
 unsigned short x;
 unsigned short y;
};

struct DELTA
{
 short x;
 short y;
};

// This is a representation of a screen object (shot,explosion,asteroid) together with derived information
struct SCREENOBJECT
{
 // information directly from the vector RAM
 unsigned char typ;
 unsigned char size;
 struct POSITION pos;
 // information created by examining more frames
 struct POSITION realpos;
 struct DELTA delta;
 struct POSITION history[9];
 unsigned char history_count;
 unsigned char flags;
 unsigned char expires;
 unsigned char tbd;
 unsigned int lifetime; // age of the object, age since last direction change for UFO
 unsigned int id; // meaningless object id for easier debugging
 unsigned int rad2;
 short collision_link; // link to an object that will collide (asteroid/shot) 
 short collision_time; // predicted time of collision 
};
