#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <assert.h>
#include "ast.h"
#include "final_shot_table.h"
#include "ship_angle_match.h"
#include "ship_inner_to_outer.h"


/*
 * contains lots of bugs (e.g. no abs for distance, wrong table index in BUTTON_FIRE computation, non working available ammo counter)
 * but the "fixed" version shows about 5000 pts 
 * */

// 2 Includes for socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes for inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes for fcntl(), open(), write()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1

//#define xprintf printf
//#define tprintf printf
//#define gprintf printf
#define xprintf(...) {}
#define tprintf(...) {}
#define gprintf(...) {}

int inline adist_x(short a, short b);
int inline adist_y(short a, short b);

/* global variables */
// socket and logging
int sd; /* udp socket */
unsigned long server_ip;
fd_set readfds, writefds, exceptfds;
int bytes_received,err;
struct timeval zero;
struct sockaddr_in sa;
int logfd,infd;
// data exchange structures
struct OUTCMD keys={"ctmame",0,0};
struct INPKT frame;
// game evaluation globals
short dt; // time passed since last frame
unsigned char discontinuity=1;
struct SHIP ship;
struct SCREENOBJECT preparedshot[(MAX_LATENCY+1)/2]; // here shots are stored until they appear in vector ram
struct SCREENOBJECT shot[6];
struct SCREENOBJECT hittable[MAX_ENTRIES+1]; // last entry for UFO
char hc[MAX_ENTRIES+1];
short cx[MAX_ENTRIES+1];
short cy[MAX_ENTRIES+1];
int shot_nr=0;
int score=0;
int oldscore=0;
int msbscore=0;
int ranging=0;
char screenstring[1024];
int screenchars;
int gamestarted=0;
char gamestate=GAME_STANDBY;
char lifes;
char jump=0;
char sendid=0;
char ufo_detected=0;
char latency=2; // for local network with pinned down sendkeys
char effect_time=1;
char pause_len=0;
int asteroid_nr=0;
int current_id=0;
char asteroid_number[3]; // big medium and small asteroid counter
char asteroids_total;
int framenr=0;
// player name
char pname[4];
char highscore_entered=0;
char total_shots;
int lft=0;
unsigned int astmask;
unsigned int astmask2;
// shot subframe
char subframe=0;
char shot_base_lifetime=SHOT_EXPIRE+3;
char shot_in[6];
// ring buffer for keys init with 0
unsigned char keybuf[MAX_LATENCY];
int keyoffset=0;
int hit_dist[3]={36864,65536,147456};
unsigned char nwb;
unsigned long int maxtime=0;
char scorename[39]="ctnamemuederkrieger                   ";
char plainnames[9][6]={"NONE","SHOT","BOOM","NONE","ROCK","NONE","NONE","NONE","FREE"};

unsigned char update_wb(unsigned char wbo, int t)
{
 unsigned wb=wbo;
 int x=keyoffset+t;
 if (x>latency)  x-=(latency+1); // e.g latency 2: 0+2=2=2 1+2=3=0 2+2=4=1
 if (keybuf[x]&BUTTON_LEFT) wb++;
 if (keybuf[x]&BUTTON_RIGHT) wb--;
 return wb;
}

int wb_dist(unsigned char wb1,unsigned char wb2)
{
 int d1,d2;
 if (wb1>wb2)
 {
  d1=wb2-wb1;
  d2=256-wb1+wb2;
 }
 else
 {
  d1=wb2-wb1;
  d2=wb2-256-wb1;
 }
 if ((abs(d1))<(abs(d2))) return d1; else return d2;
}

int main(int argc, char* argv[])
{
 if ((argc < 2)||(argc>4))
 {
  fprintf(stderr, "Aufruf: asteroid <IP-Adresse> logname\n");
  exit(1);
 }
 server_ip = inet_addr(argv[1]);
 if (server_ip == INADDR_NONE)
 {
  fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", argv[1]);
  exit(1);
 }

 if (argc>=3)
 {
  logfd=open(argv[2],O_WRONLY|O_TRUNC|O_CREAT);
  if (logfd<0) {fprintf(stderr,"could not open %s for write\n",argv[2]);}
 }
 else logfd=-1;

 sd = socket(AF_INET, SOCK_DGRAM, 0);
 if (sd == INVALID_SOCKET)
 {
  fprintf(stderr, "Fehler %d bei socket().\n", errno);
  exit(2);
 }

 if (fcntl(sd, F_SETFL, O_NONBLOCK) == -1)
 {
  perror("Kann Socket nicht auf non-blocking setzen");
  exit(1);
 }
 memset(&sa, 0, sizeof sa);
 sa.sin_family = AF_INET;
 sa.sin_addr.s_addr = 0;
 sa.sin_port = 0;

 if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
 {
  fprintf(stderr, "Fehler %d bei bind().\n", errno);
  exit(2);
 }
 
 loop();
 return 0;
}

int loop ()
{
 unsigned long int ctime;
 struct timespec ts,te;
 int t,s,a,x,y,shot_x,shot_y,ast_hits,ast_hits_next,ast_when;
 int ct,ar,limit,rad,shc,mlt,scan;
 int target,mt;
 unsigned int lx0,ly0,lx1,ly1,ignoreufo,shot_next;
 unsigned char prevframe=0,prevfire=0;
 unsigned char wb0,wb1,wb2;
 unsigned char gamerunning=1;
 unsigned short sxl,syl,sxr,syr,ax,ay;
 short dx,dy;
 unsigned char ral,rar;
 unsigned char first_hit_time[MAX_ENTRIES+1];
 int jump_count=0,jumpstart=0;
 ts.tv_sec=0;
 keys.keys=BUTTON_START;
 sendkeys();
 receiveframe();
 sendid=1;
 ship.rad2=128*128;
 clear_known_objects();
 while (gamerunning)
 {
  keys.ping++;

  // second clock read for execution time determination
  if (clock_gettime(CLOCK_MONOTONIC,&te)==0)
  {
   tprintf("end time is %ld : %ld\n",te.tv_sec,te.tv_nsec);
   if ((te.tv_sec<ts.tv_sec)||((te.tv_sec==ts.tv_sec)&&(te.tv_nsec<ts.tv_nsec)))
    perror("time went backwards!");
   else
   {
    if (ts.tv_sec>0) // if there is no start time yet do not create delta
    {
     if (te.tv_nsec<ts.tv_nsec)
      ctime=1000000000L-ts.tv_nsec+te.tv_nsec;
     else
      ctime=te.tv_nsec-ts.tv_nsec;
     if (ctime>maxtime)
     {
      maxtime=ctime;
      if (maxtime>9000000) printf("time %ld\n",maxtime);
     }
    }
   }
  }
  else
   printf("clock_gettime failed\n");
 
  // send keys only after receiving a frame to get stable latency
  receiveframe();
  framenr++;
  sendkeys();
  keys.keys=0;

  // get start time of frame computation
  if (clock_gettime(CLOCK_MONOTONIC,&ts)==0)
  {
   tprintf("start time is %ld : %ld\n",ts.tv_sec,ts.tv_nsec);
  }
  else
   printf("clock_gettime failed\n");

  // log frame and computed keys (only if log file name given as command line argument)
  if (logfd>=0)
  {
   frame.b[1022]=keys.keys;
   frame.b[1023]=keys.ping;
   write(logfd, frame.b, 1024);
  }

  // compute frame loss dt and latency
  if (discontinuity==0)
  {
   dt=frame.frameno-prevframe;
   if (dt<0) dt=256-prevframe+frame.frameno;
   if (dt>1) printf("Lost %d frame(s).\n",dt-1);
   if (dt>32) discontinuity=1;
   if ((dt==1)&&(framenr>(MAX_LATENCY*2)))
   { // only compute latency if there is no frame drop
    int new_latency;
    if (keys.ping>=frame.ping) new_latency=keys.ping-frame.ping+1; else new_latency=257+keys.ping-frame.ping;
    if (latency!=new_latency) printf("Latency changed from %d to %d\n",latency,new_latency);
    latency=new_latency;
   }
  }
  prevframe=frame.frameno;

  // panic action starts matching from scratch
  if (discontinuity==1) {printf("discontinuity\n");clear_known_objects();discontinuity=2;dt=1;} else discontinuity=0;

  // interpret screen and print short status
  InterpretScreen();
  if (asteroids_total==0) pause_len++; else pause_len=0;

  // fire calibration shot to detect subframe exactly at end of pause
  if ((ranging==2)&&(asteroids_total>0)) ranging=0;
  // jump from center of screen if possible
  if ((ship.x<620*8)&&(ship.x>380*8)&&(ship.y<620*8)&&(ship.y>380*8)&&(asteroids_total>6)&&(asteroids_total<9))
  {
   // jump max once per 4 seconds 
   if (jumpstart+240<framenr) jumpstart=framenr;
   if ((jumpstart<=framenr)&&(framenr<jumpstart+4)) keys.keys|=BUTTON_JUMP;
  }
  if ((asteroids_total==0)&&(ufo_detected==0)&&(ship.detected)&&(ranging==0)&&(frame.s[0]==0xe001))
  {
   printf("FIRE\n");
   keys.keys|=BUTTON_FIRE;
   ranging=2;
  }

  if ((ship.detected)&&(gamestate==1))
  {
   // change wb with the steering commands since last frame
   wb0=ship.wb;
   wb1=ship.wb=update_wb(ship.wb,latency);
   lx0=ship.old_los_x;
   ly0=ship.old_los_y;
   lx1=ship.los_x;
   ly1=ship.los_y;
   
   // correct wb if necessary
   wb2=ship.wb=track_wb(ship.wb);
  }
  
  // check if a ROCK will hit the SHIP within PREDICTION_TIME and when
  for (a=0;a<MAX_ENTRIES;a++) hittable[a].flags&=(~HITS);
  for (t=latency;t<MAX_PREDICTION_FRAMES;t++)
  {
   for (a=0;a<MAX_ENTRIES;a++)
   { // asteroid collision, ignore fully solved asteroids from last call
    if (((hittable[a].flags&(ROCK|HITS))==ROCK)&&((astmask&(1<<a))==0))
    {
     ax=bound_x(hittable[a].realpos.x+t*hittable[a].delta.x);
     ay=bound_y(hittable[a].realpos.y+t*hittable[a].delta.y);
     x=ax-bound_x(ship.x+t*ship.dx);
     y=ay-bound_y(ship.y+t*ship.dy);
     if (x*x+y*y<hit_dist[hittable[a].size]) 
     { // this is the earliest shot opportunity, since it hits the ship it will come to us
      xprintf("ASTEROID %d will hit ship in %d\n",hittable[a].id,t);
      hittable[a].flags|=HITS;
      hittable[a].collision_time=t;
     }
    }
   }
  }
  
  // find out what the shots will hit and when.
  // do not use dist_X functions for distance since objects cannot be hit on both sides of the boundary
  astmask=0; // set mask bit as soon as a solution for this asteroid is found
  for (s=0;s<MAX_SHOTS;s++)
  {
   if (shot[s].flags&SHOT) shot[s].flags&=(~IGNORE); else shot[s].flags|=IGNORE;
   shot_in[s]=255;
  }

  if (ufo_detected) ignoreufo=0; else ignoreufo=1;

  // init asteroid position cache and blind shot counter, so simple addition can be used
  for (a=0;a<MAX_ENTRIES+1;a++)
  {
   hc[a]=0;
   cx[a]=hittable[a].realpos.x;
   cy[a]=hittable[a].realpos.y;
   first_hit_time[a]=90;
  }

  for (a=0;a<MAX_ENTRIES;a++)
  {
   if ((hittable[a].flags&ROCK)==0) astmask|=(1<<a);
  }
  if (ufo_detected==0) astmask|=(1<<27);

  shc=0; // counter in array when shots should be available
  for (s=0;s<latency;s++)
  { // the shots that are not yet visible because of latency
   if (preparedshot[s].flags&SHOT)
   {
    a=preparedshot[s].collision_link;
    if (a>=0)
    {	    
     if ((hc[a]==hittable[a].history_count)||(a==27)) astmask|=(1<<a); else hc[a]++;
    }
    else
    {
     astmask|=(1<<27);
     ignoreufo=1;
    }
    shot_in[shc++]=hittable[a].collision_time;
   }
  }

  if (asteroids_total<2) mlt=1; else mlt=0; // at the end spend more shots for luck
  for (t=0;t<SHOT_EXPIRE+3;t++) //start from t=0 to filter out asteroids that are hit (but nor yet exploded) in this frame
  {
   for (s=0;s<MAX_SHOTS;s++)
   {
    if ((shot[s].flags&IGNORE)==0)
    {
     if (shot[s].lifetime+t>=shot[s].expires)
     {
      if (shot[s].tbd==1)
      {
       shot_in[s]=shot[s].expires-shot[s].lifetime;
       shot[s].flags|=IGNORE;
       break;
      }
     }
     else
     { 
      shot_x=bound_x(shot[s].realpos.x+t*shot[s].delta.x);
      shot_y=bound_y(shot[s].realpos.y+t*shot[s].delta.y);
      for (a=0;a<MAX_ENTRIES+1;a++)
      { // check if it hits a ROCK
       if ((astmask&(1<<a))==0)
       {
        x=abs(cx[a]-shot_x);
        y=abs(cy[a]-shot_y);
        rad=(hittable[a].rad2>>hc[a]);
        if ((x<rad)&&(y<rad)&&(x+y<(rad|(rad>>1))))
        {
         shot[s].flags|=IGNORE;
         if ((x+y<786)&&((hittable[a].history_count<<mlt)<hc[a])&&(hittable[a].flags&KNOWN))
         {
          if (t<first_hit_time[a]) first_hit_time[a]=t;
          // if following shots of a salvo come too late there will probably be no hit,
          // so exclude the asteroid from hit computation
          if ((first_hit_time[a]+hittable[a].size*2<t)||(a==27))
          {
           astmask|=(1<<a);
           hc[a]=hittable[a].history_count<<mlt;
          }
          else
           hc[a]++;
         }
	 else
	  astmask|=(1<<a);
         if (shot[s].tbd==1) {shot_in[shc++]=t;}
         if (a<27)
         { xprintf("SHOT %d will hit ROCK %d size %d in %d frames\n",shot[s].id,hittable[a].id,hittable[a].size,t); }
         else
         { xprintf("SHOT %d will hit UFO in %d frames\n",shot[s].id,t); ignoreufo=1;}
         break; // first hit found
        }
       }
      }
      if (a==MAX_ENTRIES+1)
      { // check if it hits the SHIP
       x=adist_x(ship.x,shot_x);
       y=adist_y(ship.y,shot_y);
       if (x*x+y*y<SHIP_RAD2)
       {
        xprintf("SHOT %d will hit SHIP in %d frames\n",shot[s].id,t);
        if ((t<=SHIP_SAFETY_TIME)&&(shot[s].lifetime>2)) {printf("JUMP\n");keys.keys|=BUTTON_JUMP;}
        break; // first hit found
       }
      }
     }
    }
   }
   for (a=0;a<MAX_ENTRIES+1;a++)
   { // move all remaining asteroids
    if ((astmask&(1<<a))==0)
    {
     cx[a]=bound_x(cx[a]+hittable[a].delta.x);
     cy[a]=bound_y(cy[a]+hittable[a].delta.y);
    }
   }
  }

  // predict number of available shots and when next shot returns
  assert(shc<7);
  total_shots=0;
  shot_next=72;
  for (s=0;s<4;s++)
  {
   if (shot_in[s]-latency>0)
   {
    total_shots++; // shot not available
    if (shot_in[s]<shot_next) shot_next=shot_in[s]; // minimum time until a shot "returns"
   }
  }

  // add all steering commands up to the latency
  nwb=ship.wb;
  for (t=0;t<latency;t++) nwb=update_wb(nwb,t);


  // search harder at end of level
  if (asteroids_total<9) scan=160; else scan=87;
  // create list of targets iterate tru rotation, time, hittime
  astmask2=astmask; // compute earliest hit for all existing and not yet targetted asteroids
  rar=ral=nwb; // init wb for right and left turn
  for (ar=0;ar<scan;ar++) // absolute rotation
  {
   sxr=bound_x(ship.x+shot_angles[rar][0]); // start position of shot (immobile ship)
   syr=bound_y(ship.y+shot_angles[rar][1]);
   sxl=bound_x(ship.x+shot_angles[ral][0]); // start position of shot (immobile ship)
   syl=bound_y(ship.y+shot_angles[ral][1]);
   ct=ar+latency; // base time at start of shot
   limit=71-((frame.frameno+subframe+ct+3+1)&3); // limit to shot range
   for (a=0;a<MAX_ENTRIES+1;a++)
   {
    if ((astmask2&(1<<a))==0)
    {
     cx[a]=bound_x(hittable[a].realpos.x+ct*hittable[a].delta.x);
     cy[a]=bound_y(hittable[a].realpos.y+ct*hittable[a].delta.y);
    }
   }
   for (t=0;t<limit;t++) // t is time from shot
   {
    for (a=0;a<MAX_ENTRIES+1;a++)
    {
     if ((astmask2&(1<<a))==0)
     {
      rad=hittable[a].rad2>>hc[a];
      dx=abs(cx[a]-sxr);
      dy=abs(cy[a]-syr);
      if ((dx<rad)&&(dy<rad)&&(dx+dy<(rad|(rad>>1))))
      {
       astmask2|=(1<<a);
       hittable[a].collision_time=ct;
       hittable[a].collision_link=-ar;
       hittable[a].tbd=rar;
       if (a<27) { xprintf("Can hit ROCK %d when moving right %d in time %d\n",hittable[a].id,ar,t); }
       else { xprintf("Can hit UFO when moving right %d in time %d\n",ar,t);}
      }
      else
      {
       dx=abs(cx[a]-sxl);
       dy=abs(cy[a]-syl);
       if ((dx<rad)&&(dy<rad)&&(dx+dy<(rad|(rad>>1))))
       {
        astmask2|=(1<<a);
        hittable[a].collision_time=ct;
        hittable[a].collision_link=ar;
        hittable[a].tbd=ral;
        if (a<27) { xprintf("Can hit ROCK %d when moving left %d in time %d\n",hittable[a].id,ar,t); }
        else { xprintf("Can hit UFO when moving left %d in time %d\n",ar,t);}
       }
      }
      cx[a]=bound_x(cx[a]+hittable[a].delta.x);
      cy[a]=bound_y(cy[a]+hittable[a].delta.y);
     }
    }
    sxr=bound_x(sxr+shot_angles[rar][2]); // position of shot for time t+1
    syr=bound_y(syr+shot_angles[rar][3]);
    sxl=bound_x(sxl+shot_angles[ral][2]);
    syl=bound_y(syl+shot_angles[ral][3]);
    ct++;
   }
   rar=(rar-1)&0xff;
   ral=(ral+1)&0xff;
  }

  // select dangerous asteroid that is not already targetted at the last moment possible
  // to allow the asteroid into shooting range
  ast_hits=-1;
  ast_hits_next=-1;
  ast_when=MAX_PREDICTION_FRAMES;
  for (a=0;a<MAX_ENTRIES;a++)
  {
   if ((hittable[a].flags&HITS)&&(((astmask&(1<<a))==0)))
   {
    if ((astmask2&(1<<a))==0)
    {
     printf("no solution for asteroid\n");
    }
    else
    { // time for optimal rotation, means latest point in time for all hitting asteroids
     if (ast_when>hittable[a].collision_time) {ast_when=hittable[a].collision_time;ast_hits_next=ast_hits;ast_hits=a;}
    }
   }
  }

  // decide on movement and fire
  if (prevfire==2) prevfire=0;
  if (prevfire==1) prevfire=2;
  if (ast_hits>=0)
  {
   if (hittable[ast_hits].collision_time<(3+abs(hittable[ast_hits].collision_link))) keys.keys=BUTTON_JUMP;
   if (hittable[ast_hits].collision_time>(28+abs(hittable[ast_hits].collision_link)+(hittable[ast_hits].size+1)*3)) ast_hits=-1;
  }
  mt=900;
  target=ast_hits;
  if ((gamestate==1)&&(ship.detected)) // TBD latency (ship_expected after jump)
  {
   if (ast_hits==-1)
   {
    if ((asteroids_total<4)&&(asteroids_total>0)&&(astmask!=0x7ffffff)) ignoreufo=1; // for the last 3 asteroids do ignore ufo, ufo stays between stages
    if (ignoreufo==0)
    { // no asteroid threat, then combat ufo
     if (hittable[27].collision_link>0) keys.keys|=BUTTON_LEFT;
     if ((hittable[27].collision_link==0)&&(prevfire==0)&&(total_shots<4)) {keys.keys|=BUTTON_FIRE;ignoreufo=1;target=27;}
     if (hittable[27].collision_link<0) keys.keys|=BUTTON_RIGHT;
    }
    if (ignoreufo==1)
    { // get fastest hit from opportunity list
     for (a=0;a<MAX_ENTRIES;a++)
     {
      if (((astmask&(1<<a))==0)&&(astmask2&(1<<a))&&(hittable[a].collision_time<mt)&&((hittable[a].size==0)||(asteroids_total<19))) {mt=hittable[a].collision_time;ast_hits=a;}
     }
    }
   }
   if (ast_hits>=0)
   {
    if ((prevfire==0)&&(total_shots<4))
    {
     if (hittable[ast_hits].collision_link==0)
     {
      astmask|=(1<<ast_hits);
      keys.keys|=BUTTON_FIRE;
      target=ast_hits;
      if (ast_hits_next!=-1)
      {
       ast_hits=ast_hits_next; // turn to next after firing on last
      }
      else
      {
       if (asteroids_total>1)
       {
        astmask|=(1<<ast_hits);
        mt=900;
        for (a=0;a<MAX_ENTRIES;a++)
        {
         if (((astmask&(1<<a))==0)&&(astmask2&(1<<a))&&(hittable[a].collision_time<mt)&&((hittable[a].size==0)||(asteroids_total<20))) {mt=hittable[a].collision_time;ast_hits_next=a;}
        }
       }
      }
     }
     else
     { // check for opportunity shot
      for (a=0;a<MAX_ENTRIES+1;a++)
      {
       if (((astmask&(1<<a))==0)&&(astmask2&(1<<a))&&(hittable[a].collision_link==0)&&(total_shots<4)&&(abs(hittable[ast_hits].collision_link)>1))
       {
        target=a;
        // only fire on far targets if enough ammo is available 
        if (
             (total_shots<2) // should not let these shots idle around
           ||((total_shots<3)&&(hittable[ast_hits].size==0)) // prioritize small asteroids
           ||(  (total_shots<4) // medium distance objects
              &&(hittable[ast_hits].flags&KNOWN)
              &&((dist_x(ship.x,hittable[ast_hits].pos.x)+dist_y(ship.x,hittable[ast_hits].pos.y)<220*8))
             )
           ||((total_shots<4)&&((dist_x(ship.x,hittable[ast_hits].pos.x)+dist_y(ship.x,hittable[ast_hits].pos.y))<100*8)) // near objects without good prediction
           )
         keys.keys|=BUTTON_FIRE;
        break;
       }
      }
     }
    }
    // if it is possible to get to the colliding asteroid by turning the other way round, the compute the better way
    if ((ast_when+(hittable[ast_hits].size+1*2))>(86-abs(hittable[ast_hits].collision_link)))
    {
     int prefered_turn=0; // + is left - is right
     for (a=0;a<MAX_ENTRIES+1;a++)
     { // for all asteroids than are not yet solved and that have a solution check if left or right turn would be good
      if (((astmask&(1<<a))==0)&&(astmask2&(1<<a)))
      {
       if (hittable[a].collision_time-abs(hittable[ast_hits].collision_link)<30)
       {
        if (hittable[a].collision_link>=0) prefered_turn+=(hittable[ast_hits].size+1); else prefered_turn-=(hittable[ast_hits].size+1);
       }
      }
     }
     if (((prefered_turn<0)&&(hittable[ast_hits].collision_link>0))||((prefered_turn>0)&&(hittable[ast_hits].collision_link<0))) hittable[ast_hits].collision_link=-hittable[ast_hits].collision_link;
    }

    if (hittable[ast_hits].collision_link>0) keys.keys|=BUTTON_LEFT;
    if (hittable[ast_hits].collision_link<0) keys.keys|=BUTTON_RIGHT;
   }
  }

  if (asteroids_total>23) printf("!ast %d\n",asteroids_total);
  // between stages face toward edges where most asterois spawn
  if ((keys.keys==0)&&(asteroids_total==0)&&(ship.detected)&&((keys.keys&BUTTON_THRUST)==0))
  {
   if (ufo_detected==1)
   {
    if (hittable[27].collision_link>0) keys.keys|=BUTTON_LEFT;
    if (hittable[27].collision_link<0) keys.keys|=BUTTON_RIGHT;
   }
   else
   { 
    keys.keys=BUTTON_RIGHT;
    if (ship.x>524*8)
    {
     if (ship.y>524*8)
     { // right upper
      if (((ship.los_x>900)&&(ship.los_x<1200))&&((ship.los_y>900)&&(ship.los_y<1200))) keys.keys=0;
     }
     else
     { // right lower
      if (((ship.los_x>900)&&(ship.los_x<1200))&&((ship.los_y<-900)&&(ship.los_y>-1200))) keys.keys=0;
     }
    }
    else
    {
     if (ship.y>524*8)
     { // left upper
      if (((ship.los_x<-900)&&(ship.los_x>-1200))&&((ship.los_y>900)&&(ship.los_y<1200))) keys.keys=0;
     }
     else
     {
      // left lower
      if (((ship.los_x<-900)&&(ship.los_x>-1200))&&((ship.los_y<-900)&&(ship.los_y>-1200))) keys.keys=0;
     }
    }
   }
  }
   
  // put steering command in ringbuffer
  keyoffset--;
  if (keyoffset<0) keyoffset=latency;
  keybuf[keyoffset]=keys.keys; // oldest entry becomes newest entry
 
  // prevent headless jumping around
  if (jump_count==4) keys.keys&=~BUTTON_JUMP;
  if (keys.keys&BUTTON_JUMP) jump_count++; else jump_count=0;
 
  // prepare prediction
  if (keys.keys&BUTTON_FIRE)
  { // save the fact that we SHOT, to have perfect shot prediction without training phase
   //printf("fire\n");
   prevfire=1;
   for (s=0;s<latency;s++) if (preparedshot[s].flags&FREE) break;
   preparedshot[s].realpos.x=bound_x(ship.x+shot_angles[nwb][0]);
   preparedshot[s].realpos.y=bound_y(ship.y+shot_angles[nwb][1]);
   preparedshot[s].collision_link=target;
   preparedshot[s].collision_time=hittable[target].collision_time+1;
   preparedshot[s].pos.x=truncate_screen_fractional(preparedshot[s].realpos.x);
   preparedshot[s].pos.y=truncate_screen_fractional(preparedshot[s].realpos.y);
   preparedshot[s].delta.x=shot_angles[nwb][2];
   preparedshot[s].delta.y=shot_angles[nwb][3];
   preparedshot[s].flags=SHOT|KNOWN;
   preparedshot[s].lifetime=latency+effect_time; // to flush entry in case the shot does not appear
  }
 }
 return 0;
}

void clear_known_objects()
{
 int i;
 for (i=0;i<MAX_ENTRIES;i++) hittable[i].flags=FREE;
 for (i=0;i<MAX_SHOTS;i++) {shot[i].flags=FREE;shot[i].lifetime=0;}
 for (i=0;i<(MAX_LATENCY+1)/2;i++) preparedshot[i].flags=FREE;
}

void receiveframe()
{
 struct timeval five;
 int cntSockets;

 five.tv_sec=5;
 five.tv_usec=0;
 do
 {
  FD_ZERO(&readfds);
  FD_ZERO(&writefds);
  FD_ZERO(&exceptfds);
  FD_SET(sd, &readfds);
  FD_SET(sd, &exceptfds);
  cntSockets=select(sd+1,&readfds,&writefds,&exceptfds,&five);
  if (cntSockets==0)
  {
   fprintf(stderr, "Socket timeout\n");
   exit(0);
  } 
  bytes_received = recv(sd, (char *)&frame, sizeof(frame), 0);
  if (bytes_received != sizeof(frame))
  {
   if (strncmp("game over",(char *)&frame.b[0],9)==0) {fprintf(stderr,"Score %d lifes %d max time %ld\n",msbscore*100000+score,lifes,maxtime);exit(0);};
   fprintf(stderr, "Fehler %d bei recvfrom(). string %s\n", errno,(char*)&frame.s[0]);
   exit(0);
  }
  FD_ZERO(&readfds);
  FD_ZERO(&writefds);
  FD_ZERO(&exceptfds);
  FD_SET(sd, &readfds);
  zero.tv_sec = zero.tv_usec = 0;
  select(sd+1, &readfds, &writefds, &exceptfds, &zero);
 } while (FD_ISSET(sd, &readfds));
}

void sendkeys()
{
 struct sockaddr_in server;
 memset(&server, 0, sizeof server);
 server.sin_family = AF_INET;
 server.sin_port = htons(1979);
 server.sin_addr.s_addr = server_ip;
 if (sendid)
 {
  int i;
  sendid=0;
  for (i=0;i<38;i++) if (scorename[i]==' ') scorename[i]=0;
  sendto(sd,scorename,38, 0, (struct sockaddr*)&server, sizeof server);
 }
 if (sizeof(keys) != sendto(sd, (char *)&keys, sizeof(keys), 0, (struct sockaddr*)&server, sizeof server))
 {
  if (errno != EAGAIN)
  {
   perror("Fehler bei sendto()");
   exit(1);
  }
 }
}

// compute smallest absolute distance in x direction (1024*8 subpixel)
int inline adist_x(short a, short b)
{
 int d1,d2;
 if (a>b)
 {
  d1=a-b;
  d2=8*1024-a+b;
 }
 else
 {
  d1=b-a;
  d2=8*1024-b+a;
 }
 if (d1<d2) return d1; else return d2;
}

// compute smallest distance in x direction (1024*8 subpixel)
int inline dist_x(short a, short b)
{
 int d1,d2;
 if (a>b)
 {
  d1=a-b;
  d2=8*1024-a+b;
  if (d1<d2) return -d1; else return d2;
 }
 else
 {
  d1=b-a;
  d2=8*1024-b+a;
  if (d1<d2) return d1; else return -d2;
 }
}

// compute absolute smallest distance in y direction (768*8 subpixel)
int inline adist_y(short a, short b)
{
 int d1,d2;
 if (a>b)
 {
  d1=a-b;
  d2=8*768+b-a; // 8*(986-a)+(b-128)
 }
 else
 {
  d1=b-a;
  d2=8*768+a-b; // 8*(986-b)+(a-128)
 }
 if (d1<d2) return d1; else return d2;
}

// compute smallest distance in y direction (768*8 subpixel)
int inline dist_y(short a, short b)
{
 int d1,d2;
 if (a>b)
 {
  d1=a-b;
  d2=8*768+b-a; // 8*(986-a)+(b-128)
  if (d1<d2) return -d1; else return d2;
 }
 else
 {
  d1=b-a;
  d2=8*768+a-b; // 8*(986-b)+(a-128)
  if (d1<d2) return d1; else return -d2;
 }
}

// keep shot direction accurate by examining visual ship directions
unsigned char track_wb(unsigned char wbo)
{
 unsigned char wb=wbo;
 int ko=keyoffset+latency;
 int i;

 if (ko>latency) ko-=(latency+1);
 // only check transition if there was no frame drop AND if there was a movement
 if ((discontinuity==0)&&(keybuf[ko]&(BUTTON_LEFT|BUTTON_RIGHT)))
 {
  if ((ship.los_x!=ship.old_los_x)||(ship.los_y!=ship.old_los_y))
  { // check the unique visual angle transitions
   for (i=0;i<4;i++)
   {
    if ((keybuf[ko]&BUTTON_LEFT)&&(ship.los_x==i2o_table2[i][2])&&(ship.los_y==i2o_table2[i][3])&&(ship.old_los_x==i2o_table2[i][0])&&(ship.old_los_y==i2o_table2[i][1])) {wb=i2o_table2[i][4]+1;break;}
    if ((keybuf[ko]&BUTTON_RIGHT)&&(ship.los_x==i2o_table2[i][0])&&(ship.los_y==i2o_table2[i][1])&&(ship.old_los_x==i2o_table2[i][2])&&(ship.old_los_y==i2o_table2[i][3])) {wb=i2o_table2[i][4];break;}
   }
  }
  else
  { // check the visual angle invariant transitions
   for (i=0;i<60;i++)
   {
    if ((ship.los_x==i2o_table1[i][0])&&(ship.los_y==i2o_table1[i][1]))
    {
     wb=i2o_table1[i][2];
     if (keybuf[ko]&BUTTON_LEFT) wb++;
     break;
    }
   }
  }
 }
 else
 {
  if ((visual_angle_table[wb][0]!=ship.los_x)||(visual_angle_table[wb][1]!=ship.los_y))
  {
   for (wb=0;wb<255;wb++) if ((visual_angle_table[wb][0]==ship.los_x)&&(visual_angle_table[wb][1]==ship.los_y)) break;
  }
 }
 ship.old_los_x=ship.los_x;
 ship.old_los_y=ship.los_y;
 if (wbo!=wb) printf("Supposed angle byte: %d real angle byte %d\n",wbo,wb);
 return wb;
}

// keep a predicted x screen position (value with 3 fractional bits) within screen bounds
short inline bound_x(short x) { return x&0x1fff; }

// keep a predicted y screen position (value with 3 fractional bits) within screen bounds
short inline bound_y(short y)
{
 short yt=y;
 while (yt>=(896*8)) yt-=(768*8); // keep ay inside displayed area
 while (yt<128*8) yt+=(768*8);
 return yt;
}

// returns fractional with number with fractional part set to 0, only valid for positive numbers
short truncate_screen_fractional (short x) { return (x&0xfff8); }

// ufo prediction: ufo seems to move 0 or 16 subpixels on each axis
void set_saucer(int x,int y, int sz)
{
 short dx,dy;
 ufo_detected=1;
 hittable[27].size=(sz+2)&3;
 if (((hittable[27].flags&KNOWN)||(hittable[27].lifetime==1)))
 {
  dx=dist_x(hittable[27].realpos.x,x)/dt;
  dy=dist_y(hittable[27].realpos.y,y)/dt;
  if (hittable[27].lifetime>1)
  {
   if ((hittable[27].delta.x!=dx)||(hittable[27].delta.y!=dy))
   { // ufo has changed direction, reset lifetime to 0
    printf("UFO changed direction at %d/%d from %d/%d to %d/%d after %d\n",hittable[27].realpos.x,hittable[27].realpos.y,hittable[27].delta.x,hittable[27].delta.y,dx,dy,hittable[27].lifetime);
   }
  }
  hittable[27].flags=KNOWN;
  hittable[27].delta.x=dx;
  hittable[27].delta.y=dy;
  hittable[27].realpos.x=x;
  hittable[27].realpos.y=y;
 }
 else
 { // new UFO
  hittable[27].realpos.x=x;
  hittable[27].realpos.y=y;
  hittable[27].rad2=64<<hittable[27].size;
  hittable[27].history_count=0;
  printf("new UFO at %d/%d size %d\n",hittable[27].realpos.x,hittable[27].realpos.y,hittable[27].rad2);
 }
}

// check if an object fits in with the prediction. If yes, update object
int perform_prediction(struct SCREENOBJECT * tab,short flags,short typ,short size,unsigned short x,unsigned short y)
{
 short allowed_distance,dx,dy,j,tpx,tpy;
 unsigned char nonlin_x,nonlin_y,minrunval,bestrunstart,runstart;

 // check type and size match if event is ROCK
 if (flags&ROCK)
 {
  if ((tab->typ!=typ)||(tab->size!=size)) return 0; // type and size must be identical
  if (tab->flags&BOOM) return 0; // ROCK does not match explosion
 }
 if (tab->flags&FREE) return 0; // should have been obvious ...
 if (tab->flags&KNOWN)
 { // use prefect prediction
  dx=bound_x(tab->realpos.x+tab->delta.x*dt);
  dy=bound_y(tab->realpos.y+tab->delta.y*dt);
  if ((truncate_screen_fractional(dx)==x)&&(truncate_screen_fractional(dy)==y))
  {
   tab->pos.x=x;
   tab->pos.y=y;
   tab->realpos.x=dx;
   tab->realpos.y=dy;
   xprintf("%s %d perfect prediction OK at %d/%d (%d/%d) lt %d\n",plainnames[tab->flags>>4],tab->id,x,y,dx,dy,tab->lifetime);
   return 1;
  }
  xprintf("%s %d perfect prediction failed\n",plainnames[tab->flags>>4],tab->id);
  return 0;
 }
 else
 { // use approximated prediction, do not use dt, because holes in the history prevent perfect prediction
  if (tab->lifetime==1) // object is still NEW, so check absolute distances
  {
   if (tab->flags&SHOT) allowed_distance=111; else allowed_distance=64;
   dx=adist_x(tab->pos.x,x);
   dy=adist_y(tab->pos.y,y);
   if ((dx<=allowed_distance)&&(dy<=allowed_distance))
   {
    tab->pos.x=x;
    tab->pos.y=y;
    tab->realpos.x=x;
    tab->realpos.y=y;
    tab->history[1].x=x;
    tab->history[1].y=y;
    tab->delta.x=dist_x(tab->history[0].x,x);
    tab->delta.y=dist_y(tab->history[0].y,y);
    xprintf("%s %d 2nd sighting at %d/%d delta %d/%d\n",plainnames[tab->flags>>4],tab->id,x,y,tab->delta.x,tab->delta.y);
    return 1;
   } 
   return 0;
  }
  else // between NEW and KNOWN
  {
   if (tab->flags&SHOT) allowed_distance=16; else allowed_distance=8;
   dx=adist_x(bound_x(tab->pos.x+tab->delta.x),x);
   dy=adist_y(bound_y(tab->pos.y+tab->delta.y),y);
   if ((dx<=allowed_distance)&&(dy<=allowed_distance))
   {
    tab->pos.x=x;
    tab->pos.y=y;
    tab->realpos.x=x;
    tab->realpos.y=y;
    tab->history[tab->lifetime].x=x;
    tab->history[tab->lifetime].y=y;
    if ((tab->lifetime==2)||(tab->lifetime==4)||(tab->lifetime==8))
    { // compute dx and dy (2 deltas -> 1 fractional bit,4 deltas 2 fractional bits, 8 deltas all fractional bits)
     tab->delta.x=dist_x(tab->history[0].x,x)/tab->lifetime;
     tab->delta.y=dist_y(tab->history[0].y,y)/tab->lifetime;
    }
    xprintf("%s %d lt %d found again %d/%d delta %d/%d\n",plainnames[tab->flags>>4],tab->id,tab->lifetime,tab->pos.x,tab->pos.y,tab->delta.x,tab->delta.y);
    if (tab->lifetime==8)
    { // additionally compute subpixel position
     tab->flags|=KNOWN;
     tpx=(tab->delta.x/8)*8; // get truncated factor
     tpy=(tab->delta.y/8)*8;
     // extract the nonlinear jumps in the shot position deltas
     nonlin_x=0;
     nonlin_y=0;
     for (j=0;j<8;j++)
     {
      nonlin_x=nonlin_x<<1;
      nonlin_y=nonlin_y<<1;
      if (bound_x(tab->history[j].x+tpx)!=tab->history[j+1].x) nonlin_x|=1;
      if (bound_y(tab->history[j].y+tpy)!=tab->history[j+1].y) nonlin_y|=1;
     }
     if (tab->delta.x<0) nonlin_x^=0xff; // invert skips in case of subtraction
     if (tab->delta.y<0) nonlin_y^=0xff;
     // get offset in cyclic deltas where least nonlinearities are located toward the start.
     // This marks the 0 point of the subpixels within the delta
     // incidentally that corresponds to rotating the nonlin_X byte and looking for the smallest value!
     // for x
     minrunval=255;bestrunstart=0;
     for (runstart=0;runstart<8;runstart++)
     {
      if (nonlin_x<minrunval) {minrunval=nonlin_x;bestrunstart=runstart;};
      nonlin_x=(nonlin_x<<1)|(nonlin_x>>7); // rotate byte
     }
     // set subpixel value for current position
     tab->realpos.x=bound_x(tab->history[bestrunstart].x+(8-bestrunstart)*tab->delta.x);
     // for y
     minrunval=255;bestrunstart=0;
     for (runstart=0;runstart<8;runstart++)
     {
      if (nonlin_y<minrunval) {minrunval=nonlin_y;bestrunstart=runstart;};
      nonlin_y=(nonlin_y<<1)|(nonlin_y>>7);
     }
     tab->realpos.y=bound_y(tab->history[bestrunstart].y+(8-bestrunstart)*tab->delta.y);
    }
    return 1;
   }
   return 0;
  }
 }
}

// Parse the vector RAM content into ship, ufo, asteroid and shot structures
int InterpretScreen()
{
 short x=0,y=0,v1x=0,v1y=0,vs=1024,matching_shot,spx,spy; 
 int screendigits,op,pc,i,j,dx,dy,sf,vz,dist,dist_min,s;
 unsigned char tmp_flags,tmp_typ,lockscore,shipdetect=0;
 char ch,sc;
 int pchar=-1;
 pname[0]=pname[1]=pname[2]='?';
 ship.y=ship.x=524*8;

 // first expire explosions with fixed lifetime
 // also remove ROCKS that are not KNOWN if dt>1
 for (i=0;i<MAX_ENTRIES;i++)
 {
  if ((hittable[i].flags&BOOM)&&(hittable[i].lifetime>=BOOM_EXPIRE))
  {
   hittable[i].flags=FREE;
   xprintf("Expired BOOM at %d/%d (%d) frame %d\n",hittable[i].pos.x,hittable[i].pos.y,i,framenr);
  }
  if ((hittable[i].flags&FREE)==0) hittable[i].flags|=GARBAGE;
  if ((dt>1)&&(hittable[i].flags&ROCK)&&((hittable[i].flags&KNOWN)==0)) hittable[i].flags=FREE;
 }

 // expire shots with not so fixed lifetime between 69 and 72 frames
 // also remove SHOTS that are not KNOWN if dt>1
 for (i=0;i<MAX_SHOTS;i++)
 {
/*
  if ((shot[i].flags&SHOT)&&(shot[i].lifetime>=shot_base_lifetime+(((subframe+shot[i].subframe)&3)^3)))
  {
   shot[i].flags=FREE;
   xprintf("Expired SHOT %d lt %d (max %d) at %d/%d\n",shot[i].id,shot[i].lifetime,shot_base_lifetime+(((subframe+shot[i].subframe)&3)^3),shot[i].pos.x,shot[i].pos.y);
  }
*/
  if ((shot[i].flags&FREE)==0) shot[i].flags|=GARBAGE;
  if ((dt>1)&&((shot[i].flags&KNOWN)==0)) shot[i].flags=FREE;
 }

 shot_nr=0;
 asteroid_number[0]=0; // small medium and big asteroid counter
 asteroid_number[1]=0;
 asteroid_number[2]=0;
 asteroids_total=0;
 total_shots=0;
 asteroid_nr=0; // index in asteroid table, not real count
 ufo_detected=0;
 ship.detected=0;
 screenchars=0;
 screenstring[0]=0;
 lifes=0;
 screendigits=0;
 oldscore=score;
 score=0;
 lockscore=0;
 if ((frame.s[0] != 0xe001)&&(frame.s[0] != 0xe201))
  printf("Unknown header %x\n",frame.s[0]); // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
 else
 for (pc=1;pc<0x200;pc++)
 {
  tmp_flags=FREE;
  tmp_typ=0;
  sc=-1; // invalid parsed decimal 
  ch=0; // invalid parsed character
  op = frame.s[pc] >> 12;
  switch (op)
  {
   case 0xa: // LABS
    y = (frame.s[pc] & 0x3ff)<<3; // convert into subpixel format here
    x = (frame.s[pc+1] & 0x3ff)<<3;
    vs = frame.s[pc+1] >> 12;
    if ((x==800)&&(y==7008)) lockscore=0; else lockscore=1;
    if ((x==3200)&&(y==1824)) pchar=0; else pchar=-1;
   break;
   case 0xb: pc=0x200; break;// HALT
   case 0xc: // JSRL
    switch (frame.s[pc] & 0xfff)
    {
     if (vs==1024)
     {
      fprintf(stderr,"No absolute coordinates before relative coordinates.\n");
     }
     case 0x8b5: // start frame of explosion animation
     // if (vs==11) tmp_flags=NEW_COUNTER;
     case 0x880:
     case 0x896:
     case 0x8d0: tmp_flags=BOOM; break;
     case 0x8f3: tmp_typ=1; break; // asteroid type 1
     case 0x8ff: tmp_typ=2; break; // asteroid type 2
     case 0x90d: tmp_typ=3; break; // asteroid type 3
     case 0x91a: tmp_typ=4; break; // asteroid type 4
     case 0x929: set_saucer(x,y,vs); break; // UFO
     case 0xa6d: lifes++; break;// ship symbol
     case 0xadd: sc=0; break; // 0 or O
     case 0xb2c: // space character, used to terminate numbers and words
     {
      if (screenchars>0)
      {
       if (strcmp(screenstring, "STARTKNOEPFE") == 0) gamestate=GAME_STANDBY;
       else if (strcmp(screenstring, "SPIELER") == 0) {gamestate=GAME_STARTING;highscore_entered=0;}
       else if (strcmp(screenstring, "SPIELENDE") == 0) gamestate=GAME_OVER;
       else if (strcmp(screenstring, "BUCHSTABENWAHL") == 0) gamestate=GAME_LISTENTRY;
      }
      screenchars=0; // because each score is also seen as string
      break;
     }
     case 0xb2e: sc=1; break; // 1
     case 0xb32: sc=2; break; 
     case 0xb3a: sc=3; break; 
     case 0xb41: sc=4; break; 
     case 0xb48: sc=5; break;
     case 0xb4f: sc=6; break;
     case 0xb56: sc=7; break;
     case 0xb5b: sc=8; break;
     case 0xb63: sc=9; break;
     case 0xA78: ch='A'; break; // A
     case 0xA80: ch='B'; break;
     case 0xA8D: ch='C'; break;
     case 0xA93: ch='D'; break;
     case 0xA9B: ch='E'; break;
     case 0xAA3: ch='F'; break;
     case 0xAAA: ch='G'; break;
     case 0xAB3: ch='H'; break;
     case 0xABA: ch='I'; break;
     case 0xAC1: ch='J'; break;
     case 0xAC7: ch='K'; break;
     case 0xACD: ch='L'; break;
     case 0xAD2: ch='M'; break;
     case 0xAD8: ch='N'; break;
     case 0xAE3: ch='P'; break;
     case 0xAEA: ch='Q'; break;
     case 0xAF3: ch='R'; break;
     case 0xAFB: ch='S'; break;
     case 0xB02: ch='T'; break;
     case 0xB08: ch='U'; break;
     case 0xB0e: ch='V'; break;
     case 0xB13: ch='W'; break;
     case 0xB1a: ch='X'; break;
     case 0xB1f: ch='Y'; break;
     case 0xB26: ch='Z'; break;
    }
   break;
   case 0xd: // RTSL
   case 0xe: pc=0x200; break;// and JMPL
   case 0xf: // SVEC
   break;
   default:
    dy = frame.s[pc] & 0x3ff;
    if ((frame.s[pc] & 0x400) != 0) dy = -dy;
    dx = frame.s[pc+1] & 0x3ff;
    if ((frame.s[pc+1] & 0x400) != 0) dx = -dx;
    sf = op;
    vz = frame.s[pc+1] >> 12;
    if (dx == 0 && dy == 0 && vz == 15) tmp_flags=SHOT;
    if (op == 6 && vz == 12 && dx != 0 && dy != 0)
    {
     switch (shipdetect)
     {
      case 0: // first long ship vector found
       v1x = dx;
       v1y = dy;
       ++shipdetect;
      break;
      case 1: // second long ship vector found, addition of long ship vectors gives line of sight vector
       ship.detected=1;
       ship.x = x;
       ship.y = y;
       ship.los_x = v1x - dx;
       ship.los_y = v1y - dy;
       ++shipdetect;
      break;
     }
    }
    else if (shipdetect == 1) shipdetect = 0; // there should be no vector between the long vectors
   break;
  }
  
  if (tmp_typ!=0) tmp_flags=ROCK;
  if ((lockscore==0)&&(sc>=0)) score=score*10+sc; // shift in decimal
  if ((lockscore==1)&&(sc==0)) ch='O';
  if ((pchar>-1)&&(ch!=0)) {pname[pchar++]=ch;}
  if (ch!=0) {screenstring[screenchars++]=ch;screenstring[screenchars]=0;} // append character
  if (op <= 0xa) ++pc;
  if (tmp_flags!=FREE)
  {
   if ((tmp_flags&SHOT)==0)
   { // work on the ROCK/BOOM structure
    // convert size into something useful small:0 medium:1 large:2
    vs=(vs+2)&3;
    // first get a possible UFO explosion out of the way
    if ((ufo_detected!=1)&&(asteroid_nr==0)&&(tmp_flags&BOOM)&&(hittable[27].realpos.x==x)&&(hittable[27].realpos.y==y))
    {
     xprintf("UFO exploded at %d/%d anr %d\n",x,y,asteroid_nr);
     tmp_flags=FREE;
    }
    if (asteroid_nr>=MAX_ENTRIES)
    {
     for (i=MAX_ENTRIES-1;i>-1;i--) if (hittable[i].flags&FREE) break;
     if (i==-1)
     {
      printf("Asteroid buffer overflow\n");
      for (i=0;i<MAX_ENTRIES;i++) hittable[i].flags=FREE;
      return 1;
     }
     else
     {
      printf("memmove compact at end of asteroid buffer in frame %d index %d\n",framenr,asteroid_nr);
      memmove((void *)&hittable[i],(void *)&hittable[i+1],sizeof(struct SCREENOBJECT)*(MAX_ENTRIES-1-i));
      asteroid_nr--;
      hittable[asteroid_nr].flags=FREE;
     }
/*
     printf("in frame %d\n",framenr);
     for (i=0;i<MAX_ENTRIES;i++)
     {
      printf("Entry %d:\n",i);
      printf(" type %s flags raw %x flags %x size %d\n",plainnames[(hittable[i].flags&(ROCK|SHOT|BOOM|FREE))>>4],hittable[i].flags,hittable[i].flags&(~(ROCK|SHOT|BOOM|FREE)),hittable[i].size);
   
      printf(" pos %d/%d\n",hittable[i].pos.x,hittable[i].pos.y);
      printf(" realpos %d/%d\n",hittable[i].realpos.x,hittable[i].realpos.y);
      printf(" delta %d/%d\n",hittable[i].delta.x,hittable[i].delta.y);
      printf(" lifetime %d tbd %d link %d time %d\n",hittable[i].lifetime,hittable[i].tbd,hittable[i].collision_link,hittable[i].collision_time);
     }
     printf("Asteroid buffer overflow\n");asteroid_nr=0;discontinuity=1;
*/
    }
    // now match other BOOM events
    else if (tmp_flags&BOOM)
    { // merge BOOM
     for (i=asteroid_nr;i<MAX_ENTRIES;i++)
     {
      if ((hittable[i].flags&(BOOM|ROCK|FREE))&&(hittable[i].pos.x==x)&&(hittable[i].pos.y==y))
      {
       if (hittable[i].flags&ROCK)
       {
        dist_min=0x7fffffff;
        xprintf("ROCK %d exploded after %d at %d/%d\n",hittable[i].id,hittable[i].lifetime,x,y);
        // search a matching shot
        for (j=0;j<MAX_SHOTS;j++)
        { // check if the shot matches an existing one
         if ((shot[j].flags&(FREE|GARBAGE))&&(shot[j].lifetime<68)&&(shot[j].lifetime>8))
         {
          spx=dist_x(shot[j].realpos.x,hittable[i].realpos.x);
          spy=dist_y(shot[j].realpos.y,hittable[i].realpos.y);
          //dist=spx*spx+spy*spy;
          if ((abs(spx)<360)&&(abs(spy)<360)) dist=spx*spx+spy*spy; else dist=0x7fffffff;
          if (dist<dist_min) {dist_min=dist;matching_shot=j;}
         }
        }
        if (j<MAX_SHOTS) j=matching_shot; else j=0;
/*
        if (dist_min>hittable[i].rad2)
        {
         xprintf("BOOM maybe caused by collision %d %d?\n",dist_min,hittable[i].size);
         if ((j>=0)&&(j<6)) xprintf("Maybe shot id %d\n",shot[j].id);
        }
        else
        {
         xprintf("TYPE %d SIZE %d: xs %d ys %d xa %d ya %d\n",hittable[i].typ,hittable[i].size,bound_x(shot[j].realpos.x-shot[j].delta.x),bound_y(shot[j].realpos.y-shot[j].delta.y),hittable[i].realpos.x,hittable[i].realpos.y);
	}
*/
       }
       break;
      }
     }
     if (i==MAX_ENTRIES)
     {
      //if ((abs(dist_x(hittable[27].realpos.x,x))<200)&&(abs(dist_y(hittable[27].realpos.y,y))<200)) printf("BOOM near UFO crash %d/%d\n",x,y); else printf("BOOM %d/%d not matched\n",x,y);
     } else asteroid_nr=i; 
    }
    // now match ROCK events
    else if (tmp_flags&ROCK)
    { // a ROCK can only match a ROCK or can be put into an empty slot.
     for (i=asteroid_nr;i<MAX_ENTRIES;i++)
     {
      if ((hittable[i].flags&ROCK)&&(perform_prediction(&hittable[i],tmp_flags,tmp_typ,vs,x,y))) break;
     }
     if (i<MAX_ENTRIES)
     {
      asteroid_nr=i;
     }
     else
     { // no match, new ROCK
      if (hittable[asteroid_nr].flags&ROCK)
      { // this slot should be free, or the current table does not match the real one in the emulator
       // check if there is a FREE place before
       for (i=asteroid_nr-1;i>-1;i--) if (hittable[i].flags&FREE) break;
       if (i==-1)
       { // compaction is not possible, try insert
        for (i=asteroid_nr+1;i<MAX_ENTRIES;i++) if (hittable[i].flags&FREE) break;
        if (i==MAX_ENTRIES)
        {
         printf("no space for insert in frame %d index %d\n",framenr,asteroid_nr);
         for (i=0;i<MAX_ENTRIES;i++) hittable[i].flags=FREE;
         return 1;
        }
        else
        {
         printf("memmove insert in frame %d index %d\n",framenr,asteroid_nr);
         memmove((void *)&hittable[asteroid_nr+1],(void *)&hittable[asteroid_nr],sizeof(struct SCREENOBJECT)*(i-asteroid_nr));
        }
       }
       else
       {
        printf("memmove compact in frame %d index %d\n",framenr,asteroid_nr);
        memmove((void *)&hittable[i],(void *)&hittable[i+1],sizeof(struct SCREENOBJECT)*(asteroid_nr-1-i));
        asteroid_nr--; // the space below was compacted successfully
       }
       xprintf("had to insert ROCK @ %d/%d, internal table was not in sync\n",x,y);
       hittable[asteroid_nr].flags=FREE;
      }
     }
    }

    // now the offset is found: if there is a type change update type and lifetime, other properties are already set by prediction
    // but only if it was no UFO explosion
    if (tmp_flags!=FREE)
    {
     if ((hittable[asteroid_nr].flags&(FREE|BOOM|ROCK|SHOT))!=tmp_flags)
     {
      hittable[asteroid_nr].typ=tmp_typ;
      hittable[asteroid_nr].size=vs;
      hittable[asteroid_nr].rad2=64<<vs;
      hittable[asteroid_nr].history_count=vs;
      hittable[asteroid_nr].pos.x=x;
      hittable[asteroid_nr].pos.y=y;
      hittable[asteroid_nr].realpos.x=x;
      hittable[asteroid_nr].realpos.y=y;
      hittable[asteroid_nr].history[0].x=x;
      hittable[asteroid_nr].history[0].y=y;
      hittable[asteroid_nr].lifetime=0;
      hittable[asteroid_nr].id=current_id++;
      xprintf("changing type at %d from %s to %s at %d/%d id %d\n",asteroid_nr,plainnames[hittable[asteroid_nr].flags>>4],plainnames[tmp_flags>>4],hittable[asteroid_nr].pos.x,hittable[asteroid_nr].pos.y,hittable[asteroid_nr].id);
      hittable[asteroid_nr].flags=tmp_flags;
     }
     else
     {
      hittable[asteroid_nr].flags&=~GARBAGE; // save from garbage collection
     }
     asteroid_nr++;
    }
   }
   else // work on the shot structure
   { // possibilities: shot matches this or later shot or the shot is inserted at current position (shots are expired before)
    for (i=shot_nr;i<MAX_SHOTS;i++) if (perform_prediction(&shot[i],tmp_flags,tmp_typ,vs,x,y)) break;
    if (i==MAX_SHOTS)
    { // The shot is NEW insert it at current position
     for (s=0;s<latency;s++) if ((preparedshot[s].flags&SHOT)&&(preparedshot[s].pos.x==x)&&(preparedshot[s].pos.y==y)&&(preparedshot[s].lifetime==1)) break;
     xprintf("replacing %s %d %d/%d\n",plainnames[shot[shot_nr].flags>>4],shot[shot_nr].id,shot[shot_nr].pos.x,shot[shot_nr].pos.y);
     shot[shot_nr].pos.x=x;
     shot[shot_nr].pos.y=y;
     shot[shot_nr].id=current_id++;
     if (s==latency)
     { // unexpected shot (UFO)
      shot[shot_nr].realpos.x=x;
      shot[shot_nr].realpos.y=y;
      shot[shot_nr].delta.x=0;
      shot[shot_nr].delta.y=0;
      shot[shot_nr].history[0].x=x;
      shot[shot_nr].history[0].y=y;
      shot[shot_nr].flags=SHOT;
      shot[shot_nr].tbd=0;
      printf("found UFO shot id %d @ %d/%d\n",shot[shot_nr].id,x,y);
      //for (s=0;s<latency;s++) if (preparedshot[s].flags&SHOT) printf("might be %d/%d lt %d\n",preparedshot[s].pos.x,preparedshot[s].pos.y,preparedshot[s].lifetime);
     }
     else
     { // predicted shot (SHIP)
      shot[shot_nr].realpos.x=preparedshot[s].realpos.x;
      shot[shot_nr].realpos.y=preparedshot[s].realpos.y;
      shot[shot_nr].delta.x=preparedshot[s].delta.x;
      shot[shot_nr].delta.y=preparedshot[s].delta.y;
      preparedshot[s].flags=FREE;
      shot[shot_nr].flags=SHOT|KNOWN;
      shot[shot_nr].tbd=1;
      xprintf("found predicted shot id %d lt %d @ %d/%d %d/%d delta %d/%d\n",shot[shot_nr].id,preparedshot[s].lifetime,x,y,shot[shot_nr].realpos.x,shot[shot_nr].realpos.y,shot[shot_nr].delta.x,shot[shot_nr].delta.y);
     }
     shot[shot_nr].expires=72-((frame.frameno+subframe+3)&3); // no latency, current frame
     xprintf("change to SHOT at %d (to %x) at %d/%d subframe %d\n",shot_nr,shot[shot_nr].flags,x,y,shot[shot_nr].expires);
     shot[shot_nr].rad2=0;
     shot[shot_nr].lifetime=0;
    }
    else
    { // the shot matched an existing one, clear all shots between shot_nr and nonempty
     // perform subframe calibration
     if ((frame.s[0]==0xe001)&&(shot[i].lifetime>SHOT_EXPIRE)) // SHOT seen 70 or 71 times (X above)
     {
      j=4-(frame.frameno&3);
      if (j!=subframe) printf("SHOT lt %d seen, SUBFRAME %d\n",shot[i].lifetime,subframe);
      else printf("SUBFRAME OK %d\n",subframe);
      subframe=j;
      ranging=1;
     }

     j=i;
     for (i=shot_nr;i<j;i++)
     {
      if (shot[i].flags&SHOT)
      {
       shot[i].flags=FREE;
       xprintf("SHOT %d at %d/%d lost\n",shot[i].id,shot[i].pos.x,shot[i].pos.y);
      }
     }
     shot_nr=j;
     shot[shot_nr].flags&=~GARBAGE;
    }
   }
   shot_nr++;
  }
 }

 // garbage collection: FREE all objects that have not been matched
 // and increase lifetime counters
 // set count of asteroids and shots
 for (i=0;i<MAX_SHOTS;i++)
 {
  if (shot[i].flags&GARBAGE)
  {
   if (ranging==2) {printf("ranging shot lt:%d\n",shot[i].lifetime);subframe=4-((frame.frameno-1)&3);printf("subframe %d\n",subframe);}
   shot[i].flags=FREE;
   xprintf("SHOT %d not expired on time\n",shot[i].id);
  }
  if (shot[i].flags&SHOT) {shot[i].lifetime+=dt;total_shots++;}
 }

 for (i=0;i<MAX_ENTRIES;i++)
 {
  if (hittable[i].flags&GARBAGE) hittable[i].flags=FREE;
  if ((hittable[i].flags&FREE)==0)
  {
   if (hittable[i].flags&ROCK)
   {
    asteroid_number[hittable[i].size]++;
    asteroids_total++;
   }
   hittable[i].lifetime+=dt;
  }
 }

 // flush mispredicted shots  
 for (i=0;i<latency;i++)
 {
  if (preparedshot[i].flags&SHOT)
  {
   if (preparedshot[i].lifetime>0)
   {
    preparedshot[i].lifetime--;
   }
   else
   {
    preparedshot[i].flags=FREE;
    printf("timeout prepared\n");
   }
  }
 }

 if (!ufo_detected) {hittable[27].flags=FREE;hittable[27].lifetime=0;} else hittable[27].lifetime++;

 if (oldscore>score) msbscore++;
 if (gamestate!=1) score=0;
 return 0;
}

int highscore_entry(char * name)
{
 int i,j;
  
 for (i=0;i<3;)
 {
  if ((name[i]<'A')||(name[i]>'Z')) name[i]='X'; //sanitize name
  if (pname[i]==name[i])  // matching char selected, confirm
  {
   keys.keys=BUTTON_JUMP;
   i++;
  }
  else if (pname[i]=='?') // find next way from boundary
  {
   if (name[i]<'N') keys.keys=BUTTON_LEFT; else keys.keys=BUTTON_RIGHT;
  }
  else // determine increment or decrement
   if (pname[i]>name[i])
   {
    if (pname[i]-name[i]<14) keys.keys=BUTTON_RIGHT; else keys.keys=BUTTON_LEFT;
   }
   else
   {
    if (name[i]-pname[i]<14) keys.keys=BUTTON_LEFT; else keys.keys=BUTTON_RIGHT;
   }
  for (j=0;j<latency+2;j++)
  { // send key and offset latency
   sendkeys();
   receiveframe();
   while (InterpretScreen());
   if (gamestate!=GAME_LISTENTRY) return 1;
   if (keys.keys!=BUTTON_JUMP) keys.keys=0;
  }
 }
 return 0;
}
