﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.IO;



namespace ct.Asteroid
{
   public class Player
   {
	    Socket mySocket;
	    IPAddress server_ip;
       double[] Schussrichtungen = { 0.0 , 3.6,8.2,12.7,16.5,21.2,25.2,29.5,33.5,37.8,41.7,46.2,50.8,55.3,59.4,63.4,67.5,71.6,76.1,79.9,84.5,89.1,92.8,97.2,101.8,105.5,110.2,114.1,118.1,122.8,126.7,131.1,135.0,139.4,143.3,147.9,151.9,156.6,160.7,164.5,169.2,172.8,177.3,181.9,185.5,189.9,194.5,198.2,203.0,206.9,211.0,215.4,220.0,223.8,227.5,232.2,235.9,240.3,245.1,248.8,252.7,257.3,261.1,265.6,270.0,273.6,278.2,282.7,286.5,291.2,295.0,299.0,303.5,307.8,311.7,316.2,320.0,324.5,328.6,332.7,336.6,341.6,345.3,349.9,354.5,358.1,2.8,7.2,11.0,15.5,19.3,23.4,28.1,32.8,36.7,40.6,45.0,49.4,53.3,57.2,61.9,66.6,70.7,74.5,79.0,82.2,87.2,91.5,95.5,100.1,104.7,108.4,113.4,117.1,121.4,125.6,130.0,133.8,138.3,142.2,146.5,151.0,155.0,158.8,163.6,167.3,171.8,176.6,180.0,184.4,188.9,192.7,197.3,201.2,205.0,209.7,214.2,217.8,222.5,226.2,230.0,234.6,239.0,243.1,247.0,251.8,255.5,260.1,264.5,268.1,272.7,277.2,280.8,285.5,289.3,293.4,298.1,302.2,306.7,310.6,315.0,318.9,323.3,327.2,331.9,335.9,339.8,344.5,348.2,352.8,357.2,0.9,5.5,10.1,13.9,18.4,22.5,26.6,30.6,34.7,39.2,43.8,48.3,52.2,56.5,60.5,64.7,68.8,73.5,77.3,81.8,86.4,90.0,94.5,98.9,102.7,107.3,111.2,115.3,120.2,124.2,127.8,132.5,136.1,140.8,145.3,149.8,153.9,17.9,161.8,166.3,170.1,174.3,179.1,182.9,187.2,191.5,195.6,200.3,204.1,208.1,212.1,216.6,221.0,225.0,228.9,233.3,237.8,241.9,245.9,249.8,254.5,258.4,262.8,267.3,270.9,275.5,279.9,283.7,288.2,292.1,296.1,300.2,304.7,309.2,313.8,317.5,322.2,325.8,329.8,334.7,338.8,342.7,347.2,351.1,355.5} ;
       int[] schiffdx = { 1536, 1536, 1528, 1504, 1472, 1472, 1416, 1360, 1280, 1280, 1192, 1088, 976, 976, 856, 720, 584, 584, 440, 296, 152, 152, -152, -296, -296, -440, -584, -720, -720, -856, -976, -1088, -1088, -1192, -1280, -1360, -1360, -1416, -1472, -1504, -1504, -1528, -1536, -1536, -1528, -1528, -1504, -1472, -1416, -1416, -1360, -1280, -1192, -1192, -1088, -976, -856, -856, -720, -584, -440, -440, -296, -152, 0, 152, 296, 440, 440, 584, 720, 856, 856, 976, 1088, 1192, 1192, 1280, 1360, 1416, 1416, 1472, 1504, 1528, 1528, 1536, 1536, 1528, 1504, 1504, 1472, 1416, 1360, 1360, 1280, 1192, 1088, 1088, 976, 856, 720, 720, 584, 440, 296, 296, 152, -152, -152, -296, -440, -584, -584, -720, -856, -976, -976, -1088, -1192, -1280, -1280, -1360, -1416, -1472, -1472, -1504, -1528, -1536, -1536, -1536, -1528, -1504, -1472, -1472, -1416, -1360, -1280, -1280, -1192, -1088, -976, -976, -856, -720, -584, -584, -440, -296, -152, -152, 152, 296, 296, 440, 584, 720, 720, 856, 976, 1088, 1088, 1192, 1280, 1360, 1360, 1416, 1472, 1504, 1504, 1528, 1536, 1536, 1528, 1528, 1504, 1472, 1416, 1416, 1360, 1280, 1192, 1192, 1088, 976, 856, 856, 720, 584, 584, 440, 440, 152, 152, 0, -152, -296, -440, -440, -584, -720, -856, -856, -976, -1088, -1192, -1192, -1280, -1360, -1416, -1416, -1472, -1504, -1528, -1528, -1536, -1536, -1528, -1504, -1504, -1472, -1416, -1360, -1360, -1280, -1192, -1088, -1088, -976, -856, -720, -720, -584, -440, -296, -296, 152, 152, 152, 296, 440, 584, 584, 720, 856, 976, 976, 1088, 1192, 1280, 1280, 1360, 1416, 1472, 1472, 1504, 1528, 1536};
       int[] schiffdy = { 0, 0, 152, 296, 440, 440, 584, 720, 856, 856, 976, 1088, 1192, 1192, 1280, 1360, 1416, 1416, 1472, 1504, 1528, 1528, 1528, 1504, 1504, 1472, 1416, 1360, 1360, 1280, 1192, 1088, 1088, 976, 856, 720, 720, 584, 440, 296, 296, 152, 0, 0, -152, -152, -296, -440, -584, -584, -720, -856, -976, -976, -1088, -1192, -1280, -1280, -1360, -1416, -1472, -1472, -1504, -1528, -1536, -1528, -1504, -1472, -1472, -1416, -1360, -1280, -1280, -1192, -1088, -976, -976, -856, -720, -584, -584, -440, -296, -152, -152, 0, 0, 152, 296, 296, 440, 584, 720, 720, 856, 976, 1088, 1088, 1192, 1280, 1360, 1360, 1416, 1472, 1504, 1504, 1528, 1528, 1528, 1504, 1472, 1416, 1416, 1360, 1280, 1192, 1192, 1088, 976, 856, 856, 720, 584, 440, 440, 296, 152, 0, 0, 0, -152, -296, -440, -440, -584, -720, -856, -856, -976, -1088, -1192, -1192, -1280, -1360, -1416, -1416, -1472, -1504, -1528, -1528, -1528, -1504, -1504, -1472, -1416, -1360, -1360, -1280, -1192, -1088, -1088, -976, -856, -720, -720, -584, -440, -296, -296, -152, 0, 0, 152, 152, 296, 440, 584, 584, 720, 856, 976, 976, 1088, 1192, 1280, 1280, 1360, 1416, 1416, 1472, 1472, 1528, 1536, 1528, 1528, 1504, 1472, 1472, 1416, 1360, 1280, 1280, 1192, 1088, 976, 976, 856, 720, 584, 584, 440, 296, 152, 152, 0, 0, -152, -296, -296, -440, -584, -720, -720, -856, -976, -1088, -1088, -1192, -1280, -1360, -1360, -1416, -1472, -1504, -1504, -1528, -1528, -1528, -1504, -1472, -1416, -1416, -1360, -1280, -1192, -1192, -1088, -976, -856, -856, -720, -584, -440, -440, -296, -152, 0 };
       public const int RECHTS = 1;
       public const int LINKS = 0;
       public const int NICHTS = 2;

       public const int WBRECHTS = -1;
       public const int WBLINKS = 1;
       public const int WBNICHTS = 0;

       public const int SHOT = 1;
       public const int NOSHOT = 0;
       double geschwShot = 7.92;
       public ZielTimePunkt nextShotPoint;
       public int frametime = 0;

       //Radien der Asteroiden und des Schiffes
       int RadiusGross = 40;
       int RadiusMittel = 20;
       int RadiusKlein = 11;
       int RadiusSchiff = 10;

       //Saucer
       Saucer mySaucer = new Saucer();

       //Anzahl der Schüsse die proAsteroid abgegeben werden sollen
       int shotgross = 5;
       int shotmittel = 2;
       int shotklein = 1;
       int shotsaucer = 2;
       Asteroid zielasteroid;
       int AsteroidShotID;     
       int AsteroidAimID = 0;
       //Faktoren für Zielauswahl
       int FkDistance = 6;
       int FkWinkel = 5;
       int FKgeschw = 2;
       int FKdisAimAsteroid = 4;

       //Koordinaten vom letzten Asteroiden
       int[] koLastAsteroid = new int[2];
       

       public Boolean countShotAsteroid = true;
       public Boolean Hyperspace = true;
       public Boolean aimAtSaucer = true;

       public Boolean akZielSaucer = false;

       //IDs 
       int AsteroidID = 0;

       double mLatenz = 0; //zur Latenzmessung

       StreamWriter gFile = new StreamWriter("geschwindigkeit1.txt");
       Boolean close = false;

       double lastWinkelshot = 0;
       
       // Liste von Asteroiden
       List<Asteroid> asteroidlist = new List<Asteroid>();
       List<Shot> shotlist = new List<Shot>();
       List<ZielTimePunkt> zielliste = new List<ZielTimePunkt>();
       List<int[]> keylist = new List<int[]>();
       List<int[]> keylistnext = new List<int[]>();
       public int winkelbytenext = 0;
       public int winkelbytenow = 0;
       public int winkelbytelast = 0;
       //Schiffkoordinaten
       int Shipx = 0;
       int Shipy = 0;
       //Variablen
       int count = 1;   // Gibt an wie oft die Schussgeschw gesetzt wurde
       int tlast = -10; // wann das letzte mal synchronisiert wurde

       double Wbdx = 100;
       double Wbdy = 0;

       
       public bool lastframeshot = false; // ob bei der letzten berechnung geschossen wurde

       // Debug
       int p = 0;
       int currentping = 0;
       int currenttime = 0;
       int leershottime = 0;
        
        public Player(Socket sock, IPAddress server)
        {
            mySocket = sock;
            server_ip = server;
        }

        public void RunOwn()
        {
            FramePacket frame = new FramePacket();
            KeysPacket keys = new KeysPacket();
            //int AnzahlFrames = 15;
            GameStatus game = new GameStatus();
            
            char prevframe = (char)0;
            int t = 0;
            //init
            koLastAsteroid[0] = 500;
            koLastAsteroid[1] = 350;

            
            Asteroid nearestAsteroid = new Asteroid();
            int nextKey = WBNICHTS;
            int keytime = 0;
            
            


            for (; ; )
            {
                
                Thread.Sleep(1);
                ++t; //Zeit
                ++keys.ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
                if (keys.ping > 255) keys.ping = (char)0;
                keylist.Add(new int[3]{keys.ping,nextKey,t});
                SendPacket(keys);
                frame = ReceivePacket(); 
                if (frame == null) continue;
                
                if (frame.frameno != ++prevframe || frame.ping != keys.ping)
                {
                    //Console.WriteLine("Latenz " + (keys.ping - frame.ping).ToString() + ". " + (frame.frameno - prevframe).ToString() + " Frames verloren.\n");
                    prevframe = frame.frameno;
                }
                if(betrag(keys.ping - frame.ping) < 10)
                {
                    mLatenz = (mLatenz*7+ betrag(keys.ping - frame.ping)) / 8;
                }

                currentping = keys.ping;
                keylistnext.Add(new int[3] { keys.ping, nextKey, t });
                
                
                for (int i = 0; i < keylist.Count; i++ )
                {
                    if (keylist[i][0] == frame.ping && game.ship_present)
                    {  
                        winkelbytenow = (winkelbytenow + keylist[i][1] + 256) % 256;
                        keytime = keylist[i][2];
                        currenttime = keytime;
                        break;                              
                    }
                    
                }
                int tst = keylist.Count;
                keylist.RemoveAll(removeping);
                int keydiff = 0;
                for (int a = 0; a < keylistnext.Count; a++)
                {
                    if(keytime < keylistnext[a][2])
                    {
                        keydiff += keylistnext[a][1];
                    }
                }
                keylistnext.RemoveAll(removeoldtimekey);
 
                winkelbytenext = (winkelbytenow + keydiff + 256)%256;

                //Console.WriteLine("Wbnext :" + winkelbytenext + " || WbNow : " + winkelbytenow);
                if (betrag(keydiff) > 10 || winkelbytenext < 0)
                {
                    Console.WriteLine("Keydiff :" + keydiff + " WBnext :" + winkelbytenext);
                }
                if (winkelbytenext < 0)
                {
                    Console.WriteLine(winkelbytenext + "" + winkelbytenow + " " + t);
                }

                //falls das Schiff zerstört wurde werden die nächsten Keypakete nicht mehr angenommen
                if (!game.ship_present)
                {
                    winkelbytenext = winkelbytenow;
                    keylist = new List<int[]>();
                    keylistnext = new List<int[]>();
                }
                frametime++;
                InterpretScreen(frame, game);
                interpretasteroids(game,frametime);
                interpretshots(game);
                //synch Winkelbyte mit der Schussrichtung
                synchWinkelbyteold(frametime);
                //synch Winkelbyte mit der Tabelle
                synchWinkelbyte(game);
                //rechnet das Winkelbyte als Schussvektor aus
                WBalsVektor();
                //damit man global auf die Position des Schiffes zugreifen kann
                Shipx = game.ship_x;
                Shipy = game.ship_y;
                if (game.saucer_present)
                {
                    mySaucer.set(game.saucer_x, game.saucer_y);
                }
                else
                {
                    mySaucer.clearShots();
                }

                keys.clear();


                if (game.ship_present && (asteroidlist.Count != 0 || game.saucer_present))
                {
             
                    //Die Steuerung aufrufen
                    int[] Steuerung = aim(game, getnextAsteroid(game),frametime);

                    //Winkelbyte für den nächsten Frame speichern
                    winkelbytelast = winkelbytenow;
  
                    //Zielen
                    if (Steuerung[0] == RECHTS)
                    {
                        keys.right(true); 
                        nextKey = WBRECHTS;
                    }
                    else if (Steuerung[0] == LINKS)
                    {
                        keys.left(true);   
                        nextKey = WBLINKS;
                    }
                    else
                    {
                        nextKey = WBNICHTS;
                    }
                   
                    if (Steuerung[1] == SHOT && !lastframeshot)
                    {  // Feuerknopf drücken
                        keys.fire(true);
                        lastframeshot = true;
                        lastWinkelshot = Schussrichtungen[winkelbytenext];
                        if (zielasteroid != null && AsteroidShotID != -1)
                        {
                            asteroidlist.Find(findID).setTrefferframe((int)(frametime + ddistance(zielasteroid.x, zielasteroid.y, Shipx, Shipy) / geschwShot));
                        }
                        if (game.saucer_present && AsteroidShotID == -1)
                        {
                            mySaucer.addshot();
                        }
                    }
                    else
                    {
                        lastframeshot = false;
                    }

                    if (retHyperspace(game))
                    {
                        keys.hyperspace(true);
                    }

                }
                //Drehung in eine Ecke
                if (game.ship_present && !(asteroidlist.Count != 0 || game.saucer_present))
                {
                    if (leershottime % 18 == 0)
                    {
                        keys.fire(true);
                    }

                    if (Shipx == 512 && Shipy == 448)
                    {   
                    }
                    else
                    {
                        int pWinkel = findNearestWinkel((retWinkelzumSchiff(game, 512, 448) + 180)%360);
                        if (winkelbytenext < pWinkel)
                        {
                            keys.left(true);
                        }
                        else
                        {
                            keys.right(true);
                        }

                    }
                    leershottime++;

                }

            }

        }

        private bool removeping(int[] pInt)
        {
            return(((pInt[0] <= currentping || pInt[0] > (currentping + 50) % 256) && currentping < (currentping + 50) % 256) || ((pInt[0] <= currentping && pInt[0] > (currentping + 50) % 256) && currentping > (currentping + 50) % 256));
        }

        private bool removeoldtimekey(int[] pInt)
        {
            return (pInt[2] < currenttime);
        }


       /**
        * Interpretiert den bekommenen Bildschirm
        **/

        unsafe void InterpretScreen(FramePacket packet, GameStatus game)
        {
	        ushort[] vector_ram = packet.vectorram2;
	        int dx;
            int dy;
            int sf;
            int vx = 0;
            int vy = 0, vz = 0, vs = 0;
	        int v1x = 0;
	        int v1y = 0;
	        int shipdetect = 0;

	        game.clear();
	        if (packet.vectorram[1] != 0xe0 && packet.vectorram[1] != 0xe2)
		        return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	        int pc = 1;
	        for (;pc < 513;)
	        {
                int op = vector_ram[pc] >> 12; ;
		        switch (op)
		        {
		        case 0xa: // LABS
			        vy = vector_ram[pc] & 0x3ff;
			        vx = vector_ram[pc+1] & 0x3ff;
			        vs = vector_ram[pc+1] >> 12;
			        break;
		        case 0xb: // HALT
			        return;
		        case 0xc: // JSRL
			        switch (vector_ram[pc] & 0xfff)
			        {
			        case 0x8f3:
				        game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				        break;
			        case 0x8ff:
				        game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				        break;
			        case 0x90d:
				        game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				        break;
			        case 0x91a:
				        game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				        break;
			        case 0x929:
				        game.saucer_present = true;
				        game.saucer_x = vx;
				        game.saucer_y = vy;
				        game.saucer_size = vs;
				        break;
			        }  
			        break;
		        case 0xd: // RTSL
			        return;
		        case 0xe: // JMPL
			        /*
			        pc = vector_ram[pc] & 0xfff;
			        break;
			        */
			        return;
		        case 0xf: // SVEC
			        /*
			        dy = vector_ram[pc] & 0x300;
			        if ((vector_ram[pc] & 0x400) != 0)
				        dy = -dy;
			        dx = (vector_ram[pc] & 3) << 8;
			        if ((vector_ram[pc] & 4) != 0)
				        dx = -dx;
			        sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			        vz = (vector_ram[pc] & 0xf0) >> 4;
			        */
			        break;
		        default:
			        dy = vector_ram[pc] & 0x3ff;
			        if ((vector_ram[pc] & 0x400) != 0)
				        dy = -dy;
			        dx = vector_ram[pc+1] & 0x3ff;
			        if ((vector_ram[pc+1] & 0x400) != 0)
				        dx = -dx;
			        sf = op;
			        vz = vector_ram[pc+1] >> 12;
			        if (dx == 0 && dy == 0 && vz == 15)
				        game.shots[game.nshots++].set(vx, vy);
			        if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			        {
				        switch (shipdetect)
				        {
				        case 0:
					        v1x = dx;
					        v1y = dy;
					        ++shipdetect;
					        break;
				        case 1:
					        game.ship_present = true;
					        game.ship_x = vx;
					        game.ship_y = vy;
					        game.ship_dx = v1x - dx;
					        game.ship_dy = v1y - dy;
					        ++shipdetect;
					        break;
				        }
			        }
			        else if (shipdetect == 1)
				        shipdetect = 0;

			        break;
		        }
		        if (op <= 0xa)
			        ++pc;
		        if (op != 0xe) // JMPL
			        ++pc;
	        }   

        }

        /**
         * Empfängt das Bild
         **/

        public FramePacket ReceivePacket()
        {

            if (mySocket.Available == 0) return null;

            int received = 0;

            EndPoint myRemoteEndpoint = new IPEndPoint(server_ip, 1979);
            
            byte[] receiveBytes = new byte[mySocket.Available];

            try
            {
                received = mySocket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);
            }
            catch (Exception e)
            {
                Console.WriteLine("Exception in ReceivePacket():" + e.Message);
                
            }

            return FramePacket.FromByteArray(receiveBytes);
        }

        /**
         * Schickt die gedrückten Tasten
         **/
      
        void SendPacket(KeysPacket packet)
        {

            byte[] bytCommand = packet.ToByteArray();

            int pret = mySocket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
        }

        /**
         * Die Entfernung zwischen 2 Punkten als INT und als Double
         **/

        public int distance(int x1, int y1, int x2, int y2)
        {
            int dx = (x2 - x1);
            int dy = (y2 - y1);
            double d = Math.Sqrt(((dx * dx) + (dy * dy)));
            return (int)Math.Abs(d);
        }

        public double ddistance(int x1, int y1, int x2, int y2)
        {
            int dx = (x2 - x1);
            int dy = (y2 - y1);
            double d = Math.Sqrt(((dx * dx) + (dy * dy)));
            return d;
        }

        /**
         * Gibt die Steuerung zurück
         **/

        private int[] aim(GameStatus game, Asteroid tAst, int time)
        {
    
            int[] Steuerung = retDrehung(game, tAst);
            
            Boolean shot = false;
            foreach (Asteroid ast in asteroidlist)
            {
                int AstShots = 0;

                switch (ast.sf)
                {	// Größe des Asteroiden
                    case 0:  // großer Asteroid
                        AstShots = shotgross;
                        break;
                    case 15: // mittlerer Asteroid
                        AstShots = shotmittel;
                        break;
                    case 14: // kleiner Asteroid
                        AstShots = shotklein;
                        break;
                }

                if (zieltreffer(game, winkelbytenext, ast) && (!(ast.shotframe > time && ast.numberofshots >= AstShots) || AsteroidAimID == ast.id))
                {
                    shot = true;
                    zielasteroid = ast;
                    AsteroidShotID = ast.id;
                    break;
                }
                
            }
            if (game.saucer_present && zieltreffer(game, winkelbytenext, mySaucer))
            {
                shot = true;
                AsteroidShotID = -1;
            }

            if (shot)
            {
                Steuerung[1] = SHOT;      
                
            }
            else
            {
                Steuerung[1] = NOSHOT;
            }

            return Steuerung;


        }

        /**
         * Berechnet die Trefferposition von dem Asteroiden 
         **/

        private int[]movementasteroid(Asteroid aimAsteroid, int pframesvoraus)
        {
            double ax = aimAsteroid.dx;// Geschw und Richtung vom Schiff/Asteroiden
            double ay = aimAsteroid.dy;
            double Astx = aimAsteroid.x +(pframesvoraus) * aimAsteroid.dx;//da ein frame im voraus berechnet werden soll
            double Asty = aimAsteroid.y +(pframesvoraus) * aimAsteroid.dy;
            
            double bx = Wbdx;// Geschw und Richtung vom Schiff
            double by = Wbdy;
            // Berechnung der Spitze des Schiffes (20 Pixel vom Mittelpunkt entfernt) -- test der Knopf muss kommt erst im übernächsten Frame an daher 12
            int sx = checked((int)(Shipx)); //+ 20 * bx / Math.Sqrt(bx*bx+by*by)));
            int sy = checked((int)(Shipy)); //+ 20 * by / Math.Sqrt(bx*bx+by*by)));
            double va = aimAsteroid.dg;//Geschw des Asteroiden
            double dist = ddistance((int)Math.Round(Astx),(int)Math.Round(Asty),sx,sy);//Abstand

            //Richtungsvektor vom Asteroiden zur Schiffspitze (weil da der Schuss das Schiff verlässt)
            double vekASx = sx - Astx;
            double vekASy = sy - Asty;

            // Winkel bestimmen

            // gamma:Winkel zwischen dem Richtungsvektor von dem Asteroiden und dem Vektor zwischen Asteroiden und Schiff bestimmen (Zeigt Richtung Schiff)
            double gamma = Math.Acos((ax*vekASx+ay*vekASy)/Math.Sqrt((ax*ax+ay*ay)) / Math.Sqrt((vekASx*vekASx+vekASy*vekASy)));
            // beta: Winkel am Schiff
            double beta = Math.Asin( (va / geschwShot) * Math.Sin(gamma));
            // alpha: Winkel am Trefferpunkt
            double alpha = 180 - gamma - beta;

            //Die Strecke vom Schiff bis zum Trefferpunkt
            double streckeZiel = betrag(va / geschwShot * Math.Sin(gamma) * dist / Math.Sin(alpha))+20 ;

            // Der neue Trefferpunkt wird berechnet
            int[] aim = new int[2];
            aim[0] = (int)(Astx + streckeZiel * (aimAsteroid.dx) / va);
            aim[1] = (int)(Asty + streckeZiel * (aimAsteroid.dy) / va);

            //Console.WriteLine("Alt: " + aimAsteroid.x + ", " + aimAsteroid.y + " || new: " + aim[0] + " ," + aim[1] + " || geschw: " + va + "\n  Gamma: " + gamma + " Beta: "+ beta +"\n");
            // Falls die Geschwindigkeit vom Asteroiden = 0 ist wird die momentane Position als Zielposition zurückgegeben
            if (va == 0 || dist == 0)
            {
                aim[0] = aimAsteroid.x;
                aim[1] = aimAsteroid.y;
                
            }

            return aim;
        }

       

        public int normalx(int x)
        {
            while (x < 0)x += 1024; // dx normalisieren auf 0 ... 1024
            while (x > 1023) x -= 1024;
            return x;
        }
        public int normaly(int y)
        {
            while (y < 128) y += 768;  // dy normalisieren auf 128 ... 895
            while (y > 895) y -= 768;
            return y;
        }

        public int normalShipx(int x)
        {
            while (x < Shipx-512) x += 1024; // auf den Schussbereich des Schiffs bringen
            while (x > Shipx+512) x -= 1024;
            return x;

        }
        public int normalShipy(int y)
        {
            while (y < Shipy-384) y += 768;  // auf den Schussbereich des Schiffsbringen
            while (y > Shipy+384) y -= 768;
            return y;

        }

        

        public void setshotgeschw(double shotg)
        {
            
            //geschwShot = ((count * geschwShot + shotg) / (count + 1));
            geschwShot = 8;
            count++;

            if (count > 30)
            {
                Console.WriteLine(" Shotgeschw " + shotg);
            }

        }

        /**
         * Wertet die Asteroiden aus
         **/

        private void interpretasteroids(GameStatus game, int time)
        {
            
           //Zuerst sollen alle Asteroiden nicht vorhanden sein
           //Danach wird dann überprüft welche noch da sind
            foreach (Asteroid AG in asteroidlist)
            {
                AG.setVorhanden(false);
            }

            for (int a = 0; a < game.nasteroids; a++)
            {
                //den nächstgelegenen Asteroiden finden
                Asteroid tAst = findnearest(game.asteroids[a]);
                // und gucken ob er sich das Stück bewegt haben kann
                if (!tAst.Equals(game.asteroids[a]) && ddistance(game.asteroids[a].x, game.asteroids[a].y, tAst.x, tAst.y) < 8 && game.asteroids[a].sf == tAst.sf)
                {
                    tAst.setVorhanden(true);
                    tAst.setaktuell(game.asteroids[a].x, game.asteroids[a].y);
                    //Console.WriteLine(" alte Punkte :" + tAst.ox + " , " + tAst.oy + "  neue Punkte :" + tAst.x + " , " + tAst.y + " \n Richtungsvektoren dx,dy :" + tAst.dx + " , " + tAst.dy + " Geschwindigkeit :" + tAst.dg + "\n" );
                }
                else
                {
                    game.asteroids[a].setID(AsteroidID);
                    asteroidlist.Add(game.asteroids[a]);
                    AsteroidID++;
                    game.asteroids[a].setVorhanden(true);
                }
            }
     
            asteroidlist.RemoveAll(nochvorhanden);
            
            
           
        }

       private bool nochvorhanden(Asteroid tAS)
       {
           return !tAS.vorhanden;
       }

       /**
        * Wertet die Schüsse auf dem Bildschirm aus
        **/

       private void interpretshots(GameStatus game)
       {
           // alle Schüsse sind nciht mehr vorhanden
           // suche zu jedem den nächsten
           // bestimme ob er das ist
          
           foreach (Shot AG in shotlist)
           {
               AG.setVorhanden(false);
           }

           for (int a = 0; a < game.nshots; a++)
           {
               Shot tAst = findnearestShot(game.shots[a]);
               if (!tAst.Equals(game.shots[a]) && distance(game.shots[a].x, game.shots[a].y, tAst.x, tAst.y) < 10)
               {
                   tAst.setVorhanden(true);
                   tAst.setaktuell(game.shots[a].x, game.shots[a].y);
               }
               else
               {
                   shotlist.Add(game.shots[a]);
                   game.shots[a].setVorhanden(true);
                   if (ddistance(game.shots[a].x, game.shots[a].y, game.ship_x, game.ship_y) < 30)
                   {
                       game.shots[a].setfromShip(true);
                       game.shots[a].setWinkel(lastWinkelshot);
                   }
                   else
                   {
                       game.shots[a].setfromShip(false);
                   }
                   if (game.saucer_present && ddistance(mySaucer.x, mySaucer.y, game.shots[a].x, game.shots[a].y) < 30)
                   {
                       game.shots[a].setfromSauer(true);
                   }
                   else
                   {
                       game.shots[a].setfromSauer(false);
                   }
                   game.shots[a].setWinkelbyte(winkelbytelast);
               }
           }
           shotlist.RemoveAll(nochvorhandenShot);
           
        }

       private bool nochvorhandenShot(Shot tAS)
       {
           return !tAS.vorhanden;
       }


       /**
        * sucht den nächsten Asteroiden in den game asteroiden
        **/

       private Asteroid findnearest(GameStatus game, Asteroid tasteroid)
       {
           Asteroid pAsteroid;
           if (game.nasteroids == 0)
           {
               return tasteroid;
           }
           pAsteroid = game.asteroids[0];

           for (int i = 0; i < game.nasteroids; i++)
           {
               if (ddistance(game.asteroids[i].x, game.asteroids[i].y, tasteroid.x, tasteroid.y) < ddistance(pAsteroid.x, pAsteroid.y, tasteroid.x, tasteroid.y))
               {
                   pAsteroid = game.asteroids[i];
               }
           }
           return pAsteroid;
       }

       /**
        * sucht den nächsten Asteroiden in der asteroidlist
        **/

       private Asteroid findnearest(Asteroid tasteroid)
       {
           Asteroid pAsteroid;
           //wenn kein Asteroid vorhanden ist soll der gegebene zurückgegeben werden
           if (asteroidlist.Count == 0)
           {
               return tasteroid;
           }
           //es wird das erste Element als das näherste gesetzt
           pAsteroid = asteroidlist[0];
           //alle elemente werden überprüft
           foreach(Asteroid aAsteroid in asteroidlist)
           {
               if (ddistance(aAsteroid.x, aAsteroid.y, tasteroid.x, tasteroid.y) < ddistance(pAsteroid.x, pAsteroid.y, tasteroid.x, tasteroid.y))
               {
                   pAsteroid = aAsteroid;
               }
           }
           return pAsteroid;
       }

       private Shot findnearestShot(Shot tShot)
       {
           Shot pShot;
           if (shotlist.Count == 0)
           {
               return tShot;
           }
           pShot = shotlist[0];

           foreach (Shot aShot in shotlist)
           {
               if (ddistance(aShot.x, aShot.y, tShot.x, tShot.y) < ddistance(aShot.x, aShot.y, pShot.x, pShot.y) && ddistance(aShot.x, aShot.y, tShot.x, tShot.y) > 6.5)
               {
                   pShot = aShot;
               }
           }
           return pShot;
       }

       private double retDrehwinkel(GameStatus game , int xAsteroid, int yAsteroid)
       {

            //gibt den Drehwinkel als Bogenmaß zurück
           int nx = (int)Math.Round(Wbdx);
           int ny = (int)Math.Round(Wbdy);
           double RvX = xAsteroid - game.ship_x;
           double RvY = yAsteroid - game.ship_y;
           double la = Math.Sqrt(RvX*RvX+RvY*RvY);
           double ln = Math.Sqrt(nx*nx+ny*ny);

           //Console.WriteLine("Winkel ret :" + Math.Acos(betrag(nx * RvX + ny * RvY) / (la * ln)) * 57.295);

           return Math.Acos(betrag(nx * RvX + ny * RvY) / (la * ln));

       }

       private double retDrehwinkelold(Asteroid pAst)
       {

           //gibt den Drehwinkel als Bogenmaß zurück
           int nx = (int)Math.Round(Wbdx);
           int ny = (int)Math.Round(Wbdy);
           double RvX = pAst.x - Shipx;
           double RvY = pAst.y - Shipy;
           double la = Math.Sqrt(RvX * RvX + RvY * RvY);
           double ln = Math.Sqrt(nx * nx + ny * ny);

           //Console.WriteLine("Winkel ret :" + Math.Acos(betrag(nx * RvX + ny * RvY) / (la * ln)) * 57.295);

           return Math.Acos(betrag(nx * RvX + ny * RvY) / (la * ln));

       }

       private double retDrehwinkel(Asteroid pAst)
       {
           //gibt den Drehwinkel in Grad zurück und als Betrag
           double WinkelAst = retWinkelzumSchiff(pAst);
           double WinkelShip = Schussrichtungen[winkelbytenext];
           return betrag(WinkelAst - WinkelShip);
       }

       

       /**
        * Abstand von dem Schiff zur Geraden des Asteroiden
        */

       private double distGeradeShip(GameStatus game, Asteroid tAst)
       {
           int k = 10;
           int ship = 27;
           switch (tAst.sf)
           {	// Größe des Asteroiden
               case 0:  // großer Asteroid
                   k = RadiusGross;
                   break;
               case 15: // mittlerer Asteroid
                   k = RadiusMittel;
                   break;
               case 14: // kleiner Asteroid
                   k = RadiusKlein;
                   break;
           }

           int time = (int)(ddistance(normalShipx(tAst.x),normalShipy(tAst.y), Shipx, Shipy) / tAst.dg);
           int[] newPosition = nextPosition(tAst, time);
           return ddistance(normalShipx(newPosition[0]), normalShipy(newPosition[1]), Shipx, Shipy) - k - ship;
       }

       private void distGeradeShip(Asteroid tAst, int t)
       {
           double shortdist = ddistance(Shipx, Shipy, tAst.x, tAst.y);
           int frame = t;
           for (int i = 0; i < 150; i++)
           {
               int[] newPos = nextPosition(tAst, i);
               if (ddistance(Shipx, Shipy, newPos[0], newPos[1]) < shortdist)
               {
                   shortdist = ddistance(Shipx, Shipy, newPos[0], newPos[1]);
                   frame = t + i;
               }
           }
           tAst.setGeradenAbstand(shortdist);
           tAst.setframeShortestdist(frame);
       }

       private double distGeradeShip(Asteroid tAst, int maxt,GameStatus game)
       {
           double shortdist = ddistance(Shipx, Shipy, tAst.x, tAst.y);       
           for (int i = 0; i < maxt; i++)
           {
               int[] newPos = nextPosition(tAst, i);
               if (ddistance(Shipx, Shipy, normalShipx(newPos[0]),normalShipy(newPos[1])) < shortdist)
               {
                   shortdist = ddistance(Shipx, Shipy, normalShipx(newPos[0]), normalShipy(newPos[1]));        
               }
           }
           return shortdist;
       }

       private double distBlickrichtung(int px, int py, GameStatus game)
       {
           //Gesamtlänge der Winkelbytevektors
           double WBDG = Math.Sqrt(Wbdx * Wbdx + Wbdy * Wbdy);
           // Formel zur Abstandsbestimmung zwischen Gerade und Punkt
           return betrag(((px - game.ship_x) * (Wbdx / WBDG) + (py - game.ship_y) * (Wbdy / WBDG)));
       }

       /**
        * Abstand vom Schiff zu dem Asteroiden (momentanen)
        */

       private double distmomShip(Asteroid tAst)
       {
           int k = 10;
           int ship = 27;
           switch (tAst.sf)
           {	// Größe des Asteroiden
               case 0:  // großer Asteroid
                   k = RadiusGross;
                   break;
               case 15: // mittlerer Asteroid
                   k = RadiusMittel;
                   break;
               case 14: // kleiner Asteroid
                   k = RadiusKlein;
                   break;
           }

           return (ddistance(tAst.x, tAst.y, Shipx,Shipy) - k - ship);

       }

       private double distmomShip(Asteroid tAst, int frames)
       {
           int k = 10;
           int ship = 27;
           switch (tAst.sf)
           {	// Größe des Asteroiden
               case 0:  // großer Asteroid
                   k = RadiusGross;
                   break;
               case 15: // mittlerer Asteroid
                   k = RadiusMittel;
                   break;
               case 14: // kleiner Asteroid
                   k = RadiusKlein;
                   break;
           }
           int[] nPos = nextPosition(tAst, frames);

           return (ddistance(normalShipx(nPos[0]), normalShipy(nPos[1]), Shipx, Shipy) - k - ship);

       }
        

       private double betrag(double i)
       {
           if( i >= 0)
           {
               return i;
           }
           else
           {
               return -i;
           }
       }

       private int betrag(int i)
       {
           if (i >= 0)
           {
               return i;
           }
           else
           {
               return -i;
           }
       }

       private void priotlistAsteroid(GameStatus game)
       {
           foreach (Asteroid pAst in asteroidlist)
           {
               distGeradeShip(pAst, 0);
               pAst.setPrio(0);
               //Keine Geschwindigkeit
               if (pAst.dg == 0)
               {
                   pAst.setPrio(0);
               }
               //Kollision ist unvermeidbar
               if (pAst.distGeradeShip < 50)
               {
                   pAst.setPrio(100);
                   //Console.WriteLine("Abstand Gerade" + pAst.distGeradeShip);
               }
               //Kollision sehr wahrscheinlich
               
               //Kollision ist wahrscheinlich bei Abschuss
               
               //nahe Kollison
               
               //Kollision vermeidbar
              
               //keine Kollision
               

               asteroidlist.Sort(sortAsteroidlistDistance);
               for (int i = 0; i < asteroidlist.Count; i++)
               {
                   int newPrio = asteroidlist[i].Prioritaet + asteroidlist.Count - i;
                   asteroidlist[i].setPrio(newPrio);
               }
               


           }
       }
       

       private int framestoShot(GameStatus game, Asteroid pAst)
       {
           return betrag(retbestSchusswinkel(retWinkelzumSchiff(game, pAst.x, pAst.y),retWinkelzumSchiff(game,pAst.x,pAst.y) - winkelbytenext)); 

       }

       private static int sortAsteroidlistPrio(Asteroid first, Asteroid snd)
       {
           if (first.Prioritaet == snd.Prioritaet)
           {
               return 0;
           }
           if (first.Prioritaet < snd.Prioritaet)
           {
               return 1;
           }
           if (first.Prioritaet > snd.Prioritaet)
           {
               return -1;
           }
           return 0;
       }

       private int sortAsteroidlistWinkel(Asteroid first, Asteroid snd)
       {
           if (retDrehwinkel(first) == retDrehwinkel(snd))
           {
               return 0;
           }
           if (retDrehwinkel(first) > retDrehwinkel(snd))
           {
               return 1;
           }
           if (retDrehwinkel(first) < retDrehwinkel(snd))
           {
               return -1;
           }
           return 0;
       }

       private static int sortZiellisteTime(ZielTimePunkt first, ZielTimePunkt snd)
       {
           if (first.firstShotframe == snd.firstShotframe)
           {
               return 0;
           }
           if (first.firstShotframe > snd.firstShotframe)
           {
               return 1;
           }
           if (first.firstShotframe < snd.firstShotframe)
           {
               return -1;
           }
           return 0;
       }

       private static int sortlogliste(log first, log snd)
       {
           if (first.winkel == snd.winkel)
           {
               return 0;
           }
           if (first.winkel > snd.winkel)
           {
               return 1;
           }
           if (first.winkel < snd.winkel)
           {
               return -1;
           }
           return 0;
       }

       private int sortAsteroidlistDistance(Asteroid first, Asteroid snd)
       {
           if(distmomShip(first) == distmomShip(snd))
           {
               return 0;
           }
           if(distmomShip(first) > distmomShip(snd))
           {
               return 1;
           }
           if(distmomShip(first) < distmomShip(snd))
           {
               return -1;
           }
           return 0;
       }

       private int sortAsteroidlistDistanceAimAsteroid(Asteroid first, Asteroid snd)
       {
           if (ddistance(first.x,first.y,koLastAsteroid[0],koLastAsteroid[1]) == ddistance(snd.x,snd.y,koLastAsteroid[0],koLastAsteroid[1]))
           {
               return 0;
           }
           if (ddistance(first.x, first.y, koLastAsteroid[0], koLastAsteroid[1]) > ddistance(snd.x, snd.y, koLastAsteroid[0], koLastAsteroid[1]))
           {
               return 1;
           }
           if (ddistance(first.x, first.y, koLastAsteroid[0], koLastAsteroid[1]) < ddistance(snd.x, snd.y, koLastAsteroid[0], koLastAsteroid[1]))
           {
               return -1;
           }
           return 0;
       }

       private int sortAsteroidlistgeschw(Asteroid first, Asteroid snd)
       {
           if (first.dg == snd.dg)
           {
               return 0;
           }
           if (first.dg < snd.dg)
           {
               return 1;
           }
           if (first.dg < snd.dg)
           {
               return -1;
           }
           return 0;
       }

       private Boolean findID(Asteroid pAst)
       {
           return (pAst.id == AsteroidShotID);
       }
           
       

       private void synchWinkelbyteold(int t)
       {
           
           foreach (Shot tshot in shotlist)
           {
               if (tshot.shipshot && tshot.setspeed == 30 && tlast < t-30)
               {
                   double winkelshot = (Math.Acos(tshot.dx / Math.Sqrt(tshot.dx * tshot.dx + tshot.dy * tshot.dy)) * 57.29577951);
                   
                   
                   if (tshot.dy < 0)
                   {
                       winkelshot = 360 - winkelshot;
                   }

                   if (Schussindex(winkelshot,0.2) == -1)
                   {
                       break;
                   }

                   int wbfalsch = (tshot.Winkelbyte -Schussindex(winkelshot, 0.2));
                   winkelbytenow = ((winkelbytenow-wbfalsch+512)%256);
                   winkelbytenext = ((winkelbytenext-wbfalsch+512)%256);
                   tlast = t;
               }        
           }
       }

       private void synchWinkelbyte(GameStatus game)
       {
           int dx = game.ship_dx;
           int dy = game.ship_dy;
           for (int a = 0; a < 10; a++)
           {
               int i = (winkelbytenow + a) % 256;
               if (dx == schiffdx[i] && dy == schiffdy[i] && dx != schiffdx[(i + 1) % 256] && dx != schiffdx[(i - 1 + 256) % 256])
               {
                   int diff = winkelbytenext - winkelbytenow;
                   winkelbytenow = i;
                   winkelbytenext = (winkelbytenow + diff + 256) % 256;
                   break;
               }

               i = (winkelbytenow - a +256) % 256;
               if (dx == schiffdx[i] && dy == schiffdy[i] && dx != schiffdx[(i + 1) % 256] && dx != schiffdx[(i - 1 + 256) % 256])
               {
                   int diff = winkelbytenext - winkelbytenow;
                   winkelbytenow = i;
                   winkelbytenext = (winkelbytenow + diff + 256) % 256;
                   break;
               }
           }

       }

       private void WBalsVektor()
       {

           //testweise mit next winkelbyte
           Wbdx = Math.Cos(Schussrichtungen[winkelbytenext] * 0.017453293) * 100;
           Wbdy = Math.Sin(Schussrichtungen[winkelbytenext] * 0.017453293) * 100;
           //Winkelbyte in ein dx/dy umrechnen
           //Console.WriteLine("WB :" + 1.40625*winkelbytenow + "  WBdx :" + Wbdx + " WBdy :" + Wbdy);

       }

       private int Schussindex(double pWinkel, double Genauigkeit)
       {
           double tWinkel = Math.Round(pWinkel, 1);

           for (int i = 0; i < Schussrichtungen.Length; i++)
           {
               if (betrag(Schussrichtungen[i] - tWinkel) <= Genauigkeit)
               {
                   return i;
               }
           }
           return -1;

       }

       private int nextAimIndex(double pWinkel, double Genauigkeit)
       {
           for (int i = 0; i < 50; i++)
           {
               if (betrag(Schussrichtungen[(winkelbytenext - i + 256) % 256] - pWinkel) <= Genauigkeit)
               {
                   return winkelbytenext -i;
               }
               if (betrag(Schussrichtungen[(winkelbytenext + i + 256) % 256] - pWinkel) <= Genauigkeit)
               {
                   return winkelbytenext +i;
               }
           }
           return -1;
       }

       private double retWinkelzumSchiff(GameStatus game, int px, int py)
       {
           double dx = px - game.ship_x;
           double dy = py - game.ship_y;

           double VekSA = (Math.Acos(dx / Math.Sqrt(dx*dx + dy*dy)) * 57.29577951);

           if (dy < 0)
           {
               VekSA = 360 - VekSA;
           }
           return VekSA;

       }

       private double retWinkelzumSchiff(Asteroid pAst)
       {
           double dx = pAst.x - Shipx;
           double dy = pAst.y - Shipy;

           double VekSA = (Math.Acos(dx / Math.Sqrt(dx * dx + dy * dy)) * 57.29577951);

           if (dy < 0)
           {
               VekSA = 360 - VekSA;
           }
           return VekSA;

       }

       private int retbestSchusswinkel(double pWinkel, double pnextWinkel)
       {
           int bestWinkel = winkelbytenext;
           int nextWinkel = winkelbytenext;
           //zuerst den Winkel für die nächste Position des Asteroiden finden

           for (int a = 0; a < 50; a++)
           {
               if (betrag(pnextWinkel - Schussrichtungen[(winkelbytenext - a + 256) % 256]) < 6)
               {
                   nextWinkel = (winkelbytenext - a + 256) % 256;
                   break;
               }

               if (betrag(pnextWinkel - Schussrichtungen[(winkelbytenext + a) % 256]) < 6)
               {
                   nextWinkel = (winkelbytenext + a) % 256;
                   break;
               }
           }
           if (betrag(Schussrichtungen[nextWinkel] - pWinkel) > betrag(Schussrichtungen[(nextWinkel + 1) % 256] - pWinkel))
           {
               nextWinkel = (nextWinkel + 1) % 256;
           }
           if (betrag(Schussrichtungen[nextWinkel] - pWinkel) > betrag(Schussrichtungen[(nextWinkel - 1 + 256) % 256] - pWinkel))
           {
               nextWinkel = (nextWinkel - 1) % 256;
           }

           //Dann für die Zielposition finden

           for (int a = 0; a < 50; a++)
           {
               if (betrag(pWinkel - Schussrichtungen[(winkelbytenext - a + 256) % 256]) < 6)
               {
                   bestWinkel = (winkelbytenext - a + 256) % 256;
                   break;
               }

               if (betrag(pWinkel - Schussrichtungen[(winkelbytenext + a) % 256]) < 6)
               {
                   bestWinkel = (winkelbytenext + a) % 256;
                   break;
               }
           }
           if (betrag(Schussrichtungen[bestWinkel] - pWinkel) > betrag(Schussrichtungen[(bestWinkel + 1) % 256] - pWinkel))
           {
               bestWinkel = (bestWinkel + 1) % 256;
           }
           if (betrag(Schussrichtungen[bestWinkel] - pWinkel) > betrag(Schussrichtungen[(bestWinkel - 1 + 256) % 256] - pWinkel))
           {
               bestWinkel = (bestWinkel - 1) % 256;
           }

           //if (betrag(Schussrichtungen[nextWinkel] - pWinkel) < 3);
           //{
           //    bestWinkel = nextWinkel;
           //}

           return bestWinkel;
       }

       private int[] nextPosition(Asteroid pAst,int frames)
       {
           int[] newPos = new int[2];
           newPos[0] = (int)Math.Round(pAst.x + frames * pAst.dx);
           newPos[1] = (int)Math.Round(pAst.y + frames * pAst.dy);

           return newPos;
       }

       private void setAimPoints(Asteroid pAst, int ptime,GameStatus game)
       {
           int k = 6;
           switch (pAst.sf)
           {	// Größe des Asteroiden
               case 0:  // großer Asteroid
                   k = RadiusGross;
                   break;
               case 15: // mittlerer Asteroid
                   k = RadiusMittel;
                   break;
               case 14: // kleiner Asteroid
                   k = RadiusKlein;
                   break;
           }
           for (int i = 0; i < 150; i++)
           {
               int[] aimPos = movementasteroid(pAst, i+2);
               double genauigkeit = 57.29577951 * Math.Atan((k - 2) / ddistance(Shipx, Shipy, aimPos[0], aimPos[1]));
               int nextaimWinkel = nextAimIndex(retWinkelzumSchiff(game, aimPos[0], aimPos[1]), genauigkeit);
               if (nextaimWinkel != -1 && betrag(nextaimWinkel - winkelbytenow) < i)
               {
                   //pAst.AddZielTimePunkt(new ZielTimePunkt(aimPos[0],aimPos[1],ptime+i,nextaimWinkel));
                   Console.WriteLine("Alt: " + pAst.x + ", " + pAst.y + " || new: " + aimPos[0] + " ," + aimPos[1]);
                   break;
               }

           }
       }

       private void getnextShotPoint(Asteroid pAst, int time , GameStatus game)
        {
            int Astx = pAst.x;
            int Asty = pAst.y;
            int frames = 0;
            for (int i = 0; i < 10; i++)
            {
                Astx = (int)Math.Round(pAst.x+ frames * pAst.dx);
                Asty = (int)Math.Round(pAst.y+ frames * pAst.dy);
                int Winkelframes =  betrag(winkelbytenext - findNearestWinkel(retWinkelzumSchiff(game,Astx,Asty)));
                int Shotframes = (int)Math.Round((ddistance(Shipx,Shipy,Astx,Asty)-20)/geschwShot);
                frames = Winkelframes + Shotframes;
                //Console.WriteLine("Frames :" + frames);
            }
            int ShotWinkel = 0;

           Astx = (int)Math.Round(pAst.x + frames * pAst.dx);
           Asty = (int)Math.Round(pAst.y + frames * pAst.dy);
           
           ShotWinkel = findNearestWinkel(retWinkelzumSchiff(game,Astx,Asty));
              
           
           int Shotframe = betrag(ShotWinkel - winkelbytenext)  + time;
           if (Astx > 0 && Astx < 1024 && Asty > 128 && Asty < 895)
           {
               zielliste.Add(new ZielTimePunkt(Astx, Asty, Shotframe, Shotframe, ShotWinkel));
               Console.WriteLine(Astx + " " + Asty + " " + Schussrichtungen[ShotWinkel]);
           }

        }

       private int retTrefferwinkel(Asteroid pAst, int frames, GameStatus game)
       {
           int Astx = (int)Math.Round(pAst.x + frames * pAst.dx);
           int Asty = (int)Math.Round(pAst.y + frames * pAst.dy);

            int k = 6;
            switch (pAst.sf)
            {	// Größe des Asteroiden
                case 0:  // großer Asteroid
                    k = RadiusGross;
                    break;
                case 15: // mittlerer Asteroid
                    k = RadiusMittel;
                    break;
                case 14: // kleiner Asteroid
                    k = RadiusKlein;
                    break;
            }

                   double genauigkeit = betrag(57.29577951 * Math.Atan((k-2) / ddistance(Shipx, Shipy, Astx,Asty)));
                   if (genauigkeit > 5)
                   {
                       genauigkeit = 5;
                   }
           
                   Console.WriteLine("Genauigkeit :" + genauigkeit + " Winkel :" + retWinkelzumSchiff(game, Astx, Asty)); 
                   for (int a = 0; a < 50; a++)
                   {
                       if (betrag(Schussrichtungen[(a + winkelbytenext+ 256) % 256] - retWinkelzumSchiff(game, Astx, Asty)) <= genauigkeit)
                       {
                           return (a + winkelbytenext + 256) % 256;
                       }

                       if (betrag(Schussrichtungen[(-a + winkelbytenext + 256) % 256] - retWinkelzumSchiff(game, Astx, Asty)) <= genauigkeit)
                       {
                           return (-a + winkelbytenext + 256) % 256;
                       }
                   }
                
                   
                   return -1;
       }

       private int findNearestWinkel(double pWinkel)
       {
           double diff = 6;
           int retWinkel = winkelbytenext;
           for (int i = 0; i < 50; i++)
           {
               if (betrag(Schussrichtungen[(winkelbytenext + i) % 256] - pWinkel) <= diff)
               {
                   diff = betrag(Schussrichtungen[(winkelbytenext + i) % 256] - pWinkel);
                   retWinkel = (winkelbytenext + i) % 256;
               }
               if (betrag(Schussrichtungen[(winkelbytenext - i + 256) % 256] - pWinkel) <= diff)
               {
                   diff = betrag(Schussrichtungen[(winkelbytenext - i + 256) % 256] - pWinkel);
                   retWinkel = (winkelbytenext - i + 256) % 256;
               }
           }
           return retWinkel;
       }
       private int getWinkelrichtung(Asteroid pAst, GameStatus game)
       {
           double firstWinkel = retWinkelzumSchiff(game, normalShipx(pAst.x),normalShipy(pAst.y));
           int[] newPos = nextPosition(pAst, 15);
           double sndWinkel = retWinkelzumSchiff(game, normalShipx(newPos[0]), normalShipy(newPos[1]));

           if (firstWinkel > sndWinkel && betrag(firstWinkel - sndWinkel) < 180)
           {
               return -1;
           }
           if (firstWinkel > sndWinkel && betrag(firstWinkel - sndWinkel) > 180)
           {
               return 1;
           }

           if (firstWinkel < sndWinkel && betrag(firstWinkel - sndWinkel) < 180)
           {
               return 1;
           }
           if (firstWinkel < sndWinkel && betrag(firstWinkel - sndWinkel) > 180)
           {
               return -1;
           }
           return -1;
       }

       private int getWinkelrichtung(Saucer pSaucer, GameStatus game)
       {
           double firstWinkel = retWinkelzumSchiff(game, normalShipx(pSaucer.x),normalShipy(pSaucer.y));
           int[] newPos = new int[2] { pSaucer.x + 15 * pSaucer.dx, pSaucer.y + 15 * pSaucer.dy };
           double sndWinkel = retWinkelzumSchiff(game, normalShipx(newPos[0]), normalShipy(newPos[1]));

           if (firstWinkel > sndWinkel && betrag(firstWinkel - sndWinkel) < 180)
           {
               return -1;
           }
           if (firstWinkel > sndWinkel && betrag(firstWinkel - sndWinkel) > 180)
           {
               return 1;
           }

           if (firstWinkel < sndWinkel && betrag(firstWinkel - sndWinkel) < 180)
           {
               return 1;
           }
           if (firstWinkel < sndWinkel && betrag(firstWinkel - sndWinkel) > 180)
           {
               return -1;
           }
           return -1;
       }

       
       private Boolean zieltreffer(GameStatus game, int pWinkel, Asteroid pAst)
       {
           double Vsx = Math.Cos(Schussrichtungen[pWinkel] * 0.017453293) * 8;
           double Vsy = Math.Sin(Schussrichtungen[pWinkel] * 0.017453293) * 8;

           double Sx = Shipx + 2.5 * Vsx;
           double Sy = Shipy + 2.5 * Vsy;

           double Ax = pAst.x + Math.Round(mLatenz + 1) * pAst.dx;
           double Ay = pAst.y + Math.Round(mLatenz + 1) * pAst.dy;


           int r = 10;
            switch (pAst.sf)
            {	// Größe des Asteroiden
                case 0:  // großer Asteroid
                    r = RadiusGross;
                    break;
                case 15: // mittlerer Asteroid
                    r = RadiusMittel;
                    break;
                case 14: // kleiner Asteroid
                    r = RadiusKlein;
                    break;
            }

           

           double vx = Vsx - pAst.dx;
           double vy = Vsy - pAst.dy;

           for (int t = 0; t <= 70; t++)
           {             
               if(ddistance(normalx((int)(Ax+ t*pAst.dx)),normaly((int)(Ay+ t*pAst.dy)),normalx((int)(Sx+t*Vsx)),normaly((int)(Sy+t*Vsy))) < r-1)
               {
                   return true;
               }
           }
           return false;

       }


       private Boolean zieltreffer(GameStatus game, int pWinkel, Saucer pSaucer)
       {
           double Vsx = Math.Cos(Schussrichtungen[pWinkel] * 0.017453293) * 8;
           double Vsy = Math.Sin(Schussrichtungen[pWinkel] * 0.017453293) * 7.9;

           double Sx = Shipx + 2.5 * Vsx;
           double Sy = Shipy + 2.5 * Vsy;

           double Ax = mySaucer.x + Math.Round(mLatenz + 1) * mySaucer.dx;
           double Ay = mySaucer.y + Math.Round(mLatenz + 1) * mySaucer.dy;

           int r = 10;

           double vx = Vsx - pSaucer.dx;
           double vy = Vsy - pSaucer.dy;

           for (int t = 0; t <= 70; t++)
           {
               if (ddistance(normalx((int)(Ax+ t*mySaucer.dx)),normaly((int)(Ay+ t*mySaucer.dy)),normalx((int)(Sx+t*Vsx)),normaly((int)(Sy+t*Vsy))) < (r-2))
               {
                   return true;
               }
           }
           return false;

       }

       private int[] retDrehung(GameStatus game, Asteroid pAst)
       {
           int[] Steuerung = new int[2];
           if (pAst == null)
           {
               pAst = new Asteroid(0, 0, 0, 0); 
           }
           int vekASx = Shipx - normalShipx(pAst.x);
           int vekASy = Shipy - normalShipy(pAst.y);
           double vx = pAst.dx;
           double vy = pAst.dy;
           int Winkelrichtung = getWinkelrichtung(pAst, game);
           int[] firstPosition = movementasteroid(pAst, 0);
           int firstWinkel = findNearestWinkel(retWinkelzumSchiff(game,normalShipx(firstPosition[0]),normalShipy(firstPosition[1])));
           double Vsx = Math.Cos(Schussrichtungen[firstWinkel] * 0.017453293) * 8;
           double Vsy = Math.Sin(Schussrichtungen[firstWinkel] * 0.017453293) * 7.875;
           double vdx = pAst.dx - Vsx;
           double vdy = pAst.dy - Vsy;
           int vorWinkel = firstWinkel;
           int backWinkel = firstWinkel;
           double dVor = -1;
           double dBack = 1;

           double t = (vekASx * Vsy + vekASy * Vsx) / (vx * Vsy - vy * Vsx);
           double n = (vekASx * vy + vekASy * vx) / (vx * Vsy - vy * Vsx);

           int naWinkel = findNearestWinkel(retWinkelzumSchiff(game,normalShipx(pAst.x),normalShipy(pAst.y)));
           
           
           //einfache Methode
           Boolean fMethod = false;
           for (int i = 0; i < 15; i++)
           {
               if (zieltreffer(game, naWinkel, pAst))
               {
                   fMethod = true;
                   break;
               }
               naWinkel = (naWinkel + Winkelrichtung + 256) % 256;
           }
           firstWinkel = naWinkel;

           if (!fMethod)
           {
               for (int i = 0; i < 15; i++)
               {
                   if (zieltreffer(game, firstWinkel, pAst))
                   {
                       break;
                   }
                   double ent = (vekASx * vdy + vekASy * vdx) / (vx * Vsy - vy * Vsx);
                   if (ent < 0)
                   {
                       firstWinkel = (firstWinkel + 256 + Winkelrichtung) % 256;
                       if (dVor > ent || dVor == -1)
                       {
                           dVor = ent;
                           vorWinkel = firstWinkel;
                       }
                   }
                   else
                   {
                       firstWinkel = (firstWinkel + 256 - Winkelrichtung) % 256;
                       if (dBack < ent || dBack == 1)
                       {
                           dBack = ent;
                           backWinkel = firstWinkel;
                       }
                   }

                   Vsx = Math.Cos(Schussrichtungen[firstWinkel] * 0.017453293) * 8;
                   Vsy = Math.Sin(Schussrichtungen[firstWinkel] * 0.017453293) * 8;
                   vdx = pAst.dx - Vsx;
                   vdy = pAst.dy - Vsy;

               }
               if (zieltreffer(game, backWinkel, pAst))
               {
                   firstWinkel = backWinkel;
               }
               else
               {
                   firstWinkel = vorWinkel;
               }


               if (zieltreffer(game, findNearestWinkel(retWinkelzumSchiff(game, normalShipx(pAst.x), normalShipy(pAst.y))), pAst))
               {
                   firstWinkel = findNearestWinkel(retWinkelzumSchiff(game, normalShipx(pAst.x), normalShipy(pAst.y)));
               }
           }
 
           //falls auf das Ufo geschossen werden soll
           
           if (game.saucer_present && akZielSaucer)
           {
               int nWinkel = findNearestWinkel(retWinkelzumSchiff(game,normalShipx(mySaucer.x),normalShipy(mySaucer.y)));
               int SWinkelrichtung = getWinkelrichtung(mySaucer, game);
               for (int i = 0; i < 10; i++)
               {
                   if(zieltreffer(game,nWinkel,mySaucer))
                   {
                       break;
                   }
                   nWinkel = (nWinkel +SWinkelrichtung +256) %256;
               }
               firstWinkel = nWinkel;

           }

           //effizentes Drehen bei Asteroiden
           if (betrag(firstWinkel - winkelbytenext) > 15 && !akZielSaucer)
           {
               firstWinkel = findNearestWinkel(retWinkelzumSchiff(game, normalShipx((int)(pAst.x + betrag(firstWinkel - winkelbytenext) * pAst.dx)), normalShipy((int)(pAst.y + betrag(firstWinkel - winkelbytenext) * pAst.dy))));
           }

           if (winkelbytenext < firstWinkel)
           {
               Steuerung[0] = LINKS;
           }
           else if (winkelbytenext == firstWinkel)
           {
               Steuerung[0] = NICHTS;
           }
           else if (winkelbytenext > firstWinkel)
           {
               Steuerung[0] = RECHTS;
           }
           
           
 
           return Steuerung;

       }

       private Asteroid getnextAsteroid(GameStatus game)
       {
           if (asteroidlist.Count == 0)
           {
               if (game.saucer_present)
               {
                   akZielSaucer = true;
               }
               return null;
           }

           akZielSaucer = false;
           //Kollision
           
           foreach (Asteroid pAst in asteroidlist)
           {
               pAst.setPrio(0);

               for (int i = 0; i <= 60; i++)
               {
                   if (distmomShip(pAst, i) < 10)
                   {
                       pAst.setPrio(150);
                   }
               }

               //Schüsse
               int AstShots = 1;

               switch (pAst.sf)
               {	// Größe des Asteroiden
                   case 0:  // großer Asteroid
                       AstShots = shotgross;
                       break;
                   case 15: // mittlerer Asteroid
                       AstShots = shotmittel;
                       break;
                   case 14: // kleiner Asteroid
                       AstShots = shotklein;
                       break;
               }
               if (pAst.numberofshots >= AstShots)
               {
                   pAst.setPrio(pAst.Prioritaet - 100);
               }
               //typ bonus
               if (pAst.sf == 14)
               {
                   pAst.setPrio(pAst.Prioritaet + 10);
               }

               //Entfernung der geraden
               if (distGeradeShip(pAst,100,game) < 50)
               {
                   pAst.setPrio(pAst.Prioritaet + 60);
               }

               //LetztesZiel
               if (pAst.id == AsteroidAimID)
               {
                   pAst.setPrio(pAst.Prioritaet + 30);
               }

           }

           //Entfernung
           asteroidlist.Sort(sortAsteroidlistDistance);
           for (int i = 0; i < asteroidlist.Count; i++)
           {
               asteroidlist[asteroidlist.Count - 1 - i].setPrio(asteroidlist[asteroidlist.Count - 1 - i].Prioritaet + i * FkDistance);
           }
           //Entfernung vom letzten Asteroiden
           asteroidlist.Sort(sortAsteroidlistDistanceAimAsteroid);
           for (int i = 0; i < asteroidlist.Count; i++)
           {
               asteroidlist[asteroidlist.Count - 1 - i].setPrio(asteroidlist[asteroidlist.Count - 1 - i].Prioritaet + i * FKdisAimAsteroid);
           }
           //Nach dem Drehwinkel
           asteroidlist.Sort(sortAsteroidlistWinkel);
           for (int i = 0; i < asteroidlist.Count; i++)
           {
               asteroidlist[asteroidlist.Count - 1 - i].setPrio(asteroidlist[asteroidlist.Count - 1 - i].Prioritaet + i * FkWinkel);
           }
           //geschwindigkeit
           asteroidlist.Sort(sortAsteroidlistgeschw);
           for (int i = 0; i < asteroidlist.Count; i++)
           {
               asteroidlist[asteroidlist.Count - 1 - i].setPrio(asteroidlist[asteroidlist.Count - 1 - i].Prioritaet + i * FKgeschw);
           }

           asteroidlist.Sort(sortAsteroidlistPrio);
           if (asteroidlist[0].Prioritaet < 160 && mySaucer.numberofshots <= shotsaucer)
           {
               akZielSaucer = true;
           }
           else if (asteroidlist[0].Prioritaet < 50)
           {
               akZielSaucer = true;
           }
           //Variablen setzen
           AsteroidAimID = asteroidlist[0].id;
           koLastAsteroid[0] = asteroidlist[0].x;
           koLastAsteroid[1] = asteroidlist[0].y;
      
           return asteroidlist[0];


       }

       private Boolean retHyperspace(GameStatus game)
       {
           if (!Hyperspace)
           {
               return false;
           }
           foreach (Asteroid pAst in asteroidlist)
           {
               if (distmomShip(pAst, 0) < 0)
               {
                   return true;
               }
           }
           
           foreach (Shot pshot in shotlist)
           {
               if (pshot.SaucerShot)
               {
                   for (int i = 0; i < 8; i++)
                   {
                       if (ddistance((int)(pshot.x + i * pshot.dx), (int)(pshot.y + i * pshot.dy), Shipx, Shipy) < 1.5 * RadiusSchiff)
                       {
                           return true;
                       }
                   }
               }
           }
           return false;
       }

       public void geschwlog()
       {
           
           
           if (AsteroidID < 100)
           {
               foreach (Asteroid ast in asteroidlist)
               {
                   if (ast.gcount == 19)
                   {
                       gFile.WriteLine("Asteroid ID: " + ast.id);
                       foreach (double pint in ast.geschwarray)
                       {
                           gFile.WriteLine(pint);
                       }
                       gFile.WriteLine("");
                       
                   }

               }
               
               
           }
           else if(!close)
           {
               gFile.Close();
               Console.WriteLine("fertig");
               close = true;
           }

       }



   }

   

      
}
        
