#ifndef SHOTMIRAGE_H_
#define SHOTMIRAGE_H_

#include <wx/gdicmn.h>
#include "Angle.h"

class ShotMirage
{
private:
	int frameID;
	wxPoint start;
	wxPoint flightVector;
	wxPoint position;
	unsigned char udpID;
public:
	ShotMirage(int frameID,const wxPoint& start,const wxPoint& position,const wxPoint& flightVector, unsigned char udpID);
	
	ShotMirage();
	
	void setFlightVector(const wxPoint& flightVector)
	{
		this->flightVector = flightVector;
	}
	
	wxPoint& getFlightVector()
	{
		return flightVector;
	}
	
	void setPosition(const wxPoint& pos)
	{
		position = pos;
	}
	
	wxPoint& getPosition()
	{
		return position;
	}
	
	void setStartPosition(const wxPoint& start)
	{
		this->start = start;
	}
	
	wxPoint& getStartPosition()
	{
		return start;
	}
	
	void simulateFrames(int frameID);
	
	void setID(unsigned char ID)
	{
		this->udpID = ID;
	}
	
	unsigned char getID()
	{
		return udpID;
	}
	
	void setFrameID(int frameID)
	{
		this->frameID = frameID;
	}
		
	int getFrameID()
	{
		return frameID;
	}
	
};

#endif /*SHOTMIRAGE_H_*/
