#include "ShotMirage.h"
#include "Tools.h"


ShotMirage::ShotMirage(int frameID,const wxPoint& start,const wxPoint& position, const wxPoint& flightVector, unsigned char udpID):
		frameID(frameID),
		start(start),
		flightVector(flightVector),
		position(position),
		udpID(udpID)
		{
		}
		
ShotMirage::ShotMirage():
	frameID(-1),
	start(wxPoint(0,0)),
	flightVector(wxPoint(0,0)),
	position(wxPoint(0,0)),
	udpID(0)
	{
	}
		
void ShotMirage::simulateFrames(int newFrameID)
{
	position.x += flightVector.x * Tools::getFrameDiff(frameID,newFrameID);
	position.y += flightVector.y * Tools::getFrameDiff(frameID,newFrameID);
	
	frameID = newFrameID;
}
