#ifndef LOG_H_
	#define LOG_H_
	///////////////////////////////
	//#define _LOG_IO
	//#define _LOG_IO_FILE "IO.log"
	//#define _LOG_FRAMES_
	//#define _LOG_TRACKING
	//#define _LOG_TRACKING_FILE "Tracking.log"
	//#define _LOG_PLAYER
	//#define _LOG_PLAYER_FILE "Player.log"
	///////////////////////////////
	#if defined _LOG_IO || defined _LOG_TRACKING || defined _LOG_PLAYER
		#include <iostream>
	#endif
	#if defined _LOG_IO_FILE || defined _LOG_TRACKING_FILE || defined _LOG_PLAYER_FILE
		#include <fstream>
		class Log
		{
		public:
			#ifdef _LOG_IO_FILE
			static std::ofstream IOLogStream;
			#endif
			#ifdef _LOG_TRACKING_FILE
			static std::ofstream TrackingLogStream;
			#endif
			#ifdef _LOG_PLAYER_FILE
			static std::ofstream PlayerLogStream;
			#endif
		};
	#endif
	#ifdef _LOG_IO_FILE
		#define IOLog(x) Log::IOLogStream << "[IO]" << x << std::endl
	#elif defined _LOG_IO
		#define IOLog(x) std::clog << "[IO]" << x << std::endl
	#else
		#define IOLog(x)
	#endif
	#ifdef _LOG_TRACKING_FILE
		#define TrackingLog(x) Log::TrackingLogStream << "[Tr]" << x << std::endl
	#elif defined _LOG_TRACKING
		#define TrackingLog(x) std::clog << "[Tr]" << x << std::endl
	#else
		#define TrackingLog(x)
	#endif
	#ifdef _LOG_PLAYER_FILE
		#define PlayerLog(x) Log::PlayerLogStream << "[Pl]" << x << std::endl
	#elif defined _LOG_PLAYER
		#define PlayerLog(x) std::clog << "[Pl]" << x << std::endl
	#else
		#define PlayerLog(x)
	#endif
#endif
