#ifndef LINKEDLIST_H_
#define LINKEDLIST_H_
	
template<class T>
class LinkedList
{
protected:
class LinkedListElement
	{
		friend class LinkedList;
		friend class Enumerator;
	private:
		T data;
		LinkedListElement* next;
		LinkedListElement* prev;
	public:
		LinkedListElement(T& data):data(data),next(0),prev(0)
		{
		}
		
		T& getData()
		{
			return data;
		}
		
		void setData(T& data)
		{
			this->data = data;
		}
		
		LinkedListElement* getNext()
		{
			return next;
		}
		
		void setNext(LinkedListElement* next)
		{
			this->next = next;
		}
		
		LinkedListElement* getPrev()
		{
			return prev;
		}
		
		void setPrev(LinkedListElement* prev)
		{
			this->prev = prev;
		}
		
	};
public:
	class Enumerator
	{
	private:
		friend class LinkedList<T>;
		LinkedListElement* element;
		Enumerator(LinkedListElement* element):element(element)
		{
		}
	public:
		T& getNext()
		{
			T& result = element->data;
			element = element->next;
			return result;		
		}
		
		T& getPrev()
		{
			T& result = element->data;
			element = element->prev;
			return result;		
		}
		
		bool hasNext()
		{
			if(element)
				return true;
				
			return false;
		}	
	};
protected:
	
	LinkedListElement* first;
	LinkedListElement* last;
	
	Enumerator* currentEnumerator;
public:	
	LinkedList()
	{
		first = last = 0;
		currentEnumerator = 0;
	}
	
	LinkedList(const LinkedList& ref);
	
	LinkedList& operator=(const LinkedList& ref);
	
	virtual ~LinkedList()
	{
		while(first)
		{
			last = first->getNext();
			delete first;
			first = last;
		}
		
		if(currentEnumerator)
			delete currentEnumerator;
	}
	
	virtual T& addElement(T& data);	
	virtual T& addElement(T * data);
	virtual void removeElement(T& data);
	Enumerator& getEnumerator();
	Enumerator& getNewEnumerator();
	
		
};

template<class T>
LinkedList<T>::LinkedList(const LinkedList& ref)
{
	
	first = last = 0;
	currentEnumerator = 0;
	LinkedListElement* current = ref.first;
	
	while(current)
	{
		addElement(current->data);
		if(ref.currentEnumerator && ref.currentEnumerator->element == current)
		{
			currentEnumerator = new Enumerator(last);
		}
		current = current->next;
	}
}

template<class T>
LinkedList<T>& LinkedList<T>::operator =(const LinkedList& ref)
{
	LinkedListElement* current = ref.first;
	
	while(current)
	{
		addElement(current->data);
		if(ref.currentEnumerator && ref.currentEnumerator->element == current)
		{
			currentEnumerator = new Enumerator(last);
		}
		current = current->next;
	}
	
	return *this;
	
	
}
		

template<class T>
T& LinkedList<T>::addElement(T* data)
{
	T& result = addElement(*data);
	delete data;
	
	return result;
}

template<class T>
T& LinkedList<T>::addElement(T& data)
{
	LinkedListElement* newElement = new LinkedListElement(data);

	if(last == 0)
	{
		first = last = newElement;
	}
	else
	{
		last->next = newElement;
		newElement->prev = last;
		last = newElement;
	}
	
	return newElement->data;	
}

template<class T>
void LinkedList<T>::removeElement(T& data)
{
	LinkedListElement* current = first;
	
	while(current != 0)
	{
		if((current->data) == data)
		{
			if(current == first)
			{
				if(last == first)
					last = first = 0;
				else
				{
					first->next->prev = 0;
					first = first->next;
				}
			}
			else if(current == last)
			{
				last->prev->next = 0;
				last = last->prev;
			}
			else
			{
				current->next->prev = current->prev;
				current->prev->next = current->next;
			}
			
			delete current;
			break;
		}
		current = current->next;
	}
}


template<class T>
typename LinkedList<T>::Enumerator& LinkedList<T>::getEnumerator()
{
	if(currentEnumerator)
		return *currentEnumerator;
		
	currentEnumerator = &getNewEnumerator();
	
	return *currentEnumerator;
}

template<class T>
typename LinkedList<T>::Enumerator& LinkedList<T>::getNewEnumerator()
{
	currentEnumerator = new Enumerator(first);
	
	return *currentEnumerator;
}
#endif /*LINKEDLIST_H_*/
