// player.cpp: Beispielspieler fr Asteroids
// Original von Harald Bgeholz / c't
// 29.06.2008
// erweitert von Olaf Ehbrecht, Hamburg, ( oehbrecht@web.de )
// unter Verwendung der Schusswinkeldatei von AnDann
// entwickelt mit MS Visual C++ 2008 Express Edition
//
// Latenz 1 Variante, d.h. sofort nach Empfang eines Frames wird das (vorherige) keypaket gesendet
// Tritt zustzlich Latenz auf (erkennbar an Fehlermeldung) fhrt das mit Sicherheit zu Fehlfunktionen.
// Verlust von einzelnen Frames knnen, abhngig von der Spielsituation, "verkaftet" werden.

/*	Testumgebung
	Asteroid-Client Win2K-SP4,  AMD Athlon XP, 2 GHz
	Mameserver		Win-XP-SP2, AMD Athlon 64 X2 Dual, 4400+, 2.2 GHz

	30.06.2008 Bestmarke 99880
*/

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <iomanip>
#include <errno.h>
#include <string.h>
#include <math.h>
#include <time.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#ifdef DEBUG
//#define DEBUG_TIME1
#define DEBUG_WINKELBYTE
#endif


#include "player.h"

#define BASE_Y					128
#define MAX_SCHUSSWEITE			710
#define MIN_COLLISION_TIME		120
#define PRAEZISION_PRIMARY		1.24
#define PRAEZISION_SECONDARY	1.24
#define SHOT_SPEED				8.0

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus game, last_game;
	char prevframe = 0;

	int t = 20;	// Offset wegen verzgerter Reaktion auf keys
	KeysPacket last_keys[20];

	for ( int i=1; i<20; i++ ) {
		last_keys[i].clear();
	}

	// Variable fr Distanzermittlung / Speicherung
	Distance	current_dist;

	Distance	min_ast;
	Distance	min_col_ast;

	Distance	dist_saucer;

	Distance	min_shots;
	Distance	min_col_shots;

	Distance	target_distance;

	Distance	alternativ_targets[100];

	int			min_total_distance;
	int			tmp_total_distance;

	Speed		speed_dist;
	int			radius;

	double		delta_degree;
	double		rotation_diff_degree;
	double		calc_ship_degree;
	double		eth;

	int latenz;
	int gsp;

	int count_of_own_shots;

	bool		frame_lost = false;

	bool		new_game_started = true;
	bool		first_degree_suggested = false;
	bool		first_fire_started = false;
	int			time_of_first_fire = 0;

	Position	shot_next_pos;
	Position	ast_next_pos;

#ifdef DEBUG_TIME
	clock_t	last_clock;
	clock_t	current_clock;
#endif

	game.clear();
	game.ship_shot_pos = 192;
	last_game.clear();
	last_game.ship_shot_pos = 192;

	keys.clear();   // alle Tasten loslassen
	++keys.ping;

	cout << "send first keys ..." << endl;
	SendPacket(keys);
//	sleep((clock_t) 64 );	// 16ms warten
#ifdef DEBUG_TIME
	current_clock = clock();
#endif

	for (;;)
	{
#ifdef DEBUG_TIME
		last_clock = current_clock;
		current_clock = clock();
		cout << "calc time  " << setw(8) << current_clock-last_clock;
#endif
		ReceivePacket(frame);
#ifdef DEBUG_TIME
		last_clock = current_clock;
		current_clock = clock();
		cout << " recv frame " << setw(8) << current_clock-last_clock << endl;
#endif

		latenz = keys.ping - frame.ping;

		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);

		if (t == 30)
			SendPlayerName();

		frame_lost = false;
		if (frame.frameno != ++prevframe || latenz != 0)
		{
			if ( !new_game_started ) {
				printf("Latenz %d. %d Frames verloren.\n", latenz, frame.frameno - prevframe);
			}

			if ( frame.frameno != ( prevframe -1 ) ) {
				frame_lost = true;
			}

			prevframe = frame.frameno;
		}

		++t;         // Zeit

#ifdef DEBUG
		cout << "\ntime: " << t << endl;
#endif

		// save last_game
		last_game = game;

		InterpretScreen(t, frame, game);

		{
			// calc ship speed
			if ( game.ship_present ) {
				if ( new_game_started && !first_degree_suggested ) {
					double start_degree = game.current_ship_dir.getInDegree();
					int  shot_idx=0;
					while ( shot_idx < 256 && shot_dir_sorted[shot_idx] < start_degree ) {
						shot_idx++;
					}
					game.ship_shot_pos = shot_dir_sorted_idx[shot_idx];
					last_game.ship_shot_pos = shot_dir_sorted_idx[shot_idx];

#ifdef DEBUG_WINKELBYTE
					cout << "start_degree " << start_degree << " shot_dir_sorted[" << shot_idx << "] " << shot_dir_sorted[shot_idx] << " --> " << shot_dir_sorted_idx[shot_idx] << endl;
#endif

					first_degree_suggested = true;
				}

				// left/right vor zwei frames wirkt sich jetzt erst aus
				if ( last_keys[(t - 3) % 20].isright() ) {
					game.ship_shot_pos = (game.ship_shot_pos + 1) % 256;
				}
				else if ( last_keys[(t - 3) % 20].isleft() ) {
					game.ship_shot_pos = (game.ship_shot_pos - 1);
					if ( game.ship_shot_pos < 0 ) game.ship_shot_pos = game.ship_shot_pos + 256;
				}

				if ( !new_game_started && frame_lost ) {
					++t;
					// left/right vor zwei frames wirkt sich jetzt erst aus
					if ( last_keys[(t - 3) % 20].isright() ) {
						game.ship_shot_pos = (game.ship_shot_pos + 1) % 256;
					}
					else if ( last_keys[(t - 3) % 20].isleft() ) {
						game.ship_shot_pos = (game.ship_shot_pos - 1);
						if ( game.ship_shot_pos < 0 ) game.ship_shot_pos = game.ship_shot_pos + 256;
					}
				}

				if ( ! game.last_ship_pos.is_cleared() ) {
					game.current_ship_speed = game.current_ship_pos - game.last_ship_pos;
				}
			}
			else {
				// ship ist weg -> reset
				game.start_ship_pos.clear();
				game.last_ship_pos.clear();
			}


			// calc saucer speed
			if ( game.saucer_present ) {
				if ( ! game.last_saucer_pos.is_cleared() ) {

					game.current_saucer_speed = game.current_saucer_pos - game.last_saucer_pos;

					game.current_saucer_dir.dx = game.current_saucer_speed.dx;
					game.current_saucer_dir.dy = game.current_saucer_speed.dy;
				}
			}
			else {
				// saucer ist weg -> reset
				game.start_saucer_pos.clear();
				game.last_saucer_pos.clear();
				game.saucer_targeted = false;
			}

			// detect and calc shot speed
			if ( game.nshots > 0 ) {
				for ( int i=0; i<game.nshots; i++ ) {
					// search in lastlist
					if ( last_game.nshots > 0 ) {
						int j = 0;
						bool found = false;
						while ( ( ! found ) && ( j < last_game.nshots ) ) {
							if	( ! last_game.shots[j].current_pos.is_cleared() ) {
								if ( ! last_game.shots[j].start_pos.is_cleared()
								     &&	abs( game.shots[i].current_pos.x - ( last_game.shots[j].current_pos.x + last_game.shots[j].current_speed.dx ) ) <= 2
								     && abs( game.shots[i].current_pos.y - ( last_game.shots[j].current_pos.y + last_game.shots[j].current_speed.dy ) ) <= 2
								   ) {
									found = true;
								}
								else if ( game.shots[i].current_pos.distance(last_game.shots[j].current_pos) < 13 ) {
									found = true;
								}
								else {
									j++;
								}
							}
							else {
								j++;
							}
						}
						if ( found ) {
							game.shots[i].last_pos = last_game.shots[j].current_pos;
							game.shots[i].current_speed = last_game.shots[j].current_speed;
							game.shots[i].current_dir = last_game.shots[j].current_dir;
							game.shots[i].own_shot = last_game.shots[j].own_shot;

							if ( ! ( last_game.shots[j].start_pos.is_cleared() ) ) {
								game.shots[i].start_pos = last_game.shots[j].start_pos;
								game.shots[i].recalc_possible = last_game.shots[j].recalc_possible;
							}
							else {
								game.shots[i].start_pos = game.shots[i].last_pos;

								// so nahe kann nur der eigene sein
								if ( ! game.saucer_present
									|| game.shots[i].current_pos.distance(game.current_ship_pos) <= 40 ) {
									game.shots[i].own_shot = true;
								}
							}

							// recalc Direction and Speed
							game.shots[i].recalc();

							// cleared damit nicht erneut verwendet
							last_game.shots[j].current_pos.clear();
						}
					}
				}
			}

			if ( new_game_started && first_fire_started ) {
				if ( t > ( time_of_first_fire + 14 ) ) {
					double shot_degree = game.shots[0].current_dir.getInDegree();
					double min_degree_diff = 360.1;
					int    min_degree_idx = 0;
					for ( int shot_idx=0; shot_idx < 256; shot_idx++ ) {
						if ( abs( shot_dir_sorted[shot_idx] - shot_degree ) < min_degree_diff ) {
							min_degree_diff = abs( shot_dir_sorted[shot_idx] - shot_degree );
							min_degree_idx = shot_idx;
						}
					}

					game.ship_shot_pos = shot_dir_sorted_idx[min_degree_idx];
					last_game.ship_shot_pos = shot_dir_sorted_idx[min_degree_idx];

#ifdef DEBUG_WINKELBYTE
					cout << "shot_degree " << shot_degree << " shot_dir_sorted[" << min_degree_idx << "] " << shot_dir_sorted[min_degree_idx] << " --> " << shot_dir_sorted_idx[min_degree_idx] << endl;
#endif

					new_game_started = false;
				}
			}

			// detect and calc asteroid speed
			if ( game.nasteroids > 0 ) {
				for ( int i=0; i<game.nasteroids; i++ ) {
					// search in lastlist
					if ( last_game.nasteroids > 0 ) {
						int j = 0;
						bool found = false;

						while ( ( ! found ) && ( j < last_game.nasteroids)  ) {
							if	( 	! last_game.asteroids[j].current_pos.is_cleared()
								 &&	game.asteroids[i].type == last_game.asteroids[j].type
								 && game.asteroids[i].sf == last_game.asteroids[j].sf ) {
								if ( ! last_game.asteroids[j].start_pos.is_cleared()
									 &&	abs( game.asteroids[i].current_pos.x - ( last_game.asteroids[j].current_pos.x + last_game.asteroids[j].current_speed.dx ) ) <= 2
									 && abs( game.asteroids[i].current_pos.y - ( last_game.asteroids[j].current_pos.y + last_game.asteroids[j].current_speed.dy ) ) <= 2
								   ) {
									found = true;
								}
								else if ( game.asteroids[i].current_pos.distance(last_game.asteroids[j].current_pos) <= 12 ) {
									found = true;
								}
								else {
									j++;
								}
							}
							else {
								j++;
							}
						}
						if ( found ) {
							game.asteroids[i].last_pos = last_game.asteroids[j].current_pos;

							game.asteroids[i].current_speed = last_game.asteroids[j].current_speed;
							game.asteroids[i].current_dir = last_game.asteroids[j].current_dir;

							game.asteroids[i].targeted = last_game.asteroids[j].targeted;
							game.asteroids[i].targeted_count = last_game.asteroids[j].targeted_count;
							game.asteroids[i].targeted_expected_time_to_hit = last_game.asteroids[j].targeted_expected_time_to_hit;

							// wenn retargeted, dann resetten wir vorsichtshalber die startpos
							if ( !game.asteroids[i].is_targeted(t)
								 && game.asteroids[i].targeted
								 && (
										( game.asteroids[i].sf != 0 && game.asteroids[i].sf != 15 && game.asteroids[i].targeted_count > 2 )
									 ||	( game.asteroids[i].sf == 0 && game.asteroids[i].targeted_count > 4 )
									 ||	( game.asteroids[i].sf != 15 && game.asteroids[i].targeted_count > 3 )
								 )
							   ) {
							    game.asteroids[i].targeted_count = 0;
							    game.asteroids[i].targeted = false;
								game.asteroids[i].recalc_possible = true;
								last_game.asteroids[j].start_pos.clear();
							}

							if ( ! ( last_game.asteroids[j].start_pos.is_cleared() ) ) {
								game.asteroids[i].start_pos = last_game.asteroids[j].start_pos;
								game.asteroids[i].recalc_possible = last_game.asteroids[j].recalc_possible;
							}
							else {
								game.asteroids[i].start_pos = game.asteroids[i].last_pos;
							}

							// recalc Direction and Speed
							game.asteroids[i].recalc();

							last_game.asteroids[j].current_pos.clear();
						}
					}
				}
			}

		}

#ifdef DEBUG
		cout << "new :" << endl << game;
#endif

		keys.clear();   // alle Tasten loslassen

		if (game.ship_present)
		{
			min_ast.clear();
			min_ast.total_distance = 9876789;
			min_ast.degree = 360.1;
			min_col_ast.clear();
			min_col_ast.total_distance = 9876789;
			min_col_ast.degree = 360.1;
			min_total_distance = 9876789;

			for (int i=0; i<game.nasteroids; i++)
			{
				current_dist.clear();
				alternativ_targets[i].clear();

				tmp_total_distance = game.asteroids[i].current_pos.distance(game.current_ship_pos);

				if ( ! game.asteroids[i].is_targeted( t )
					 || ( game.asteroids[i].sf == 0 && game.asteroids[i].targeted_count == 1 )
					 || ( game.asteroids[i].sf == 0 && game.asteroids[i].targeted_count == 2 )
					 || ( game.asteroids[i].sf == 0 && game.asteroids[i].targeted_count == 3 )
					 || ( game.asteroids[i].sf == 15 && game.asteroids[i].targeted_count == 1 )
					 || ( game.asteroids[i].sf == 15 && game.asteroids[i].targeted_count == 2 )
				   ) {
					// nchstgelegenen Asteroiden suchen
					speed_dist =  game.asteroids[i].current_pos - game.current_ship_pos;

					current_dist.set( tmp_total_distance,
									 game.asteroids[i].current_speed,
									 round( speed_dist.dx ),
									 round( speed_dist.dy ),
									 i
								   );

					// Winkel zum ship und Kollisionsbereich ermitteln
					// wenn der Winkel des Objekts, unter Beachtung des Kollisionsbereich, gleich dem Winkel zum ship ist,
					// dann treffen sich die Objekte

					radius = 6;
					current_dist.degree = game.asteroids[i].current_pos.degree(game.current_ship_pos);

					switch (game.asteroids[i].sf)
					{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
						case 0:  // groer Asteroid
							radius += 32;
							break;
						case 15: // mittlerer Asteroid
							radius += 10;
							break;
						case 14: // kleiner Asteroid
							radius += 2;
							break;
					}
					current_dist.set_collision_window( radius );

					if ( ! game.asteroids[i].start_pos.is_cleared() ) {
						alternativ_targets[i] = current_dist;

						if ( abs( game.asteroids[i].current_dir.getInDegree() - current_dist.degree ) < ( 2.4 * current_dist.collision_window )
							 && ( current_dist.total_distance < MAX_SCHUSSWEITE ) ) {
							if ( current_dist.total_distance < min_col_ast.total_distance
								|| current_dist.collision_time < min_col_ast.collision_time ) {
								min_col_ast = current_dist;
							}
						}
						else {
#ifdef DEBUG_1
							cout << "== cur " <<  current_dist << " min " << min_ast << endl;
#endif
							if (
								   current_dist.total_distance < min_ast.total_distance
							   ) {
								min_ast = current_dist;
							}
						}
					}
				}

				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						tmp_total_distance -= 21;
						break;
					case 15: // mittlerer Asteroid
						tmp_total_distance -= 9;
						break;
					case 14: // kleiner Asteroid
						tmp_total_distance -= 2;
						break;
				}

				if ( tmp_total_distance < min_total_distance ) {
					min_total_distance = tmp_total_distance;
				}
			}

			dist_saucer.clear();
			if ( game.saucer_present && ! game.saucer_is_targeted( t ) )
			{
				speed_dist = game.current_saucer_pos - game.current_ship_pos;

				dist_saucer.set( game.current_saucer_pos.distance(game.current_ship_pos),
								 game.current_saucer_speed,
								 round( speed_dist.dx ),
								 round( speed_dist.dy ),
								 -1
							   );

				radius = 0;
				dist_saucer.degree = game.current_saucer_pos.degree(game.current_ship_pos);

				switch (game.saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					radius += 18;
					break;
				case 14: // kleines UFO
					radius += 10;
					break;
				}
				dist_saucer.set_collision_window( radius );
			}

			min_shots.clear();
			min_shots.total_distance = 9876789;
			min_col_shots.clear();
			min_col_shots.total_distance = 9876789;
			count_of_own_shots = 0;

			for (int i=0; i<game.nshots; ++i)
			{
				current_dist.clear();

				if ( ! game.shots[i].own_shot ) {

					// nchstgelegenen shot suchen
					speed_dist =  game.shots[i].current_pos - game.current_ship_pos;

					current_dist.set( game.shots[i].current_pos.distance(game.current_ship_pos),
									 game.shots[i].current_speed,
									 round( speed_dist.dx ),
									 round( speed_dist.dy ),
									 -1
								   );
					radius = 15; // ship
					current_dist.degree = game.shots[i].current_pos.degree(game.current_ship_pos);

					current_dist.set_collision_window( radius );
					if ( ! game.shots[i].start_pos.is_cleared()
						 && ! game.shots[i].own_shot ) {
						if ( abs( game.shots[i].current_dir.getInDegree() - current_dist.degree ) < ( current_dist.collision_window ) ) {
							if ( current_dist.total_distance < min_col_shots.total_distance
								|| current_dist.collision_time < min_col_shots.collision_time ) {
								min_col_shots = current_dist;
							}
						}
						else {
							if (
								 current_dist.total_distance < min_shots.total_distance
								||
								 current_dist.collision_time < min_shots.collision_time
							   ) {
								min_shots = current_dist;
							}
						}
					}
				}
				else {
					// prfen ob der shot eventuell schon getroffen hat
					bool	shot_isdead = false;

					shot_next_pos = game.shots[i].get_next_pos( 2 );

					for (int j=0; ( ( ! shot_isdead ) && j<game.nasteroids ) ; j++)
					{
						switch (game.asteroids[j].sf)
						{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
							case 0:  // groer Asteroid
								radius = 38;
								break;
							case 15: // mittlerer Asteroid
								radius = 18;
								break;
							case 14: // kleiner Asteroid
								radius = 8;
								break;
						}

						if ( round( game.shots[i].current_pos.distance(game.asteroids[j].current_pos) ) <= radius ) {
							shot_isdead = true;
						}
/*
						else {
							// eventuell erst im nchsten Frame?
							ast_next_pos = game.asteroids[j].get_next_pos( 2 );
							if ( round( shot_next_pos.distance(ast_next_pos) ) <= radius ) {
								shot_isdead = true;
							}
						}
*/
					}

					// koennte noch saucer getroffen haben
					if ( ! shot_isdead
						 && game.saucer_present
						 && (	( game.saucer_size == 15 && round( game.shots[i].current_pos.distance(game.current_saucer_pos) ) <= 16 )
						     || ( game.saucer_size == 14 && round( game.shots[i].current_pos.distance(game.current_saucer_pos) ) <= 8 )
							)
					   ) {
						shot_isdead = true;
					}

					if ( ! shot_isdead ) {
						count_of_own_shots++;
					}
				}
			}
			if ( last_keys[(t - 2) % 20].isfire() || last_keys[(t - 1) % 20].isfire() ) {
				count_of_own_shots++;
			}

			// Objekt auswhlen das wir als nchstes unter Beschu nehmen
			// ACHTUNG: Der Schu startet nicht sofort, sondern erst im bernchsten Frame
			//          Generell sind Schsse und Drehungen erst im bernchsten Frame sichtbar
			target_distance.clear();

			if ( ! min_col_ast.is_cleared() && ( ( min_col_ast.collision_time < MIN_COLLISION_TIME ) || ( game.nasteroids < 4 ) ) ) {
#ifdef DEBUG
				cout << "min_col_ast: " << min_col_ast << endl;
#endif
				target_distance = min_col_ast;
			}
			else {
				if ( ! dist_saucer.is_cleared() && ( dist_saucer.total_distance < MAX_SCHUSSWEITE ) ) {
					if ( min_ast.is_cleared()
						 || ( ! min_ast.is_cleared() && min_ast.collision_time > 20 )
					   ) {
#ifdef DEBUG
						cout << "dist_saucer: " << dist_saucer << endl;
#endif
						target_distance = dist_saucer;
					}
					else {
						if ( ! min_ast.is_cleared() ) {
#ifdef DEBUG
							cout << "min_ast: " << min_ast << endl;
#endif
							target_distance = min_ast;
						}
					}
				}
				else {
					if ( ! min_ast.is_cleared() ) {
#ifdef DEBUG
						cout << "min_ast: " << min_ast << endl;
#endif
						target_distance = min_ast;
					}
				}
			}

			if ( ! target_distance.is_cleared() ) {

				delta_degree = game.delta_in_degree( target_distance, &eth );

				// die Vergleichsposition ist die Position des ships im bernchsten Frame
				gsp = game.ship_shot_pos;

				// 1. Frame weiter
				if ( last_keys[(t - 2) % 20].isright() ) {
					gsp = (gsp + 1) % 256;
				}
				else if ( last_keys[(t - 2) % 20].isleft() ) {
					gsp = (gsp - 1);
					if ( gsp < 0 ) gsp = gsp + 256;
				}

				// 2. Frame weiter
				if ( last_keys[(t - 1) % 20].isright() ) {
					gsp = (gsp + 1) % 256;
				}
				else if ( last_keys[(t - 1) % 20].isleft() ) {
					gsp = (gsp - 1);
					if ( gsp < 0 ) gsp = gsp + 256;
				}

				calc_ship_degree = shot_direction[gsp];
				rotation_diff_degree = diff_degree( calc_ship_degree, delta_degree );

#ifdef DEBUG
				cout << "== ship_deg " << calc_ship_degree
					 << " tar_deg " << delta_degree
					 << " --> " << rotation_diff_degree
					 << endl;
#endif

				if ( rotation_diff_degree > 0.0 ) {
					keys.left(true);
				}
				else {
					keys.right(true);
				}

				if ( abs( rotation_diff_degree ) < ( target_distance.collision_window / PRAEZISION_PRIMARY ) ) {
					if ( ! last_keys[(t - 1) % 20].isfire() && count_of_own_shots < 4 ) {

						if ( target_distance.is_asteroid() ) {
								game.asteroids[target_distance.asteroid_number].mark_as_targeted( t + round( eth ) );
						}
						else {
							game.mark_saucer_as_targeted( t + round( eth ) );
						}

						keys.fire(true);
					}
				}
				else {
					// auf das eigentliche target zu schiessen ist aktuell nicht sinnvoll,
					// deshalb prfen wir ob es Sinn macht trotzdem zu schiessen
					if ( ! last_keys[(t - 1) % 20].isfire()
						&& (   ( abs( rotation_diff_degree ) > 2.4 && count_of_own_shots < 4 )
							|| ( abs( rotation_diff_degree ) <= 2.4 && count_of_own_shots < 3 )
							)
					   ) {
						bool shooted = false;
						for (int i=0; ( ! shooted && i<game.nasteroids) ; i++)
						{
							if ( ! alternativ_targets[i].is_cleared()
								 && alternativ_targets[i].total_distance < MAX_SCHUSSWEITE
								 && game.asteroids[alternativ_targets[i].asteroid_number].sf != 0
//								 && game.asteroids[alternativ_targets[i].asteroid_number].sf != 15
							   ) {
								delta_degree = game.delta_in_degree( alternativ_targets[i], &eth );
								rotation_diff_degree = diff_degree( calc_ship_degree, delta_degree );

								if ( abs( rotation_diff_degree ) < ( alternativ_targets[i].collision_window / PRAEZISION_SECONDARY )
								) {
									if ( alternativ_targets[i].is_asteroid() ) {
										game.asteroids[alternativ_targets[i].asteroid_number].mark_as_targeted( t + round( eth ) );
									}
									keys.fire(true);
									shooted = true;
								}
							}
						}
					}
				}

			}

			// Unabhngig davon mssen wir Schssen ausweichen
			if ( ! min_col_shots.is_cleared() ) {
#ifdef DEBUG
				cout << "min_col_shots: " << min_col_shots << endl;
#endif
				if ( min_col_shots.total_distance < 37
					 || ( min_col_shots.total_distance >= 37 && min_col_shots.collision_time < 4 ) ) {
					keys.hyperspace(true);
				}
			}

			if ( min_total_distance < 27 ) { //*27)  // Flucht, wenn Kollision unausweichlich
				keys.hyperspace(true);
			}

			if ( new_game_started ) {
				if ( !first_fire_started && first_degree_suggested && keys.isfire() ) {
					first_fire_started = true;
					time_of_first_fire = t;
				}

				if ( first_fire_started ) {
					keys.left(false);
					keys.right(false);
				}
			}

			// save keys for later use
			last_keys[t % 20] = keys;
		}
		else {
			last_keys[t % 20].clear();
		}	// end game.present

#ifdef DEBUG
		cout <<  keys;
#endif
	}	// end for
}

void Player::InterpretScreen(int t, FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	game.clear();
	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;

//			cout << "--- op " << op << " vs " << vs << " vx " << vx << " vy " << vy <<  endl;

			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set_current(t, vx, vy - BASE_Y, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set_current(t, vx, vy - BASE_Y, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set_current(t, vx, vy - BASE_Y, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set_current(t, vx, vy - BASE_Y, 4, vs);
				break;
			case 0x929:
				game.saucer_present = true;
				game.current_saucer_pos.set( t, vx, vy - BASE_Y);
				game.saucer_size = vs;
				break;
			}
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set_current(t, vx, vy - BASE_Y);

			if (    ! (dx == 0 && dy == 0 && vz == 15) // shot
				 && ! (dx == 0 && dy == 0 && vz == 0)  // ruhezeit
			   ) {
				int sf, vs_eff;

				vs_eff = vs;
				if ( vs_eff > 7 ) {
					vs_eff = vs_eff - 16;
				}

				sf = 1 << ( 9 - ( op + vs_eff ));
//				cout << "--- op " << op << " vs " << vs << " sf " << sf << " vz " << vz << " vx " << vx << " vy " << vy << " dx/sf " << ( dx / sf ) << " dy/sf " << ( dy / sf ) << " dx " << dx << " dy " << dy << endl;
			}

			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.current_ship_pos.set( t, vx, vy - BASE_Y);

					// sf=32 bei op=6 und vs=14
					game.current_ship_dir.dx = ( v1x - dx ) / 32;
					game.current_ship_dir.dy = ( v1y - dy ) / 32;
//				    cout << "--- ship dir " << " v1x " << v1x << " - dx " << dx << " v1y " << v1y << " - dy " << dy << " --> " << game.current_ship_dir << endl;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}

}

int round(double d)
{
	int	ret;

	if ( d > 0.0 ) {
		ret = (int) floor( d + 0.5 );
	}
	else if ( d < 0.0 ) {
		ret = (int) ceil( d - 0.5 );
	}
	else {
		ret = 0;
	}

	return ret;
}

double calc_collision_window( int distance, int radius )
{
	double ret = 0.0;

	ret = atan( abs( ((double) radius )) / abs( ((double) distance) ) ) * ( 180.0 / 3.14159265358979323846 );

	return ret;
}

// liefert die krzeste Entfernung zwischen zwei Gradzahlen ( a - b )
// die min/max Differenz liegt bei -/+ 180 Grad
double diff_degree( double a, double b )
{
	double ret;

	ret = a - b;
	if ( ret > 180 ) ret = ret - 360.0;
	if ( ret < -180 ) ret = ret + 360.0;

	return ret;
}

// Pauses for a specified number of milliseconds.
void sleep( clock_t wait )
{
   clock_t goal;
   goal = wait + clock();
   while( goal > clock() )
      ;
}

Distance::Distance()
{
	total_distance = 9876789;
	distance_per_time = 0.0;
	dx = 0.0;
	dy = 0.0;
	degree = 0.0;
	collision_window = 0.0;
	collision_time = 9876789;
	object_speed.clear();
	asteroid_number = -1;
}

Distance::Distance( int in_total_distance )
{
	total_distance = in_total_distance;
	distance_per_time = 0.0;
	dx = 0.0;
	dy = 0.0;
	degree = 0.0;
	collision_window = 0.0;
	collision_time = 9876789;
	object_speed.clear();
	asteroid_number = -1;
}

Distance::Distance(const Distance& a)
{
	total_distance = a.total_distance;
	distance_per_time = a.distance_per_time;
	dx = a.dx;
	dy = a.dy;
	degree = a.degree;
	object_speed = a.object_speed;
	asteroid_number = a.asteroid_number;

	collision_window = a.collision_window;
	collision_time = a.collision_time;
}

Distance& Distance::operator=(const Distance& a)
{
	total_distance = a.total_distance;
	distance_per_time = a.distance_per_time;
	dx = a.dx;
	dy = a.dy;
	degree = a.degree;
	object_speed = a.object_speed;
	asteroid_number = a.asteroid_number;

	collision_window = a.collision_window;
	collision_time = a.collision_time;

	return *this;
}

void Distance::set(int in_total_distance, Speed current_speed, double in_dx, double in_dy, int in_asteroid_number)
{
	int	 corrected_total_distance = in_total_distance;
	double in_distance_per_time = current_speed.getDistance();

	this->total_distance = in_total_distance;
	this->distance_per_time = in_distance_per_time;

	if ( 0 == round( in_distance_per_time ) ) {
		// ohne Bewegung dauert es ewig bis eine Collision eintritt
		this->collision_time = 9999;
	}
	else {
		// Korrektur um ship Umfang
		if ( corrected_total_distance > 13 ) {
			corrected_total_distance -= 13;
		}
		// Korrektur um min. Asteroidgrsse
		if ( corrected_total_distance > 10 ) {
			corrected_total_distance -= 10;
		}
		this->collision_time = round( ((double) corrected_total_distance) / in_distance_per_time );
	}

	this->dx = in_dx;
	this->dy = in_dy;

	this->object_speed = current_speed;
	this->asteroid_number = in_asteroid_number;
}

void Distance::set_collision_window(int radius)
{
	this->collision_window = calc_collision_window( total_distance, radius );
}

void Distance::clear(void)
{
	total_distance = 9876789;
	distance_per_time = 0.0;
	dx = 0.0;
	dy = 0.0;
	degree = 0.0;
	object_speed.clear();
	collision_window = 0.0;
	collision_time = 9876789;
	asteroid_number = -1;
}

bool Distance::is_cleared(void)
{
	return ( 9876789 == collision_time );
}

bool Distance::is_asteroid(void)
{
	return ( asteroid_number > -1 );
}

ostream& operator<<(ostream& s, const Distance& x)
{
	s << fixed << setprecision(6)
	  << " d " << x.total_distance
	  << " ( " << x.distance_per_time << " ) "
	  << " dx/dy " << x.dx << " / " << x.dy
	  << " ( " << x.degree << " ) "
	  << " col_wd " << x.collision_window << " col_time " << x.collision_time
	  << " speed " << x.object_speed
	  << " an " << x.asteroid_number;

	return s;
}

Direction::Direction()
{
	dx = 0;
	dy = 0;
}

Direction::Direction(const Direction& a)
{
	dx = a.dx;
	dy = a.dy;
}

Direction& Direction::operator=(const Direction& a)
{
	dx = a.dx;
	dy = a.dy;

	return *this;
}

void Direction::set(double dx, double dy)
{
	this->dx = dx;
	this->dy = dy;
}

void Direction::clear(void)
{
	dx = 0;
	dy = 0;
}

double Direction::getInDegree(void) const
{
	double degree = 0.0;

	if ( dx < 0.0 && dy == 0.0 ) {
		degree = 270.0;
	}
	else if ( dx > 0.0 && dy == 0.0 ) {
		degree = 90.0;
	}
	else if ( dx == 0.0 && dy < 0.0 ) {
		degree = 180.0;
	}
	else if ( dx == 0.0 && dy > 0.0 ) {
		degree = 0.0;
	}
	else {
		if ( dx > 0.0 && dy > 0.0 ) {
			degree = atan( abs(dx) / abs(dy) ) * ( 180.0 / 3.14159265358979323846 );
		}
		else if ( dx > 0.0 && dy < 0.0 ) {
			degree = atan( abs(dy) / abs(dx) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 90.0;
		}
		else if ( dx < 0.0 && dy < 0.0 ) {
			degree = atan( abs(dx) / abs(dy) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 180.0;
		}
		else if ( dx < 0.0 && dy > 0.0 ) {
			degree = atan( abs(dy) / abs(dx) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 270.0;
		}
	}
	return degree;
}

ostream& operator<<(ostream& s, const Direction& x)
{
	s << " d " << fixed << setprecision(6) << x.dx << " / " << x.dy
	  << " ( " << x.getInDegree() << " ) ";

	return s;
}

Speed::Speed()
{
	dx = 0;
	dy = 0;
}

Speed::Speed(double ix, double iy)
{
	dx = ix;
	dy = iy;
}

Speed::Speed(const Speed& a)
{
	dx = a.dx;
	dy = a.dy;
}

Speed& Speed::operator=(const Speed& a)
{
	dx = a.dx;
	dy = a.dy;

	return *this;
}

void Speed::set(double dx, double dy)
{
	this->dx = dx;
	this->dy = dy;
}

void Speed::clear(void)
{
	dx = 0;
	dy = 0;
}

double Speed::getDistance(void)
{
	double distance;

	if ( dx == 0 && dy == 0 ) {
		distance = 0.0;
	}
	else {
		distance = sqrt( (double) (dx*dx + dy*dy) );
	}
	return distance;
}

ostream& operator<<(ostream& s, const Speed& x)
{
	s << " s " << x.dx << " / " << x.dy;

	return s;
}

Position::Position()
{
	x = -1;
	y = -1;
	t = -1;
}

Position::Position(const Position& a)
{
	x = a.x;
	y = a.y;
	t = a.t;
}

Position& Position::operator=(const Position& a)
{
	this->x = a.x;
	this->y = a.y;
	this->t = a.t;

	return *this;
}

void Position::set(int t, int x, int y)
{
	this->t = t;
	this->x = x;
	this->y = y;
}

void Position::clear(void)
{
	t = -1;
	x = -1;
	y = -1;
}

bool Position::is_cleared(void)
{
	return ( -1 == t );
}

ostream& operator<<(ostream& s, const Position& x)
{
	s << x.x << " / " << x.y << " { " << x.t << " } ";

	return s;
}

int Position::distance( const Position& b )
{
	int	dx, dy;

	dx = ( this->x - b.x );
	while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
	while (dx > 511) dx -= 1024;

	dy = ( this->y - b.y );
	while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
	while (dy > 383) dy -= 768;

	return ((int) sqrt( (double) (dx*dx + dy*dy)));
}

double Position::degree( const Position& b )
{
	double	dx, dy;

	dx = ( this->x - b.x );
	while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
	while (dx > 511) dx -= 1024;

	dy = ( this->y - b.y );
	while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
	while (dy > 383) dy -= 768;

	double degree = 0.0;

	if ( dx == 0.0 && dy < 0.0 ) {
		degree = 0.0;
	}
	else if ( dx < 0.0 && dy == 0.0 ) {
		degree = 90.0;
	}
	else if ( dx == 0.0 && dy > 0.0 ) {
		degree = 180.0;
	}
	else if ( dx > 0.0 && dy == 0.0 ) {
		degree = 270.0;
	}
	else {
		if ( dx < 0.0 && dy < 0.0 ) {
			degree = atan( abs(dx) / abs(dy) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 0.0;
		}
		else if ( dx > 0.0 && dy > 0.0 ) {
			degree = atan( abs(dx) / abs(dy) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 180.0;
		}
		else if ( dx < 0.0 && dy > 0.0 ) {
			degree = atan( abs(dy) / abs(dx) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 90.0;
		}
		else if ( dx > 0.0 && dy < 0.0 ) {
			degree = atan( abs(dy) / abs(dx) ) * ( 180.0 / 3.14159265358979323846 );

			degree = degree + 270.0;
		}
	}
	return degree;
}

Speed operator-( const Position& a, const Position& b)
{
	int	dx, dy, dt;

	dt = a.t - b.t;
	if ( dt == 0 ) dt = 1;

	dx = ( a.x - b.x ) / dt ;
	while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
	while (dx > 511) dx -= 1024;

	dy = ( a.y - b.y ) / dt ;
	while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
	while (dy > 383) dy -= 768;

	return Speed(dx, dy);
}

Asteroid::Asteroid()
{
	recalc_possible = true;
	targeted = false;
	targeted_count = 0;
	current_pos.clear();
	type = -1;
	sf = -1;
	current_dir.clear();
	current_speed.clear();

	start_pos.clear();
	last_pos.clear();
}

Asteroid::Asteroid(const Asteroid& a)
{
	recalc_possible = a.recalc_possible;
	targeted = a.targeted;
	targeted_expected_time_to_hit = a.targeted_expected_time_to_hit;
	targeted_count = a.targeted_count;

	current_pos = a.current_pos;
	type = a.type;
	sf = a.sf;
	current_dir = a.current_dir;
	current_speed = a.current_speed;

	start_pos = a.start_pos;
	last_pos = a.last_pos;
}

Asteroid& Asteroid::operator=(const Asteroid& a)
{
	recalc_possible = a.recalc_possible;
	targeted_count = a.targeted_count;
	targeted = a.targeted;
	targeted_expected_time_to_hit = a.targeted_expected_time_to_hit;

	current_pos = a.current_pos;
	type = a.type;
	sf = a.sf;
	current_dir = a.current_dir;
	current_speed = a.current_speed;

	start_pos = a.start_pos;
	last_pos = a.last_pos;

	return *this;
}

void Asteroid::set_current(int t, int x, int y, int type, int sf)
{
	this->current_pos.set( t, x, y );
	this->type = type;
	this->sf = sf;

	this->current_dir.clear();
	this->current_speed.clear();
	this->last_pos.clear();
	this->start_pos.clear();
	this->recalc_possible = true;
	this->targeted_count=0;
	this->targeted = false;
	this->targeted_expected_time_to_hit = 0;
}

void Asteroid::recalc(void)
{
	Speed	actual_speed;
	int		new_x, new_y;

	actual_speed = current_pos - last_pos;

	if ( recalc_possible ) {
		if ( ! start_pos.is_cleared() ) {
			new_x = current_pos.x - start_pos.x;
			while (new_x < -512) new_x += 1024; // dx normalisieren auf -512 ... 511
			while (new_x > 511) new_x -= 1024;

			new_y = current_pos.y - start_pos.y;
			while (new_y < -384) new_y += 768;  // dy normalisieren auf -384 ... 383
			while (new_y > 383) new_y -= 768;

			if ( (current_pos.t - start_pos.t) < 40 ) {
				double	new_dx;
				double	new_dy;

				new_dx = ((double) ( new_x  )) / ((double) ( current_pos.t - start_pos.t ));
				new_dy = ((double) ( new_y )) / ((double) ( current_pos.t - start_pos.t ));

				current_speed.dx = new_dx;
				current_speed.dy = new_dy;
			}
			else {
				recalc_possible = false;
			}
		}
		else {
			current_speed = actual_speed;
		}
	}

	current_dir.set( 4 * current_speed.dx, 4 * current_speed.dy );
}

bool Asteroid::is_targeted( int current_t ) {
	bool ret = false;

	if ( current_t < targeted_expected_time_to_hit ) {
		ret = this->targeted;
	}

	return ret;
}

void Asteroid::mark_as_targeted( int current_t ) {
	this->targeted_count++;
	this->targeted = true;
	this->targeted_expected_time_to_hit = current_t;
}

ostream& operator<<(ostream& s, const Asteroid& x)
{
	if ( x.targeted ) {
		s << " t (" << x.targeted_expected_time_to_hit << ") ";
	}
	else {
		s << " n ";
	}

	s << " type: " << x.type << " sf: " << x.sf
		<< " at " << x.current_pos;

	if ( x.recalc_possible ) {
		s << " + ";
	}
	else {
		s << " - ";
	}

	s << x.current_dir
	  << x.current_speed
//	  << " last " << x.last_pos
//	  << " start " << x.start_pos
	  ;

	return s;
}

Position Asteroid::get_next_pos( int t ) {
	Position next_pos = current_pos;

	next_pos.x = next_pos.x + round( current_speed.dx * t );
	while (next_pos.x < -512) next_pos.x += 1024; // dx normalisieren auf -512 ... 511
	while (next_pos.x > 511) next_pos.x -= 1024;

	next_pos.y = next_pos.y + round( current_speed.dy * t );
	while (next_pos.y < -384) next_pos.y += 768;  // dy normalisieren auf -384 ... 383
	while (next_pos.y > 383) next_pos.y -= 768;

	return( next_pos );
}

Shot::Shot()
{
	recalc_possible = true;
	own_shot = false;
	current_pos.clear();
	current_dir.clear();
	current_speed.clear();
	start_pos.clear();
	last_pos.clear();
}

Shot::Shot(const Shot& a)
{
	recalc_possible = a.recalc_possible;
	own_shot = a.own_shot;
	current_pos = a.current_pos;
	start_pos = a.start_pos;
	last_pos = a.last_pos;
	current_dir = a.current_dir;
	current_speed = a.current_speed;
}

Shot& Shot::operator=(const Shot& a)
{
	recalc_possible = a.recalc_possible;
	own_shot = a.own_shot;
	current_pos = a.current_pos;
	start_pos = a.start_pos;
	last_pos = a.last_pos;
	current_dir = a.current_dir;
	current_speed = a.current_speed;

	return *this;
}

void Shot::set_current(int t, int x, int y)
{
	current_pos.set(t, x, y);

	this->current_dir.clear();
	this->current_speed.clear();
	this->last_pos.clear();
	this->start_pos.clear();
	this->recalc_possible = true;
	this->own_shot = false;
}

void Shot::recalc(void)
{
	Speed	actual_speed;

	actual_speed = current_pos - last_pos;

	if ( recalc_possible ) {
		if ( ! start_pos.is_cleared() ) {
			if ( abs( current_pos.x - start_pos.x  ) < 512
				&& abs( current_pos.y - start_pos.y ) < 384 ) {
					double	new_dx;
					double	new_dy;

					new_dx = ((double) ( current_pos.x - start_pos.x  )) / ((double) ( current_pos.t - start_pos.t ));
					new_dy = ((double) ( current_pos.y - start_pos.y )) / ((double) ( current_pos.t - start_pos.t ));

					current_speed.dx = new_dx;
					current_speed.dy = new_dy;
			}
			else {
				recalc_possible = false;
			}
		}
		else {
			current_speed = actual_speed;
		}
	}

	current_dir.set( 4 * current_speed.dx, 4 * current_speed.dy );
}

ostream& operator<<(ostream& s, const Shot& x)
{
	char boolstr;

	if ( x.recalc_possible ) {
		boolstr = '+';
	}
	else {
		boolstr = '-';
	}

	s << x.current_pos;

	if ( x.own_shot ) {
		s << "(own)";
	}

	s << " " << boolstr << " "
	  << x.current_dir
	  << x.current_speed
//	  << " last " << x.last_pos
//	  << " start " << x.start_pos
		;

	return s;
}

Position Shot::get_next_pos( int t ) {
	Position next_pos = current_pos;

	next_pos.x = next_pos.x + round( current_speed.dx * t );
	while (next_pos.x < -512) next_pos.x += 1024; // dx normalisieren auf -512 ... 511
	while (next_pos.x > 511) next_pos.x -= 1024;

	next_pos.y = next_pos.y + round( current_speed.dy * t );
	while (next_pos.y < -384) next_pos.y += 768;  // dy normalisieren auf -384 ... 383
	while (next_pos.y > 383) next_pos.y -= 768;

	return( next_pos );
}

GameStatus::GameStatus()
{
	ship_present = false;
	current_ship_pos.clear();
	current_ship_dir.clear();
	current_ship_speed.clear();
	last_ship_pos.clear();
	start_ship_pos.clear();

	saucer_present = false;
	saucer_targeted = false;
	current_saucer_pos.clear();
	last_saucer_pos.clear();
	start_saucer_pos.clear();

	nasteroids = 0;
	nshots = 0;
}

GameStatus::GameStatus(const GameStatus& x)
{
	ship_present = x.ship_present;
	current_ship_pos = x.current_ship_pos;

	current_ship_dir = x.current_ship_dir;
	ship_shot_pos = x.ship_shot_pos;

	last_ship_pos = x.last_ship_pos;
	start_ship_pos = x.start_ship_pos;

	saucer_present = x.saucer_present;
	current_saucer_pos = x.current_saucer_pos;
	saucer_size = x.saucer_size;
	last_saucer_pos = x.last_saucer_pos;
	start_saucer_pos = x.start_saucer_pos;

	nasteroids = x.nasteroids;
	for ( int i=0; i<nasteroids; i++ ) {
		asteroids[i] = x.asteroids[i];
	}

	nshots = x.nshots;
	for ( int i=0; i<nshots; i++ ) {
		shots[i] = x.shots[i];
	}
}

GameStatus& GameStatus::operator=(const GameStatus& x)
{
	ship_present = x.ship_present;
	current_ship_pos = x.current_ship_pos;
	current_ship_dir = x.current_ship_dir;
	ship_shot_pos = x.ship_shot_pos;
	last_ship_pos = x.last_ship_pos;
	start_ship_pos = x.start_ship_pos;

	saucer_present = x.saucer_present;
	current_saucer_pos = x.current_saucer_pos;
	saucer_size = x.saucer_size;
	last_saucer_pos = x.last_saucer_pos;
	start_saucer_pos = x.start_saucer_pos;

	nasteroids = x.nasteroids;
	for ( int i=0; i<nasteroids; i++ ) {
		asteroids[i] = x.asteroids[i];
	}

	nshots = x.nshots;
	for ( int i=0; i<nshots; i++ ) {
		shots[i] = x.shots[i];
	}

	return *this;
}

bool GameStatus::saucer_is_targeted( int current_t ) {
	bool ret = false;

	if ( current_t < saucer_targeted_etot ) {
		ret = this->saucer_targeted;
	}

	return ret;
}

void GameStatus::mark_saucer_as_targeted( int current_t ) {
	saucer_targeted = true;
	saucer_targeted_etot = current_t;
}

ostream& operator<<(ostream& s, const GameStatus& x)
{
	if ( x.ship_present ) {
		s << "ship at " << x.current_ship_pos
		  << x.current_ship_dir
		  << " shotPos " << x.ship_shot_pos << ":" << shot_direction[x.ship_shot_pos] << " "
		  << x.current_ship_speed
//		  << " last " << x.last_ship_pos
//		  << " start " << x.start_ship_pos
		  << endl;
	}
	else {
		s << "no ship" << endl;
	}

	if ( x.saucer_present ) {
		s << "saucer ";

		s << "( " << x.saucer_size << " )";

		if ( x.saucer_targeted ) {
			s << " t (" << x.saucer_targeted_etot << ") ";
		}
		else {
			s << " n ";
		}

		s << " at " << x.current_saucer_pos
		  << x.current_saucer_dir
		  << x.current_saucer_speed
//		  << " last " << x.last_saucer_pos
//		  << " start " << x.start_saucer_pos
		  << endl;
	}
	else {
		s << "no saucer" << endl;
	}

	if ( x.nasteroids > 0 ) {
		s << "asteroids:" << endl;
		for ( int i=0; i<x.nasteroids; i++ ) {
			s << "[ " << i << " ]"
			  << x.asteroids[i]
		      << endl;
		}
	}
	else {
		s << "no asteroids" << endl;
	}

	if ( x.nshots > 0 ) {
		s << "shots:" << endl;
		for ( int i=0; i<x.nshots; i++ ) {
			s << "[ " << i << " ]"
			  << " at " << x.shots[i]
		      << endl;
		}
	}
	else {
		s << "no shots" << endl;
	}

	return s;
}

void GameStatus::clear(void)
{
	if ( ship_present ) {
		last_ship_pos = current_ship_pos;

		if ( start_ship_pos.is_cleared() ) {
			start_ship_pos = current_ship_pos;
		}
	}
	ship_present = false;
	current_ship_pos.clear();
	current_ship_dir.clear();
	current_ship_speed.clear();

	if ( saucer_present ) {
		last_saucer_pos = current_saucer_pos;

		if ( start_saucer_pos.is_cleared() ) {
			start_saucer_pos = current_saucer_pos;
		}
	}
	saucer_present = false;
	current_saucer_pos.clear();
	current_saucer_dir.clear();
	current_saucer_speed.clear();

	nasteroids = 0;
	nshots = 0;
}

double GameStatus::delta_in_degree( Distance target_distance, double *ret_eth )
{
	// die Angaben dx/dy sind relativ zur Positions des ship
	double		ret;
	double		tdx0, tdy0, d0, eth0;
	double		tdx1, tdy1, d1, eth1;
	Direction	d;
	bool		fertig = false;

	tdx0 = round( target_distance.dx );
	tdy0 = round( target_distance.dy );

	// bevor unser Schu losfliegt sind schon 1 t vergangen
	tdx0 = tdx0 + target_distance.object_speed.dx;
	while (tdx0 < -512) tdx0 += 1024;
	while (tdx0 > 511) tdx0 -= 1024;
	tdy0 = tdy0 + target_distance.object_speed.dy;
	while (tdy0 < -384) tdy0 += 768;
	while (tdy0 > 383) tdy0 -= 768;

	// bevor unser Schu losfliegt sind noch 1 t vergangen
	tdx0 = tdx0 + target_distance.object_speed.dx;
	while (tdx0 < -512) tdx0 += 1024;
	while (tdx0 > 511) tdx0 -= 1024;
	tdy0 = tdy0 + target_distance.object_speed.dy;
	while (tdy0 < -384) tdy0 += 768;
	while (tdy0 > 383) tdy0 -= 768;

	// daraus resultiert eine neue Distanz zum Objekt
	d0 = sqrt( tdx0 * tdx0 + tdy0 * tdy0 );
	eth0 = ( d0 / SHOT_SPEED );
	d.set( tdx0, tdy0 );
	ret = d.getInDegree();
//	cout << "** korr um t1 d " << d0 << " eth0 " << eth0 << " dx/dy " << tdx0 << "/" << tdy0 << " Grad " << ret << endl;

	while ( ! fertig )
	{
		// whrend dieser zeit hat sich aber das target auch weiterbewegt
		tdx1 = tdx0 + (target_distance.object_speed.dx * eth0);
		while (tdx1 < -512) tdx1 += 1024;
		while (tdx1 > 511) tdx1 -= 1024;

		tdy1 = tdy0 + (target_distance.object_speed.dy * eth0);
		while (tdy1 < -384) tdy1 += 768;
		while (tdy1 > 383) tdy1 -= 768;

		// ... und daraus ergibt sich eine Objektdistanz
		d1 = sqrt( tdx1 * tdx1 + tdy1 * tdy1 );
		eth1 = ( d1 / SHOT_SPEED );
		d.set( tdx1, tdy1 );
		ret = d.getInDegree();
//		cout << "** -->        d " << d1 << " eth1 " << eth1 << " dx/dy " << tdx1 << "/" << tdy1 << " Grad " << ret << endl;

		// Ziel ist das sich eth0 und eth1 nicht unterscheiden
		if ( abs( eth0 - eth1 ) < 0.25 ) {
			fertig = true;
		}
		else {
			eth0 = ( eth0 + eth1 ) / 2.0;
//			cout << "** -->        test         eth0 " << eth0 << endl;
		}
	}

	// whrend dieser zeit hat sich aber das target auch weiterbewegt
	tdx1 = tdx0 + (target_distance.object_speed.dx * eth0);
	while (tdx1 < -512) tdx1 += 1024;
	while (tdx1 > 511) tdx1 -= 1024;

	tdy1 = tdy0 + (target_distance.object_speed.dy * eth0);
	while (tdy1 < -384) tdy1 += 768;
	while (tdy1 > 383) tdy1 -= 768;

	// ... und daraus ergibt sich eine neue Distanz
	d1 = sqrt( tdy1 * tdy1 + tdx1 * tdx1 );

	d.set( tdx1, tdy1 );
	ret = d.getInDegree();
//	cout << "** --> result d " << d1 << " eth0 " << eth0 << " dx/dy " << tdx1 << "/" << tdy1 << " Grad " << ret << endl;

	*ret_eth = eth1;

	return ret;
}

IntroPacket::IntroPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'n';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	signature[6] = 'o';
	signature[7] = 'l';
	signature[8] = 'e';
	signature[9] = ' ';
	signature[10] = 't';
	signature[11] = 'h';
	signature[12] = 'e';
	signature[13] = ' ';
	signature[14] = 's';
	signature[15] = 'h';
	signature[16] = 'o';
	signature[17] = 'o';
	signature[18] = 't';
	signature[19] = 'i';
	signature[20] = 's';
	signature[21] = 't';
	signature[22] = 0;
	signature[23] = 0;
	signature[24] = 0;
	signature[25] = 0;
	signature[26] = 0;
	signature[27] = 0;
	signature[28] = 0;
	signature[29] = 0;
	signature[30] = 0;
	signature[31] = 0;
	signature[32] = 0;
	signature[33] = 0;
	signature[34] = 0;
	signature[35] = 0;
	signature[36] = 0;
	signature[37] = 0;
}


KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

KeysPacket::KeysPacket(const KeysPacket& x)
{
	keys = x.keys;
	ping = x.ping;
}

KeysPacket& KeysPacket::operator=(const KeysPacket& x)
{
	keys = x.keys;
	ping = x.ping;

	return *this;
}

ostream& operator<<( ostream& s, KeysPacket& x)
{
	s << "keys: ";
	if ( x.isleft() ) {
		s << "left ";
	}

	if ( x.isright() ) {
		s << "right ";
	}

	if ( x.isfire() ) {
		s << "fire ";
	}

	if ( x.isthrust() ) {
		s << "thrust ";
	}

	if ( x.ishyperspace() ) {
		s << "hyperspace ";
	}

	s << endl;

	return s;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

bool KeysPacket::ishyperspace(void)
{
	return ( KEY_HYPERSPACE == ( keys & KEY_HYPERSPACE ) );
}

bool KeysPacket::isfire(void)
{
	return ( KEY_FIRE == ( keys & KEY_FIRE ) );
}

bool KeysPacket::isthrust(void)
{
	return ( KEY_THRUST == ( keys & KEY_THRUST ) );
}

bool KeysPacket::isright(void)
{
	return ( KEY_RIGHT == ( keys & KEY_RIGHT ) );
}

bool KeysPacket::isleft(void)
{
	return ( KEY_LEFT == ( keys & KEY_LEFT ) );
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}

void Player::SendPlayerName()
{
	static char player_name[38] = "ctnamevictim of lag\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (38 != sendto(sd, player_name, 38, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}
