#include "mainwindow.h"

#include "mameview.h"
#include "socket.h"
#include "config.h"

MainWindow::MainWindow():
	QMainWindow()
{
	ai->setMainWindow(this);

	mameView = new MameView(this);
	setCentralWidget(mameView);
	mameScene = ai->getMameScene();

	socket = new Socket(ai->getAddress() ,this);


	createActions();
	createMenus();
	createToolBars();
	createDockWidgets();

	setWindowTitle("AI Test GUI");

	

}

MainWindow::~MainWindow()
{
}


void MainWindow::createActions()
{
	actions.start = new QAction("Start",this);
	connect(actions.start, SIGNAL(triggered()), socket, SLOT(initialSend()));
	actions.exit = new QAction("Exit",this);
	connect(actions.exit, SIGNAL(triggered()), this, SLOT(close()));
}

void MainWindow::createMenus()
{
	menus.fileMenu = menuBar()->addMenu("File");
	menus.fileMenu->addAction(actions.start);
	menus.fileMenu->addAction(actions.exit);

	menus.viewMenu = menuBar()->addMenu("View");
}

void MainWindow::createToolBars()
{
	toolBars.fileToolBar = addToolBar("File");
	toolBars.fileToolBar->addAction(actions.start);
}

void MainWindow::createDockWidgets()
{
	QDockWidget *messageDock = new QDockWidget("Debug Messages", this);
	messageDock->setAllowedAreas(Qt::TopDockWidgetArea | Qt::BottomDockWidgetArea);
	dockWidgets.messanger = new Messanger(messageDock);
	messageDock->setWidget(dockWidgets.messanger);
	addDockWidget(Qt::BottomDockWidgetArea, messageDock);
	menus.viewMenu->addAction(messageDock->toggleViewAction());

	/*QDockWidget *configDock = new QDockWidget("Configuration", this);
	configDock->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea);
	dockWidgets.config = new Config(configDock);
	configDock->setWidget(dockWidgets.config);
	addDockWidget(Qt::RightDockWidgetArea, configDock);
	menus.viewMenu->addAction(configDock->toggleViewAction());*/
}

void MainWindow::start()
{
}


void MainWindow::exit()
{
}