#include "aicore.h"

#include "framedata.h"
#include "mainwindow.h"
#include "mamescene.h"
#include "job.h"

AICore *ai;


int Options::SpeedSamples = 20; 
int Options::Angle = 0;
Radius Options::R = Radius();
//mre
SpeedDef Options::Def = SpeedDef();
bool Options::ShowCross = false;
bool Options::PrintInfo = false;

AICore::AICore(int &argc, char **argv ):
	QApplication(argc, argv),job(0)
{
	ai = this;

	if (argc != 2)
	{
		
		address = "127.0.0.1";
		qDebug()<< "No address given - using 127.0.0.1";
	}
	else
	{
		address = QString(argv[1]);
		qDebug()<<"Using " << address;
	}

	QList<QPair<int, double> > anglePairList;

	currentFrame = new FrameData;
	lastFrame = new FrameData;
	actionPacket = "ctmame@0";

	anglePairList	<< QPair<int, double>(0, 0.0)
					<< QPair<int, double>(0, 3.6)
					<< QPair<int, double>(5, 8.2)
					<< QPair<int, double>(11, 12.7)
					<< QPair<int, double>(16, 16.5)
					<< QPair<int, double>(16, 21.2)
					<< QPair<int, double>(22, 25.2)
					<< QPair<int, double>(27, 29.5)
					<< QPair<int, double>(33, 33.5)
					<< QPair<int, double>(33, 37.8)
					<< QPair<int, double>(39, 41.7)
					<< QPair<int, double>(44, 46.2) //45
					<< QPair<int, double>(50, 50.8)
					<< QPair<int, double>(50, 55.3)
					<< QPair<int, double>(56, 59.4)
					<< QPair<int, double>(62, 63.4)
					<< QPair<int, double>(67, 67.5)
					<< QPair<int, double>(67, 71.6)
					<< QPair<int, double>(73, 76.1)
					<< QPair<int, double>(78, 79.9)
					<< QPair<int, double>(84, 84.5)
					<< QPair<int, double>(84, 89.1)
					<< QPair<int, double>(95, 92.8)
					<< QPair<int, double>(101, 97.2)
					<< QPair<int, double>(101, 101.8)
					<< QPair<int, double>(106, 105.5)
					<< QPair<int, double>(112, 110.2)
					<< QPair<int, double>(117, 114.1)
					<< QPair<int, double>(117, 118.1)
					<< QPair<int, double>(123, 122.8)
					<< QPair<int, double>(129, 126.7)
					<< QPair<int, double>(134, 131.1) //135
					<< QPair<int, double>(134, 135.0) //135
					<< QPair<int, double>(140, 139.4)
					<< QPair<int, double>(146, 143.3)
					<< QPair<int, double>(152, 147.9)
					<< QPair<int, double>(152, 151.9)
					<< QPair<int, double>(157, 156.6)
					<< QPair<int, double>(163, 160.7)
					<< QPair<int, double>(168, 164.5)
					<< QPair<int, double>(168, 169.2)
					<< QPair<int, double>(174, 172.8)
					<< QPair<int, double>(179, 177.3)//180
					<< QPair<int, double>(179, 181.9)//180
					<< QPair<int, double>(185, 185.5)
					<< QPair<int, double>(185, 189.9)
					<< QPair<int, double>(191, 194.5)
					<< QPair<int, double>(196, 198.2)
					<< QPair<int, double>(202, 203.0)
					<< QPair<int, double>(202, 206.9)
					<< QPair<int, double>(207, 211.0)
					<< QPair<int, double>(213, 215.4)
					<< QPair<int, double>(219, 220.0)
					<< QPair<int, double>(219, 223.8)
					<< QPair<int, double>(225, 227.5)
					<< QPair<int, double>(230, 232.2)
					<< QPair<int, double>(236, 235.9)
					<< QPair<int, double>(236, 240.3)
					<< QPair<int, double>(242, 245.1)
					<< QPair<int, double>(247, 248.8)
					<< QPair<int, double>(253, 252.7)
					<< QPair<int, double>(253, 257.3)
					<< QPair<int, double>(258, 261.1)
					<< QPair<int, double>(264, 265.6)
					<< QPair<int, double>(270, 270.0)
					<< QPair<int, double>(275, 273.6)
					<< QPair<int, double>(281, 278.2)
					<< QPair<int, double>(286, 282.7)
					<< QPair<int, double>(286, 286.5)
					<< QPair<int, double>(292, 291.2)
					<< QPair<int, double>(297, 295.0)
					<< QPair<int, double>(303, 299.0)
					<< QPair<int, double>(303, 303.5)
					<< QPair<int, double>(309, 307.8)
					<< QPair<int, double>(315, 311.7)
					<< QPair<int, double>(320, 316.2)
					<< QPair<int, double>(320, 320.0)
					<< QPair<int, double>(326, 324.5)
					<< QPair<int, double>(332, 328.6)
					<< QPair<int, double>(337, 332.7)
					<< QPair<int, double>(337, 336.6)
					<< QPair<int, double>(343, 341.6)
					<< QPair<int, double>(348, 345.3)
					<< QPair<int, double>(354, 349.9)
					<< QPair<int, double>(354, 354.5)
					<< QPair<int, double>(0, 358.1)
					<< QPair<int, double>(0, 2.8)
					<< QPair<int, double>(5, 7.2)
					<< QPair<int, double>(11, 11.0)
					<< QPair<int, double>(11, 15.5)
					<< QPair<int, double>(16, 19.3)
					<< QPair<int, double>(22, 23.4)
					<< QPair<int, double>(27, 28.1)
					<< QPair<int, double>(27, 32.8)
					<< QPair<int, double>(33, 36.7)
					<< QPair<int, double>(39, 40.6)
					<< QPair<int, double>(44, 45.0) //45
					<< QPair<int, double>(44, 49.4) //45
					<< QPair<int, double>(50, 53.3)
					<< QPair<int, double>(56, 57.2)
					<< QPair<int, double>(62, 61.9)
					<< QPair<int, double>(62, 66.6)
					<< QPair<int, double>(67, 70.7)
					<< QPair<int, double>(73, 74.5)
					<< QPair<int, double>(78, 79.0)
					<< QPair<int, double>(78, 82.8)
					<< QPair<int, double>(84, 87.2)
					<< QPair<int, double>(95, 91.9)
					<< QPair<int, double>(95, 95.5)
					<< QPair<int, double>(101, 100.1)
					<< QPair<int, double>(106, 104.7)
					<< QPair<int, double>(112, 108.4)
					<< QPair<int, double>(112, 113.4)
					<< QPair<int, double>(117, 117.3)
					<< QPair<int, double>(123, 121.4)
					<< QPair<int, double>(129, 125.6)
					<< QPair<int, double>(129, 130.0)
					<< QPair<int, double>(134, 133.8) //135
					<< QPair<int, double>(140, 138.3)
					<< QPair<int, double>(146, 142.2)
					<< QPair<int, double>(146, 146.5)
					<< QPair<int, double>(152, 151.0)
					<< QPair<int, double>(157, 155.0)
					<< QPair<int, double>(163, 158.8)
					<< QPair<int, double>(163, 163.6)
					<< QPair<int, double>(168, 167.3)
					<< QPair<int, double>(174, 171.8)
					<< QPair<int, double>(179, 176.6) //180
					<< QPair<int, double>(179, 180.0) //180
					<< QPair<int, double>(179, 184.4) //180
					<< QPair<int, double>(185, 188.9) 
					<< QPair<int, double>(191, 192.7)
					<< QPair<int, double>(196, 197.3)
					<< QPair<int, double>(196, 201.2)
					<< QPair<int, double>(202, 205.5)
					<< QPair<int, double>(207, 209.7)
					<< QPair<int, double>(213, 214.2)
					<< QPair<int, double>(213, 217.8)
					<< QPair<int, double>(219, 222.5)
					<< QPair<int, double>(225, 226.2)
					<< QPair<int, double>(230, 230.0)
					<< QPair<int, double>(230, 234.6)
					<< QPair<int, double>(236, 239.0)
					<< QPair<int, double>(242, 243.1)
					<< QPair<int, double>(247, 247.0)
					<< QPair<int, double>(247, 251.8)
					<< QPair<int, double>(253, 255.5)
					<< QPair<int, double>(258, 260.1)
					<< QPair<int, double>(264, 264.5)
					<< QPair<int, double>(264, 268.1)
					<< QPair<int, double>(275, 272.7)
					<< QPair<int, double>(281, 277.2)
					<< QPair<int, double>(281, 280.8)
					<< QPair<int, double>(286, 285.5)
					<< QPair<int, double>(292, 289.3)
					<< QPair<int, double>(297, 293.4)
					<< QPair<int, double>(297, 298.1)
					<< QPair<int, double>(303, 302.2)
					<< QPair<int, double>(309, 306.7)
					<< QPair<int, double>(315, 310.6)
					<< QPair<int, double>(315, 315.0)
					<< QPair<int, double>(320, 318.9)
					<< QPair<int, double>(326, 323.3)
					<< QPair<int, double>(332, 327.2)
					<< QPair<int, double>(332, 331.9)
					<< QPair<int, double>(337, 335.9)
					<< QPair<int, double>(343, 339.8)
					<< QPair<int, double>(348, 344.5)
					<< QPair<int, double>(348, 348.2)
					<< QPair<int, double>(354, 352.8)
					<< QPair<int, double>(0, 357.2)
					<< QPair<int, double>(0, 0.9)
					<< QPair<int, double>(5, 5.5)
					<< QPair<int, double>(5, 10.1)
					<< QPair<int, double>(11, 13.9)
					<< QPair<int, double>(16, 18.4)
					<< QPair<int, double>(22, 22.5)
					<< QPair<int, double>(22, 26.6)
					<< QPair<int, double>(27, 30.6)
					<< QPair<int, double>(33, 34.7)
					<< QPair<int, double>(39, 39.2)
					<< QPair<int, double>(39, 43.8)
					<< QPair<int, double>(44, 48.3) // 45
					<< QPair<int, double>(50, 52.2)
					<< QPair<int, double>(56, 56.5)
					<< QPair<int, double>(56, 60.5)
					<< QPair<int, double>(62, 64.7)
					<< QPair<int, double>(67, 68.8)
					<< QPair<int, double>(73, 73.5)
					<< QPair<int, double>(73, 77.3)
					<< QPair<int, double>(78, 81.8)
					<< QPair<int, double>(84, 86.4)
					<< QPair<int, double>(89, 90.0) // 90
					<< QPair<int, double>(95, 94.5)
					<< QPair<int, double>(101, 98.9)
					<< QPair<int, double>(106, 102.7)
					<< QPair<int, double>(106, 107.3)
					<< QPair<int, double>(112, 111.2)
					<< QPair<int, double>(117, 115.3)
					<< QPair<int, double>(123, 120.2)
					<< QPair<int, double>(123, 124.2)
					<< QPair<int, double>(129, 127.8)
					<< QPair<int, double>(134, 132.5) //134
					<< QPair<int, double>(140, 136.1)
					<< QPair<int, double>(140, 140.8)
					<< QPair<int, double>(146, 145.3)
					<< QPair<int, double>(152, 149.8)
					<< QPair<int, double>(157, 153.9)
					<< QPair<int, double>(157, 157.9)
					<< QPair<int, double>(163, 161.8)
					<< QPair<int, double>(168, 166.3)
					<< QPair<int, double>(174, 170.1)
					<< QPair<int, double>(174, 174.3)
					<< QPair<int, double>(179, 179.1) //179
					<< QPair<int, double>(179, 182.9) //179
					<< QPair<int, double>(185, 187.2)
					<< QPair<int, double>(191, 191.5)
					<< QPair<int, double>(191, 195.6)
					<< QPair<int, double>(196, 200.3)
					<< QPair<int, double>(202, 204.1)
					<< QPair<int, double>(207, 208.1)
					<< QPair<int, double>(207, 212.1)
					<< QPair<int, double>(213, 216.6)
					<< QPair<int, double>(219, 221.0)
					<< QPair<int, double>(225, 225.0)
					<< QPair<int, double>(225, 228.9)
					<< QPair<int, double>(230, 233.3)
					<< QPair<int, double>(236, 237.8)
					<< QPair<int, double>(242, 241.9)
					<< QPair<int, double>(242, 245.9)
					<< QPair<int, double>(247, 249.8)
					<< QPair<int, double>(253, 254.5)
					<< QPair<int, double>(258, 258.4)
					<< QPair<int, double>(258, 262.8)
					<< QPair<int, double>(264, 267.3)
					<< QPair<int, double>(275, 270.9)
					<< QPair<int, double>(275, 275.5)
					<< QPair<int, double>(281, 279.9)
					<< QPair<int, double>(286, 283.7)
					<< QPair<int, double>(292, 288.2)
					<< QPair<int, double>(292, 292.1)
					<< QPair<int, double>(297, 296.1)
					<< QPair<int, double>(303, 300.2)
					<< QPair<int, double>(309, 304.7)
					<< QPair<int, double>(309, 309.2)
					<< QPair<int, double>(315, 313.8)
					<< QPair<int, double>(320, 317.5)
					<< QPair<int, double>(326, 322.2)
					<< QPair<int, double>(326, 325.8)
					<< QPair<int, double>(332, 329.8)
					<< QPair<int, double>(337, 334.7)
					<< QPair<int, double>(343, 338.8)
					<< QPair<int, double>(343, 342.7)
					<< QPair<int, double>(348, 347.2)
					<< QPair<int, double>(354, 351.1)
					<< QPair<int, double>(0, 355.5);

	for(int i=0; i<anglePairList.size(); i++)
	{
		indexLookup.insertMulti((unsigned char)i, anglePairList[i]);
		angleLookup.insertMulti(anglePairList[i].first, (unsigned char)i); 
	}




}

AICore::~AICore()
{
	delete currentFrame;
	delete lastFrame;
}


QString AICore::getAddress()
{
	return address;
}

void AICore::clearActions()
{
	actionPacket[6] = '@';
}
		

void AICore::actionHyperspace(bool b)
{
	if (b)
	{
		actionPacket.data()[6] |= ACTION_HYPERSPACE;
	}
	else
	{
		actionPacket.data()[6] &= ~ACTION_HYPERSPACE;
	}
}

void AICore::actionFire(bool b)
{
	if (b)
	{
		actionPacket.data()[6] |= ACTION_FIRE;
	}
	else
	{
		actionPacket.data()[6] &= ~ACTION_FIRE;
	}
}

void AICore::actionThrust(bool b)
{
	if (b)
	{
		actionPacket.data()[6] |= ACTION_THRUST;
	}
	else
	{
		actionPacket.data()[6] &= ~ACTION_THRUST;
	}
}

void AICore::actionRight(bool b)
{
	if (b)
	{
		actionPacket.data()[6] |= ACTION_RIGHT;
		actionLeft(false);
	}
	else
	{
		actionPacket.data()[6] &= ~ACTION_RIGHT;
	}
}

void AICore::actionLeft(bool b)
{
	if (b)
	{
		actionPacket.data()[6] |= ACTION_LEFT;
		actionRight(false);
	}
	else
	{
		actionPacket.data()[6] &= ~ACTION_LEFT;
	}
}

QByteArray& AICore::getActionPacket()
{
	return actionPacket;
}

QPair<int, double> AICore::getShootAngle(int step)
{
	return indexLookup[step];
}

QList<unsigned char> AICore::getIndizes(int angle)
{
	return angleLookup.values(angle);
}

void AICore::swapFrames()
{
	FrameData *tmpFrame = currentFrame;
	currentFrame = lastFrame;
	lastFrame = tmpFrame;
}

FrameData* AICore::getCurrent()
{
	return currentFrame;
}

FrameData* AICore::getLast()
{
	return lastFrame;
}


void AICore::setJob(Job *j)
{
	job = j;
}

Job* AICore::getJob()
{
	Job *j=job;
	job = 0;
	return j;
}

void AICore::setMainWindow(MainWindow *mW)
{
	mainWindow = mW;
}

MainWindow* AICore::getMainWindow()
{
	return mainWindow;
}

void AICore::setMameScene(MameScene *mS)
{
	mameScene=mS;
}

MameScene* AICore::getMameScene()
{
	return mameScene;
}



Radius::Radius()
{
	SmallMin = 20.0;
	SmallMax = 30.0;

	MediumMin = 30.0;
	MediumMax = 40.0;

	BigMin = 50.0;
	BigMax = 60.0;
}

Radius::~Radius()
{
}

// mre
SpeedDef::SpeedDef()
{
	anVspeed = 100.0;
	anRadSpeed = 1.00;
	offsetAn = 1.0,

	enVspeed = 100.0;
	enRadSpeed = 1.00;
	offsetEn = 1.0;
}

SpeedDef::~SpeedDef()
{
}
