package doertbrexel.util;

public class Vector2D
{
	protected static final int	X_UPPER_BOUND	= 511;
	protected static final int	X_LOWER_BOUND	= -(X_UPPER_BOUND + 1);
	protected static final int	X_KORR_VAL		= (X_UPPER_BOUND + 1) * 2;
	protected static final int	Y_UPPER_BOUND	= 383;
	protected static final int	Y_LOWER_BOUND	= -(Y_UPPER_BOUND + 1);
	protected static final int	Y_KORR_VAL		= (Y_UPPER_BOUND + 1) * 2;

	public int					mX				= 0;
	public int					mY				= 0;

	public Vector2D(int pX, int pY)
	{
		mX = pX;
		mY = pY;
	}

	public int squaredLength()
	{
		return mX * mX + mY * mY;
	}

	public String toString()
	{
		return "[" + mX + "," + mY + "]";
	}

	public Vector2D add(Vector2D pSecondOperand)
	{
		if (pSecondOperand == null)
			return this;
		return new Vector2D(mX + pSecondOperand.mX, mY + pSecondOperand.mY);
	}

	public Vector2D substract(Vector2D pSecondOperand)
	{
		if (pSecondOperand == null)
			return this;
		return new Vector2D(mX - pSecondOperand.mX, mY - pSecondOperand.mY);
	}

	public Vector2D div(int pDivisor)
	{
		return new Vector2D(mX / pDivisor, mY / pDivisor);
	}

	public int multiply(Vector2D pSecondOperand)
	{
		// Kreuzprodukt ???
		// [mX, mY, 0] x [pSecondOperand.mX, pSecondOperand.mY, 0]
		return mX * pSecondOperand.mY - mY * pSecondOperand.mX;
	}

	public Vector2D normalize()
	{
		// dx normalisieren auf -512 ... 511
		mX = normalize(mX, X_LOWER_BOUND, X_UPPER_BOUND, X_KORR_VAL);
		// dy normalisieren auf -384 ... 383
		mY = normalize(mY, Y_LOWER_BOUND, Y_UPPER_BOUND, Y_KORR_VAL);
		return this;
	}

	private int normalize(int pVal, final int pLowerBound, final int pUpperBound,
			final int pKorrVal)
	{
		while (pVal < pLowerBound)
		{
			pVal += pKorrVal;
		}
		while (pVal > pUpperBound)
		{
			pVal -= pKorrVal;
		}
		return pVal;
	}

}
