;test della grafica
(defun irem (n d)
  (round (* d (rem (float (/ n d))))))

(defun rgb(r g b) (+ (* r 256 256) (* g 256) b))
(defun gcolor (i) (elt *vgacolors* (1+ (irem i 16))))
(setf *vgacolors* (list
  (rgb   0   0   0)
  (rgb  127   0   0)
  (rgb   0  127   0)
  (rgb  127  127   0)
  (rgb   0   0  127)
  (rgb  127   0   0)
  (rgb   0  127  127)
  (rgb  127  127  127)

  (rgb  191  191  191)
  (rgb  255  191  191)
  (rgb  191  255  191)
  (rgb  255  255  191)
  (rgb  191  191  255)
  (rgb  255  191  191)
  (rgb  191  255  255)
  (rgb  255  255  255)
))

(setf *scrny* (gmode 2))
(setf *scrnx* (1- (car *scrny*)))
(setf *scrny* (1- (car (cdr *scrny*))))


(gpentick 3)
(dotimes (i 60)
  (gpencolor (* 4 i))
  (gmoveto 0 (* 3 i))
  (glineto *scrnx* (* 3 i))
)
(readchar)

(gpentick 1)
(dotimes (i 60)
  (gpencolor (* 256 (* 4 i)))
  (gpentick 1)
  (gpentype (round ( / i 10))); 0 - 5
  (gmoveto 0 (* 3 i))
  (glineto *scrnx* (* 3 i))
)
(gpentype 1)
(gpentick 3)

(readchar)

(let (j k)
  (dotimes (i 32)
    (setf j (round (* i (/ *scrnx* 32) )))
    (setf k (round (* i (/ *scrny* 32) )))
    (gpencolor (gcolor i))
    (gbrushcolor (gcolor (+ i 3)))
    (gbrushtype (round (/ i 4)))
    (gfillpoly
      5
     j k
     (+ 100 j) k
     (+ 100 j) (+ 100 k)
     j (+ 100 k)
     j k
    )
  )
)


(readchar)

(let (j k)
  (dotimes (i 32)
    (setf j (round (* i (/ *scrnx* 32) )))
    (setf k (round (* i (/ *scrny* 32) )))
    (gpencolor (gcolor i))
    (gbrushcolor (gcolor (+ i 3)))
    (gbrushtype (round (/ i 4)))
    (gfillellipse
     (+ 50 j) k 30 50
    )
  )
)

(readchar)
(let (j k)
  (dotimes (i 32)
    (setf j (round (* i (/ *scrnx* 32) )))
    (setf k (round (* i (/ *scrny* 32) )))
    (gpencolor (gcolor i))
    (gbrushcolor (gcolor (+ i 3)))
    (gbrushtype (round (/ i 4)))
    (gfillsector
     (+ 100 j) k 0 (* i 10) 30 50
    )
  )
)

(readchar)

(let (j k)
  (dotimes (i 32)
    (setf j (round (* i (/ *scrnx* 32) )))
    (setf k (round (* i (/ *scrny* 32) )))
    (gpencolor (gcolor i))
    (gouttext (+ 150 j)  k "Andrea")
  )
)

(gmode 0)
