/*
 *
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 * Copyright 1993 by Erik Nygren
 * Copyright 1994 by Ralph Ganszky
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Thomas Roell not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Thomas Roell makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THE THOMAS ROELL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THOMAS ROELL BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Erik Nygren not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Erik Nygren makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THE ERIK NYGREN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL ERIK NYGREN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Erik Nygren, nygren@mit.edu
 * Based on pvga driver by: Thomas Roell
 *          Ralph Ganszky, r.ganszky@physik.uni-stuttgart.de
 *          (some little corrections for XFree 2.1 marked with 'dd.mm.yy rg')
 *
 * WARNING:
 * This is pre-alpha code that is intended only for those who want to
 * use a mono server or mess with the color server.  Be very careful!
 *
 */

#include "X.h"
#include "input.h"
#include "screenint.h"

#include "compiler.h"

#include "x386.h"
#include "x386Priv.h"
#include "xf86_OSlib.h"
#include "xf86_HWlib.h"
#include "vga.h"

#ifdef XF86VGA16
#define MONOVGA
#endif

typedef struct {
  vgaHWRec      std;          /* std IBM VGA register */

  /* W5186 */                     /* Port Index Lock*/
  unsigned char CtrlReg0;         /* 03C5 05  W  */   /* Sequencer registers */
  unsigned char CtrlReg1;         /* 03C5 06  W  */
  unsigned char Misc;             /* 03C5 11  RW */
  unsigned char OutputCtrl;       /* 03C5 12  RW */
  unsigned char MemoryBase;       /* 03C5 13  RW */
  unsigned char Interlace;        /* 03x5 19  -  */   /* CRT Controller */
  unsigned char SerialStartHigh;  /* 03x5 1a  -  */ 
  unsigned char SerialStartLow;   /* 03x5 1b  -  */ 
  unsigned char SerialOffset;     /* 03x5 1c  -  */ 
  unsigned char ExtendedGraphics; /* 03CF 0c  W  */

} vgaW5186Rec, *vgaW5186Ptr;

static Bool  W5186Probe();
static char *W5186Ident();
static Bool  W5186ClockSelect();
static void  W5186EnterLeave();
static Bool  W5186Init();
static void *W5186Save();
static void  W5186Restore();
static void  W5186Adjust();
extern void  W5186SetRead();
extern void  W5186SetWrite();
extern void  W5186SetReadWrite();

vgaVideoChipRec W5186 = {
  W5186Probe,
  W5186Ident,
  W5186EnterLeave,
  W5186Init,
  W5186Save,
  W5186Restore,
  W5186Adjust,
  NoopDDA,	      /* 02.04.94 rg */
  NoopDDA,
  NoopDDA,
  NoopDDA,	      /* 02.04.94 rg */
  NoopDDA,	      /* Take the generic routines */
  NoopDDA,
  0x10000,            /* This stuff has been changed - ELN */
  0x10000,
  16,
  0xFFFF,
  0x00000, 0x10000,
  0x00000, 0x10000,
  TRUE,                                    /* Uses 2 banks */
  VGA_NO_DIVIDE_VERT,
  {0,},
  8,
};

#define new ((vgaW5186Ptr)vgaNewVideoState)

#define MCLK	8		/* (VCLK == MCLK) is clock index 8 */

#define W5186_CHIPSET	0		/* W5186 */
static int ChipSet;
static int MClk;
static unsigned char save_cs2 = 0;

/*
 * W5186Ident
 */

static char *
W5186Ident(n)
     int n;
{
  static char *chipsets[] = {"w5186"};

  if (n + 1 > sizeof(chipsets) / sizeof(char *))
    return(NULL);
  else
    return(chipsets[n]);
}


/*
 * W5186ClockSelect --
 *      select one of the possible clocks ...
 */

static Bool
W5186ClockSelect(no)
     int no;
{
  static unsigned char save1, save2, save3;
  unsigned char temp;

  switch(no)
  {
    case CLK_REG_SAVE:
      save1 = inb(0x3CC);
      outb(0x3CE, 0x0C); save2 = inb(0x3CF);
      break;
    case CLK_REG_RESTORE:
      outb(0x3C2, save1);
      outw(0x3CE, 0x0C | (save2 << 8));
      break;
    case MCLK:
      outb(vgaIOBase+4, 0x2E);
      temp = inb(vgaIOBase+5);
      outb(vgaIOBase+5, temp | 0x10);
      break;
    default:
      /*
       * Disable feeding MCLK to VCLK
       */
      temp = inb(0x3CC);
      outb(0x3C2, ( temp & 0xf3) | ((no << 2) & 0x0C));
      outw(0x3CE, 0x0C | ((((no & 0x04) >> 1) ^ save_cs2) << 8));
  }
  return TRUE; /* 02.04.94 rg */
}



/*
 * W5186Probe --
 *      check up whether a W5186 based board is installed
 */

static Bool
W5186Probe()
{
    int numclocks;
    unsigned char tmp;

    if (vga2InfoRec.chipset) {
        if (!StrCaseCmp(vga2InfoRec.chipset, W5186Ident(0)))
	  ChipSet = W5186_CHIPSET;
        else
	  return FALSE;
        W5186EnterLeave(ENTER);
    }
    else {
	char ident[4];
	int fd;
	
	ChipSet = W5186_CHIPSET;	
        W5186EnterLeave(ENTER);
    }
    /* 02.04.94 rg */
    if (!vga2InfoRec.videoRam)
      vga2InfoRec.videoRam = 256;

    numclocks = 8;
    if (!vga2InfoRec.clocks)
      vgaGetClocks(numclocks, W5186ClockSelect);
    MClk = vga2InfoRec.clock[MCLK];

    vga2InfoRec.chipset = W5186Ident(ChipSet);
    /* 02.04.94 rg 
    vga2InfoRec.bankedMono = TRUE; */
    
    return TRUE;
}



/*
 * W5186EnterLeave --
 *      enable/disable io-mapping
 */

static void 
W5186EnterLeave(enter)
     Bool enter;
{
  unsigned char temp;

  if (enter)
    {
#ifdef HAS_USL_VTS
      ioctl(x386Info.consoleFd, KDENABIO, 0);
#endif

      vgaIOBase = (inb(0x3CC) & 0x01) ? 0x3D0 : 0x3B0;

      /* Unlock extended registers.
       * This is now disabled due to the fact that there are still
       * some rouge unauthorized register accesses which do BAD things
       */
#ifdef THIS_IS_NOW_DISABLED
      outb(0x3C4, 0x11);
      temp = inb(0x3C5);  /* Read misc register */
      outb(0x3C5,temp); outb(0x3C5,temp); /* Write back twice */
      temp = inb(0x3C5);  /* Read misc register again */
      outb(0x3C5,temp & ~0x20);   /* Clear bit 5 */
#endif      
    }
  else
    {
#ifdef HAS_USL_VTS
      ioctl(x386Info.consoleFd, KDDISABIO, 0);
#endif

#ifdef THIS_IS_NOW_DISABLED
      /* Relock extended registers */
      outb(0x3C4, 0x11);
      temp = inb(0x3C5);  /* Read misc register */
      outb(0x3C5,temp | 0x20);   /* Set bit 5 */
#endif
    }
}

/*
 * W5186Restore --
 *      restore a video mode
 */

static void
W5186Restore(restore)
     vgaW5186Ptr restore;
{
  unsigned char temp;


  outb(0x3CD, 0x00);   /* select bank 0 */

  vgaHWRestore(restore);

  /* Unlock Extended Registers */
  outb(0x3C4, 0x11);
  temp = inb(0x3C5);  /* Read misc register */
  outb(0x3C5,temp); outb(0x3C5,temp); /* Write back twice */
  temp = inb(0x3C5);  /* Read misc register again */
  outb(0x3C5,temp & ~0x20);   /* Clear bit 5 */

#ifdef SOME_SAMPLE_REGISTER_CODE
  /* Update base memory address */
  outb(0x3C4,0x13);
  temp = inb(0x3C5);
  outb(0x3C5, 0x0A | (temp & 0xF0));
  /* Update Misc Register */
  outb(0x3C4,0x11);
  temp = inb(0x3C5);
  outb(0x3C5, temp & ~0x48);
  /* Update an ATTR register */
  temp = inb(0x3DA);
  outb(0x3C1,0x10);
  temp = inb(0x3DA);
  temp = inb(0x3C1);
  temp = inb(0x3DA);
  outb(0x3C0,0x10);
  temp = inb(0x3DA);
  outb(0x3C0, temp | 0x40);
#endif

  /*zzz*/

  /* Enable Bank Switching */
  outb(0x3C4,0x11);
  temp = inb(0x3C5);
  outb(0x3C5, (temp & 0xBF) | 0x00);

  /* Relock Extended Registers */
  outb(0x3C4, 0x11);
  temp = inb(0x3C5);  /* Read misc register */
  outb(0x3C5,temp | 0x20);   /* Set bit 5 */

}



/*
 * W5186Save --
 *      save the current video mode
 */

static void *
W5186Save(save)
     vgaW5186Ptr save;
{
  unsigned char PR0A, PR0B, temp;

  vgaIOBase = (inb(0x3CC) & 0x01) ? 0x3D0 : 0x3B0;

  save = (vgaW5186Ptr)vgaHWSave(save, sizeof(vgaW5186Rec));

  return ((void *) save);
}



/*
 * W5186Init --
 *      Handle the initialization, etc. of a screen.
 */

static Bool
W5186Init(mode)
     DisplayModePtr mode;
{

  if (!vgaHWInit(mode,sizeof(vgaW5186Rec)))
    return(FALSE);

#ifdef Never /* 02.04.94 rg */
#ifndef MONOVGA
  /* Offset register specifies the width of the display */
  new->std.CRTC[19] = (vga2InfoRec.virtualX >> 3);   
  /* This line seems essential for the W5186 to work.  It sets double word
   * addressing */
  new->std.CRTC[20] = 0x40;
  /* This seems right.  Stuff in most sig nibble seem unimportant as long
   * as above line CRTC[20] is set to 0x40.
   * It seems bad to set least sig nibble to other than 0x3.
   */
  new->std.CRTC[23] = 0xE3;
#endif
#endif

  return(TRUE);
}
	


/*
 * W5186Adjust --
 *      adjust the current video frame to display the mousecursor
 */

static void 
W5186Adjust(x, y)
     int x, y;
{
/* #ifdef MONOVGA 02.04.94 rg */
  int           Base = (y * vga2InfoRec.virtualX + x) >> 3;
/* #else
  int           Base = (y * vga2InfoRec.virtualX + x) >> 2;
#endif */
  unsigned char temp;

  outw(vgaIOBase + 4, (Base & 0x00FF00) | 0x0C);
  outw(vgaIOBase + 4, ((Base & 0x00FF) << 8) | 0x0D);
  outb(0x3CE, 0x0D); temp=inb(0x3CF); 
  outb(0x3CF, ((Base & 0x030000) >> 13) | (temp & 0xE7));
}



