/* portions of this program may be copyrighted by someone - so watch out! */
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <graph.h>
/*#include "vga.h"*/
/*#pragma intrinsic(_inp,_outp)*/
#pragma optimize ( "i" , on )

/* "see page" refers to the w5186 manual */
struct vgarec /* this is like vgahwrec, but no DAC[768] but has w5186 reg.'s*/
 {
  int MiscOutReg ;       /* 1 0x3cc */
  int crtcorigindex ;    /* = inp ( vgastuff -> vgaIOBase + 4 ) */
  int CRTC [ 0x1E ] ;    /* 2 i=0 to i=0x1D _outp vgastuff -> vgaIOBase + 4,i
                                 CRTC[i] = inp vgastuff -> vgaIOBase + 5 */
  int w5186misc [ 4 ] ;        /* = inp ( 0x3C5 ) at index 11 */
  int seqncr_indx_etc ; /* = inp ( 0x3C4 ) - see page 43 */
  int Sequencer [ 0x14 ] ; /* 3 Video Sequencer i=0 to i=0x13 _outp 0x3C4,i
                                  Sequencer [i] = inp 0x3C5 */
  int graphicsindexreg ; /* = inp ( 0x3CE ) - see page 32 */
  int Graphics [ 0xD ] ;   /* 4 Video Graphics i=0 to i=0xC _outp 0x3CE,i */
                          /*        Graphics[i] = inp 0x3CF  */
  int Attribute [ 0x16 ] ; /* 5 Video Atribute i=0 to i=0x15
                                    tmp = inp vgastuff -> vgaIOBase + 0x0A
                                    _outp 0x3C0,i
                                    Attribute [i] = inp 0x3C1 */
  /*int readblind [ 23 ] ; */
  unsigned int vgaIOBase ; /* base address for CRTC regs */
  int InputStatus1 ; /*= inp ( vgastuff -> vgaIOBase + 0xA ) */
  int attribindex /* = inp ( 0x3C1 ) */ ;

  int inputstatus0 ; /*= inp ( 0x3C2 ) /* general, input status 0 reg. */
  int dacpixlreadmask ; /*= inp ( 0x3C6 ) - see page 32 */
  int dac_status_reg ; /* = inp ( 0x3C7 ) - see page 32 */
  int dac_addrs_reg ; /* = inp ( 0x3C8 ) - see page 32 */
  int dacolrlookuptbl ; /*= inp ( 0x3C9 ) - see page 32 */
  int featurecntrlreg ; /* = inp ( 0x3CA ) - see page 32 */
  int miscoutcntrl ; /* = inp ( 0x3CC ) - see page 32 */
  int bankselect ; /*   = inp ( 0x3CD ) - see page 32 */
 } ;

typedef struct vgarec *vgarecptr ;

static  FILE * outfile = stdout ;

void hexbindec ( int portdata ) /* print in hex, binary & decimal */
 {
  fprintf ( outfile , "\t%02Xh=%d%d%d%d %d%d%d%d=%3d\n" , portdata ,
                  ( portdata & 0x80 )    ? 1 : 0 ,
                  ( portdata & 0x40 )    ? 1 : 0 ,
                  ( portdata & 0x20 )    ? 1 : 0 ,
                  ( portdata & 0x10 )    ? 1 : 0 ,
                  ( portdata & 0x08 )    ? 1 : 0 ,
                  ( portdata & 0x04 )    ? 1 : 0 ,
                  ( portdata & 0x02 )    ? 1 : 0 ,
                  ( portdata & 0x01 )    ? 1 : 0 , portdata ) ;
 }
void showidxhead ( int dataport , char * regname ) /* show index reg header */
 {
  fprintf ( outfile , "%X %s\n" , dataport , regname ) ;
 }

void showidx ( unsigned portdata , int index ) /* show contents of index reg */
 {
  fprintf ( outfile , "%02Xh" , index ) ;
  hexbindec ( portdata ) ;
 }

void show ( int portdata , int dataport , char * regname )
 {		/* show contents of non-index reg */
  fprintf ( outfile , "%X %s" , dataport , regname ) ;
  hexbindec ( portdata ) ;
 }

/********************************************************************/

void W5186grabreg ( vgarecptr vgastuff )
 { /* like the above vgaHWSave, but more 5186 regs, no DAC pallette save*/
  int colormode , index ; /*, unused ; */

  colormode = ( vgastuff -> MiscOutReg = _inp ( 0x3CC ) ) & 1 ;
  vgastuff -> vgaIOBase = ( unsigned ) ( colormode ? 0x3D0 : 0x3B0 ) ;

  /* disable interrupts */
/*  _disable ( ) ;*/

  /* get all unprotected registers */

  vgastuff -> crtcorigindex = _inp ( vgastuff -> vgaIOBase + 4 ) ;
  for ( index = 0 ; index < 0x1E ; index ++ )
   {
    _outp ( vgastuff -> vgaIOBase + 4 , index ) ;
    vgastuff -> CRTC [ index ] = _inp ( vgastuff -> vgaIOBase + 5 ) ;
           /* no xtrabits */
   }
  _outp ( vgastuff -> vgaIOBase + 4 , vgastuff -> crtcorigindex ) ;/*restore index reg.*/

  /* disable interrupts */
  _disable ( ) ;
  vgastuff -> InputStatus1 = _inp ( 0x3DA ) ;
         /* this also initializes */
         /* attribute controller reg to access 'address' next (page 85) */

  vgastuff -> attribindex = _inp ( 0x3C1 ) ;
  /* xtrabits = 0x20 & saveindexreg ; */
  /* BIT 5 IS 'PALETTE ADDRESS SOURCE' - A CONTROL BIT, SO LET'S PRESERVE IT
  /* (ferraro pg 405, w5186 pg 85 ) this also initializes attribute controller
  /* reg to access 'address' next (page 85) */

  for ( index = 0 ; index < 0x16 ; index ++ )
   {
    /* disable interrupts */
    _inp ( 0x3DA ) ; /* reset flipflop to access index register */
    _outp ( 0x3C0 , index ) ; /* set index */
    vgastuff -> Attribute [ index ] = _inp ( 0x3C1 ) ; /* read attribute */
   }

  _inp ( 0X3DA ) ; /* init attrib cntrlr reg to 'address' */
  _outp ( 0x3C0 , 0x20 ) ; /* set PAS */
  _enable ( ) ;

  vgastuff -> inputstatus0    = _inp ( 0x3C2 ) ; /*general input status 0 reg*/
  vgastuff -> dacpixlreadmask = _inp ( 0x3C6 ) ; /* see page 32 */
  vgastuff -> dac_status_reg  = _inp ( 0x3C7 ) ; /* see page 32 */
  vgastuff -> dac_addrs_reg   = _inp ( 0x3C8 ) ; /* see page 32 */
  vgastuff -> dacolrlookuptbl = _inp ( 0x3C9 ) ; /* see page 32 */
  vgastuff -> featurecntrlreg = _inp ( 0x3CA ) ; /* see page 32 */
  vgastuff -> miscoutcntrl    = _inp ( 0x3CC ) ; /* see page 32 */
  vgastuff -> bankselect      = _inp ( 0x3CD ) ; /* see page 32 */

  vgastuff -> graphicsindexreg = _inp ( 0x3CE ) ; /* see page 32 */
  /*assume xtrabits = 0 since bit 7 "GHAB" seems to be aread only status bit */

  for ( index = 0 ; index < 0xD ; index ++ )
   {
    _outp ( 0x3CE , index ) ;
    vgastuff -> Graphics [ index ] = _inp ( 0x3CF ) ;
   }

  _outp ( 0x3CE , vgastuff -> graphicsindexreg ) ; /* restore index reg. */

  vgastuff -> seqncr_indx_etc = _inp ( 0x3C4 ) ; /* see page 43 */
  /*xtrabits = vgastuff -> seqncr_indx_etc & 8 ;*/
                /* xtrabit "ARE" bit - I guess it will always be 0 */

  _disable();
  /* Unlock extended registers. */
  _outp ( 0x3C4, 0x11 ) ; /*|xtrabits, ADDRESS MISC. REG. */
  vgastuff -> w5186misc [ 0 ] = _inp ( 0x3C5 ) ; /*Read misc register*/
  _outp ( 0x3C5 , vgastuff -> w5186misc [ 0 ] ) ;
  _outp ( 0x3C5 , vgastuff -> w5186misc [ 0 ] ) ; /* Write back twice */
  vgastuff -> w5186misc [ 1 ]  = _inp ( 0x3C5 )  ; /*Read misc register again*/
  _outp ( 0x3C5 , ( vgastuff -> w5186misc [ 1 ] ) & 0xDF ) ; /* Clear bit 5 */

  for ( index = 0x10 ; index < 0x14 ; index ++ )
   {
    _outp ( 0x3C4 , index ) ;
    vgastuff -> Sequencer [ index ] = _inp ( 0x3C5 ) ;
   }

  /* Relock extended registers */
  _outp ( 0x3C4, 0x11 ) ;
  vgastuff -> w5186misc [ 2 ] = _inp ( 0x3C5 ) ; /* Read misc register */
  _outp ( 0x3C5 , vgastuff -> w5186misc [ 2 ] | 0x20 ) ;   /* Set bit 5 */
  _enable();
  /* get unprotected sequencer regs */
  for ( index = 0 ; index < 8 ; index ++ )
   {
    _outp ( 0x3C4 , index ) ;
    vgastuff -> Sequencer [ index ] = _inp ( 0x3C5 ) ;
   }

  _outp ( 0x3C4, 0x11 ) ; /* lets take one more look */
  vgastuff -> w5186misc [ 3 ] = _inp ( 0x3C5 ) ; /* Read misc register */
  _outp ( 0x3C4 , vgastuff -> seqncr_indx_etc ) ;
                                        /*restore sequencer index/etc reg*/
 }

/****************************************************************************/

void W5186showreg ( vgarecptr vgastuff )
 {		/* show results of W5186grabreg */
  int colormode , index ;
  colormode = vgastuff -> MiscOutReg & 1 ;
  fprintf ( outfile , "color mode = %d\n" , colormode ) ;
  fprintf ( outfile , "vgaIOBase = %X\n" , vgastuff -> vgaIOBase ) ;

  /* show all unprotected registers */

  show ( vgastuff -> crtcorigindex , vgastuff -> vgaIOBase + 4 ,
                                                      "crtcorigindex" ) ;
  showidxhead ( vgastuff -> vgaIOBase + 5 , "CRTC" ) ;
  for ( index = 0 ; index < 0x1E ; index ++ )
    showidx ( vgastuff -> CRTC [ index ] , index ) ;

  show ( vgastuff -> InputStatus1 , vgastuff -> vgaIOBase + 0xA ,
                    "InputStatus1" ) ;

  show ( vgastuff -> attribindex , 0x3C1 , "attribindex" ) ;
  fprintf ( outfile , "PALETTE ADDRESS SOURCE = %X\n" ,
              ( vgastuff -> attribindex ) & 0x20 ) ;
  /* BIT 5 IS 'PALETTE ADDRESS SOURCE' - A CONTROL BIT,
      (ferraro pg 405, w5186 pg 85 ) */ /* apparently it's not readable */

  showidxhead ( 0x3C1 , "Attribute" ) ;
  for ( index = 0 ; index < 0x16 ; index ++ )
    showidx ( vgastuff -> Attribute [ index ] , index ) ;

  show ( vgastuff -> inputstatus0 , 0x3C2 , "general, input status 0 reg." ) ;
  show ( vgastuff -> dacpixlreadmask , 0x3C6 ,
                                             "dacpixlreadmask see page 32" ) ;
  show ( vgastuff -> dac_status_reg  , 0x3C7 , "dac_status_reg" ) ;
                                              /* see page 32 */
  show ( vgastuff -> dac_addrs_reg   , 0x3C8 , "dac_addrs_reg" ) ;
                                             /* see page 32 */
  show ( vgastuff -> dacolrlookuptbl , 0x3C9 , "dacolrlookuptbl" ) ;
                                                           /* see page 32 */
  show ( vgastuff -> featurecntrlreg , 0x3CA , "featurecntrlreg" ) ;
                                                           /* see page 32 */
  show ( vgastuff -> miscoutcntrl    , 0x3CC , "miscoutcntrl" ) ;
                                                           /* see page 32 */
  show ( vgastuff -> bankselect      , 0x3CD , "bankselect" ) ;
                                                           /* see page 32 */
  show ( vgastuff -> graphicsindexreg , 0x3CE , "graphicsindexreg" ) ;
                                                           /* see page 32 */
  /*assume xtrabits = 0 since bit 7 "GHAB" seems to be aread only status bit */

  show ( ( vgastuff -> graphicsindexreg ) & 0x80 , 0x3CE ,
                    "graphicsindexreg GHAB bit should be 0" ) ;
  /* see page 32 */
  /*assume xtrabits = 0 since bit 7 "GHAB" seems to be aread only status bit */

  showidxhead ( 0x3CF , "Graphics" ) ;
  for ( index = 0 ; index < 0xD ; index ++ )
    showidx ( vgastuff -> Graphics [ index ] , index ) ;

  show ( vgastuff -> seqncr_indx_etc , 0x3C4 , "seqncr_indx_etc pg. 43" ) ;

  fprintf ( outfile ,
            "seqncr_indx_etc & 8 = %0X ARE bit, guess it will always be 0\n" ,
            ( vgastuff -> seqncr_indx_etc ) & 8 ) ;

  showidxhead ( 0x3C5 , "Sequencer" ) ;
  for ( index = 0 ; index < 8 ; index ++ )
   {
    showidx ( vgastuff -> Sequencer [ index ] , index ) ;
   }

  showidxhead ( 0x3C5 , "w5186misc, index 11 at various times" ) ;
  showidx ( vgastuff -> w5186misc [ 0 ] , 0 ) ;
  showidx ( vgastuff -> w5186misc [ 1 ] , 1 ) ;
  showidx ( vgastuff -> w5186misc [ 2 ] , 2 ) ;
  showidx ( vgastuff -> w5186misc [ 3 ] , 3 ) ;

  showidxhead ( 0x3C5 , "Sequencer" ) ;
  for ( index = 0x10 ; index < 0x14 ; index ++ )
    showidx ( vgastuff -> Sequencer [ index ] , index ) ;
 }

void usage ( char * progname )
 {  /* tell them how to use me, and quit */
    fprintf ( stderr , "\a\nusage: %s [ -1 ] [ outfile ]\n\
    default output to stdout.\n\n" , progname ) ;
    exit ( 1 ) ; /*outfile -1 or -1 outfile both allowed */
 }

void main ( int argc , char * * argv )
 {
  char * progname = argv [ 0 ] ;
  struct _videoconfig vidconfig ;

  short vidmodes [ ] = {
    _TEXTBW40	, /* 0	/* 40-column text, 16 grey */
    _TEXTC40	, /* 1	/* 40-column text, 16/8 color */
    _TEXTBW80	, /* 2	/* 80-column text, 16 grey */
    _TEXTC80	, /* 3	/* 80-column text, 16/8 color */
    _MRES4COLOR	, /* 4	/* 320 x 200, 4 color */
    _MRESNOCOLOR, /* 5	/* 320 x 200, 4 grey */
    _HRESBW	, /* 6	/* 640 x 200, BW */
    _TEXTMONO	, /* 7	/* 80-column text, BW */
    _MRES16COLOR, /* 13	/* 320 x 200, 16 color , 32kb */
    _ERESCOLOR	, /* 16	/* 640 x 350, 4 or 16 color 112 kb */
    _VRES2COLOR	, /* 17	/* 640 x 480, BW */
    _VRES16COLOR, /* 18	/* 640 x 480, 16 color 153.6 kb */
    _MRES256COLOR,/* 19	/* 320 x 200, 256 color 64kb */
    _SRES16COLOR, /* 0x0102	/* 800 x 600, 16 color , 256kb */
    0x6A , /* 800x600x16 color supported by viper??? */
    -1 } ;

  int vidmodeindex , onceflag = 0 ;
  struct vgarec vgaRec ;

  while ( --argc )
   {
    argv ++ ;
    if ( argv [ 0 ] [ 0 ] == '-' )
      if ( ( argv [ 0 ] [ 1 ] != '1' ) || ( argv [ 0 ] [ 2 ] != 0 ) )
        usage ( progname ) ;
      else
        if ( onceflag )
          usage ( progname ) ;
        else
          onceflag = 1 ;
    else
      /* if user specifies an output file */
      if ( outfile != stdout ) /* if user gave 2 filename args */
        usage ( progname ) ;
      else
       { /*try to open out-file for output*/
        outfile = fopen ( argv [ 0 ] , "w" ) ;
        if ( outfile == NULL ) /* if we can't open it */
         {
          fprintf ( stderr , "error opening output-file \"%s\".\n" ,
                                            argv [ 0 ] ) ;
          perror ( progname ) ; /* tell the user why */
          exit ( 1 ) ;          /* quit with an error status */
         }
       }
   }
  /* get the dope on the current video mode */
  _getvideoconfig ( & vidconfig ) ;
  fprintf ( outfile,
"numxpixels = %d , numypixels = %d , numtextcols = %d , numtextrows = %d\n"
"numcolors = %d , bitsperpixel = %d , numvideopages = %d , adapter = %d\n"
"mode = %d , monitor = %d , memory = %d\n" ,
     vidconfig.numxpixels , vidconfig.numypixels , vidconfig.numtextcols ,
     vidconfig.numtextrows , vidconfig.numcolors , vidconfig.bitsperpixel ,
     vidconfig.numvideopages , vidconfig.adapter , vidconfig.mode ,
     vidconfig.monitor , vidconfig.memory ) ;
  if ( outfile == stdout ) /* if printing to screen */
   {
    fprintf ( stdout , "\a" ) ; /* beep ! */
    getchar ( ) ; /* wait for keystroke */
   }
  W5186grabreg ( & vgaRec ) ;
  W5186showreg ( & vgaRec ) ;

  if ( outfile == stdout ) /* if printing to screen */
   {
    fprintf ( stdout , "\a" ) ; /* beep ! */
    getchar ( ) ; /* wait for keystroke */
   }

  /* if we don't have the "-1" option, run through some more modes */
  vidmodeindex = 0 ;
  while (  ( ! onceflag ) && ( vidmodes [ vidmodeindex ] >= 0 ) )
   {
    if ( ! _setvideomode ( vidmodes [ vidmodeindex ] ) )
      fprintf ( outfile ,
               "error setting videomode [index %d] = %d - oh no !\n" ,
                vidmodeindex , vidmodes [ vidmodeindex ] ) ;
    else
     {
      _getvideoconfig ( & vidconfig ) ;
      fprintf ( outfile ,
"*************************************************************************\n"
"vidmodeindex = %d \n"
"vidmodes[vidmodeindex] (video mode set) = %X hex = %d (decimal of course)\n"
"numxpixels = %d , numypixels = %d , numtextcols = %d , numtextrows = %d\n"
"numcolors = %d , bitsperpixel = %d , numvideopages = %d , adapter = %d\n"
"mode = %d , monitor = %d , memory = %d\n" , vidmodeindex ,
          vidmodes [ vidmodeindex ] ,
          vidmodes [ vidmodeindex ] , vidconfig.numxpixels ,
          vidconfig.numypixels , vidconfig.numtextcols ,
          vidconfig.numtextrows , vidconfig.numcolors ,
          vidconfig.bitsperpixel , vidconfig.numvideopages ,
          vidconfig.adapter , vidconfig.mode , vidconfig.monitor ,
          vidconfig.memory ) ;
      W5186grabreg ( & vgaRec ) ;
      W5186showreg ( & vgaRec ) ;
     }
    vidmodeindex ++ ;
    if ( outfile == stdout ) /* if printing to screen */
     {
      fprintf ( stdout , "\a" ) ; /* beep ! */
      getchar ( ) ; /* wait for keystroke */
     }
   }
  _setvideomode ( _DEFAULTMODE ) ;
  exit ( 0 ) ;
 }
