package com.hemju.biborder;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * OrderStrategies are implementing the actual sorting/odering of bib references.
 *
 * @author Helmut Juskewycz, <hjuskewycz - at - hemju.com>
 */
public interface OrderStrategy {

  /***
   * Takes the content from the input stream and sorts/oders the bib referencing and then sends the result to
   * the output stream.
   *
   * @param in the input stream containing the text, e.g. file input stream
   * @param out the output stream which receives the result, e.g. System.out
   */
  public void order(InputStream in, OutputStream out);
}
