/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.NbDialog;
import org.netbeans.core.windows.services.NbPresenter;
import org.netbeans.core.windows.services.PresenterDecorator;
import org.netbeans.core.windows.view.ui.DefaultSeparateContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DialogDisplayerImpl
extends DialogDisplayer {
    private static List<Runnable> run = Collections.synchronizedList(new ArrayList());
    private Object testResult;

    public DialogDisplayerImpl() {
        this(null);
    }

    DialogDisplayerImpl(Object object) {
        this.testResult = object;
    }

    public static void runDelayed() {
        NbPresenter.LOG.fine("runDelayed");
        List<Runnable> list = run;
        run = null;
        if (list == null) {
            NbPresenter.LOG.fine("runDelayed, nothing");
            return;
        }
        assert (EventQueue.isDispatchThread());
        for (Runnable runnable : list) {
            NbPresenter.LOG.fine("runDelayed, run = " + runnable);
            runnable.run();
        }
        NbPresenter.LOG.fine("runDelayed, done");
    }

    public Dialog createDialog(DialogDescriptor dialogDescriptor) {
        return this.createDialog(dialogDescriptor, null);
    }

    public Dialog createDialog(final DialogDescriptor dialogDescriptor, final Frame frame) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return (Dialog)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Dialog>(){

            public Dialog run() {
                Component component;
                Window window = frame;
                if (window != null && (component = Utilities.findDialogParent((Component)window)) != window) {
                    window = null;
                }
                if (!(window != null || (window = DialogDisplayerImpl.this.findDialogParent()) instanceof NbPresenter && window.isVisible() || window instanceof DefaultSeparateContainer.ModeUIBase)) {
                    component = SwingUtilities.getAncestorOfClass(Window.class, window);
                    window = component instanceof DefaultSeparateContainer.ModeUIBase ? (Window)component : WindowManager.getDefault().getMainWindow();
                }
                component = window instanceof Frame ? new NbDialog(dialogDescriptor, (Frame)window) : (window instanceof Dialog ? new NbDialog(dialogDescriptor, (Dialog)window) : new NbDialog(dialogDescriptor, WindowManager.getDefault().getMainWindow()));
                DialogDisplayerImpl.customizeDlg((NbPresenter)component);
                component.requestFocusInWindow();
                return component;
            }
        });
    }

    private Window findDialogParent() {
        Component component = Utilities.findDialogParent(null);
        Window window = this.findDialogParent(component);
        if (window == null || window == JOptionPane.getRootFrame() || window instanceof NbPresenter && ((NbPresenter)window).isLeaf()) {
            return WindowManager.getDefault().getMainWindow();
        }
        return window;
    }

    private Window findDialogParent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return this.findDialogParent(component.getParent());
    }

    public Object notify(NotifyDescriptor notifyDescriptor) {
        return this.notify(notifyDescriptor, new AWTQuery(notifyDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object notify(NotifyDescriptor notifyDescriptor, AWTQuery aWTQuery) {
        if (GraphicsEnvironment.isHeadless()) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            aWTQuery.showDialog();
            return notifyDescriptor.getValue();
        }
        AWTQuery aWTQuery2 = aWTQuery;
        synchronized (aWTQuery2) {
            SwingUtilities.invokeLater(aWTQuery);
            try {
                aWTQuery.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (aWTQuery.running) {
                while (aWTQuery.result == null) {
                    try {
                        aWTQuery.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return aWTQuery.result;
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
    }

    public void notifyLater(NotifyDescriptor notifyDescriptor) {
        this.notifyLater(new AWTQuery(notifyDescriptor));
    }

    private void notifyLater(AWTQuery aWTQuery) {
        Runnable runnable = () -> this.notify(aWTQuery.descriptor, aWTQuery);
        List<Runnable> list = run;
        if (list != null) {
            aWTQuery.noParent = true;
            list.add(runnable);
        } else {
            Mutex.EVENT.postReadRequest(runnable);
        }
    }

    private static void customizeDlg(NbPresenter nbPresenter) {
        for (PresenterDecorator presenterDecorator : Lookup.getDefault().lookupAll(PresenterDecorator.class)) {
            presenterDecorator.customizePresenter(nbPresenter);
        }
    }

    public <T extends NotifyDescriptor> CompletableFuture<T> notifyFuture(T t) {
        class AWTQuery2
        extends AWTQuery {
            volatile CompletableFuture res;

            public AWTQuery2(NotifyDescriptor notifyDescriptor) {
                super(notifyDescriptor);
            }

            @Override
            public void showDialog() {
                try {
                    super.showDialog();
                    Object object = this.descriptor.getValue();
                    if (this.cancelled || object == NotifyDescriptor.CLOSED_OPTION || object == NotifyDescriptor.CANCEL_OPTION) {
                        this.res.completeExceptionally(new CancellationException());
                    } else {
                        this.res.complete(this.descriptor);
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.res.completeExceptionally(throwable);
                }
            }
        }
        final AWTQuery2 aWTQuery2 = new AWTQuery2(t);
        class CF
        extends CompletableFuture<T> {
            CF() {
                aWTQuery2.res = this;
            }

            @Override
            public boolean cancel(boolean bl) {
                if (this.isDone()) {
                    return false;
                }
                aWTQuery2.cancel(bl);
                return super.cancel(bl);
            }
        }
        CF cF = new CF();
        aWTQuery2.res = cF;
        this.notifyLater(aWTQuery2);
        return cF;
    }

    class AWTQuery
    implements Runnable {
        public final NotifyDescriptor descriptor;
        public Object result;
        public boolean running;
        public volatile boolean noParent;
        public volatile boolean cancelled;
        NbPresenter presenter;

        public AWTQuery(NotifyDescriptor notifyDescriptor) {
            this.descriptor = notifyDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                this.notify();
                this.running = true;
            }
            this.showDialog();
            aWTQuery = this;
            synchronized (aWTQuery) {
                this.result = this.descriptor.getValue();
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean bl) {
            NbPresenter nbPresenter;
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                if (this.cancelled) {
                    return false;
                }
                if (this.running && !bl) {
                    return false;
                }
                this.cancelled = true;
                nbPresenter = this.presenter;
                if (nbPresenter == null) {
                    return true;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                nbPresenter.setVisible(false);
            } else {
                SwingUtilities.invokeLater(() -> nbPresenter.setVisible(false));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showDialog() {
            Window window;
            Object object;
            if (this.cancelled) {
                this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
                return;
            }
            if (DialogDisplayerImpl.this.testResult != null) {
                this.descriptor.setValue(DialogDisplayerImpl.this.testResult);
                return;
            }
            Component component = null;
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            for (object = topComponent; object != null && !(object instanceof Window); object = ((Component)object).getParent()) {
            }
            if (object != null) {
                component = ((Window)object).getFocusOwner();
            }
            Window window2 = window = this.noParent ? null : DialogDisplayerImpl.this.findDialogParent();
            NbPresenter nbPresenter = this.descriptor instanceof DialogDescriptor ? (window instanceof Dialog ? new NbDialog((DialogDescriptor)this.descriptor, (Dialog)window) : (window instanceof Frame ? new NbDialog((DialogDescriptor)this.descriptor, (Frame)window) : new NbDialog((DialogDescriptor)this.descriptor, (Frame)null))) : (window instanceof Dialog ? new NbPresenter(this.descriptor, (Dialog)window, true) : (window instanceof Frame ? new NbPresenter(this.descriptor, (Frame)window, true) : new NbPresenter(this.descriptor, (Frame)null, true)));
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                this.presenter = nbPresenter;
            }
            if ("true".equals(System.getProperty("javahelp.ignore.modality"))) {
                nbPresenter.getRootPane().putClientProperty("javahelp.ignore.modality", "true");
                System.setProperty("javahelp.ignore.modality", "false");
            }
            DialogDisplayerImpl.customizeDlg(nbPresenter);
            nbPresenter.getRootPane().requestDefaultFocus();
            nbPresenter.setVisible(true);
            if (component != null) {
                ((Component)object).requestFocusInWindow();
                topComponent.requestFocusInWindow();
                if (!(component instanceof JRootPane)) {
                    component.requestFocusInWindow();
                }
            }
        }
    }
}

