/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.xep;

import com.idiominc.ws.opentopic.fo.xep.Logger;
import com.renderx.xep.FOTarget;
import com.renderx.xep.FormatterImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

public class Runner {
    private boolean failed;
    private static boolean failOnError = true;

    public static void main(String[] args) {
        boolean failed;
        if (args.length < 2) {
            System.out.println("Invalid number of parameters. This class should not be executed outside of publising output build script");
            System.exit(1);
        }
        if (args.length >= 3 && args[2].equals("failOnError=false")) {
            failOnError = false;
        }
        if ((failed = new Runner().run(args)) && failOnError) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public void fail() {
        this.failed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run(String[] args) {
        FormatterImpl xep = null;
        try {
            xep = new FormatterImpl();
        }
        catch (Exception e) {
            System.out.println("Could not create XEP formatter: " + e.toString());
            return true;
        }
        String outputFormat = "PDF";
        for (int i = 2; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            outputFormat = args[i].substring(1);
        }
        try {
            SAXSource source = Runner.createSAXSource(args);
            OutputStream out = Runner.createOutputStream(args);
            Logger logger = Runner.createCustomLogger(this);
            try {
                try {
                    xep.render((Source)source, new FOTarget(out, outputFormat), (com.renderx.xep.lib.Logger)logger);
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e) {
                System.out.println("Rendering failed: " + e.getMessage());
                boolean bl = true;
                xep.cleanup();
                return bl;
            }
        }
        finally {
            xep.cleanup();
        }
        return this.failed;
    }

    private static SAXSource createSAXSource(String[] args) {
        SAXSource source = null;
        try {
            File in = new File(args[0]);
            InputSource saxsrc = new InputSource(in.toURI().toString());
            source = new SAXSource(saxsrc);
        }
        catch (Exception e) {
            System.out.println("Source creation failed: " + e.getMessage());
            System.exit(1);
        }
        return source;
    }

    private static OutputStream createOutputStream(String[] args) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(args[1]));
        }
        catch (Exception e) {
            System.out.println("Could not open output file: " + e.getMessage());
            System.exit(1);
        }
        return out;
    }

    private static Logger createCustomLogger(Runner runner) {
        Logger logger = null;
        try {
            logger = new Logger(runner);
        }
        catch (Exception e) {
            System.out.println("Log handler creation failed: " + e.getMessage());
            System.exit(1);
        }
        return logger;
    }
}

