/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class FootnoteLinkRefProcessor
implements LinkRefProcessor {
    static final boolean WANT_EXCLAMATION_PREFIX = false;
    static final int BRACKET_NESTING_LEVEL = 0;
    private final FootnoteRepository footnoteRepository;

    public FootnoteLinkRefProcessor(Document document) {
        this.footnoteRepository = (FootnoteRepository)((Object)FootnoteExtension.FOOTNOTES.get((DataHolder)document));
    }

    public boolean getWantExclamationPrefix() {
        return false;
    }

    public int getBracketNestingLevel() {
        return 0;
    }

    public boolean isMatch(@NotNull BasedSequence nodeChars) {
        return nodeChars.length() >= 3 && nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '^' && nodeChars.endCharAt(1) == ']';
    }

    @NotNull
    public Node createNode(@NotNull BasedSequence nodeChars) {
        BasedSequence footnoteId = (BasedSequence)((BasedSequence)nodeChars.midSequence(2, -1)).trim();
        FootnoteBlock footnoteBlock = footnoteId.length() > 0 ? (FootnoteBlock)((Object)this.footnoteRepository.get(footnoteId.toString())) : null;
        Footnote footnote = new Footnote(nodeChars.subSequence(0, 2), footnoteId, (BasedSequence)nodeChars.endSequence(1));
        footnote.setFootnoteBlock(footnoteBlock);
        if (footnoteBlock != null) {
            this.footnoteRepository.addFootnoteReference(footnoteBlock, footnote);
        }
        return footnote;
    }

    @NotNull
    public BasedSequence adjustInlineText(@NotNull Document document, @NotNull Node node) {
        assert (node instanceof Footnote);
        return ((Footnote)node).getText();
    }

    public boolean allowDelimiters(@NotNull BasedSequence chars, @NotNull Document document, @NotNull Node node) {
        return true;
    }

    public void updateNodeElements(@NotNull Document document, @NotNull Node node) {
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        @NotNull
        public LinkRefProcessor apply(@NotNull Document document) {
            return new FootnoteLinkRefProcessor(document);
        }

        public boolean getWantExclamationPrefix(@NotNull DataHolder options) {
            return false;
        }

        public int getBracketNestingLevel(@NotNull DataHolder options) {
            return 0;
        }
    }
}

