/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.dynamic;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroup;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class TorqueAbstractDynamicGroup
extends TorqueAbstractSecurityEntity
implements DynamicGroup {
    private static final long serialVersionUID = -122088742532595477L;
    private Set<User> userSet = null;
    private Set<Role> roleSet = null;

    protected List<TorqueDynamicUserGroup> getTorqueDynamicUserGroupsJoinTorqueDynamicUser(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicUserGroupPeer.GROUP_ID, (Object)this.getEntityId());
        return TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicUser(criteria, con);
    }

    protected List<TorqueDynamicGroupRole> getTorqueDynamicGroupRolesJoinTorqueDynamicRole(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicGroupRolePeer.GROUP_ID, (Object)this.getEntityId());
        return TorqueDynamicGroupRolePeer.doSelectJoinTorqueDynamicRole(criteria, con);
    }

    public void addUser(User user) {
        this.getUsers().add((SecurityEntity)user);
    }

    public UserSet getUsers() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        } else if (!(this.userSet instanceof UserSet)) {
            this.userSet = new UserSet(this.userSet);
        }
        return (UserSet)this.userSet;
    }

    public <T extends User> Set<T> getUsersAsSet() {
        return this.userSet;
    }

    public void removeUser(User user) {
        this.getUsers().remove((Object)user);
    }

    public void setUsers(UserSet userSet) {
        this.userSet = userSet != null ? userSet : new UserSet();
    }

    public <T extends User> void setUsersAsSet(Set<T> users) {
        this.setUsers(new UserSet(users));
    }

    public void addRole(Role role) {
        this.getRoles().add((SecurityEntity)role);
    }

    public RoleSet getRoles() {
        if (this.roleSet == null) {
            this.roleSet = new RoleSet();
        } else if (!(this.roleSet instanceof RoleSet)) {
            this.roleSet = new RoleSet(this.roleSet);
        }
        return (RoleSet)this.roleSet;
    }

    public <T extends Role> Set<T> getRolesAsSet() {
        return this.roleSet;
    }

    public void removeRole(Role role) {
        this.getRoles().remove((Object)role);
    }

    public void setRoles(RoleSet roleSet) {
        this.roleSet = roleSet != null ? roleSet : new RoleSet();
    }

    public <T extends Role> void setRolesAsSet(Set<T> roles) {
        this.setRoles(new RoleSet(roles));
    }

    public String getDatabaseName() {
        return TorqueDynamicGroupPeer.DATABASE_NAME;
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.userSet = new UserSet();
        try {
            List<TorqueDynamicUserGroup> usergroups = this.getTorqueDynamicUserGroupsJoinTorqueDynamicUser(new Criteria(), con);
            for (TorqueDynamicUserGroup tdug : usergroups) {
                this.userSet.add((User)tdug.getTorqueDynamicUser());
            }
            this.roleSet = new RoleSet();
            List<TorqueDynamicGroupRole> grouproles = this.getTorqueDynamicGroupRolesJoinTorqueDynamicRole(new Criteria(), con);
            for (TorqueDynamicGroupRole tdgr : grouproles) {
                this.roleSet.add((Role)tdgr.getTorqueDynamicRole());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        Criteria criteria;
        if (this.userSet != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicUserGroupPeer.GROUP_ID, (Object)this.getEntityId());
            TorqueDynamicUserGroupPeer.doDelete(criteria, con);
            for (User u : this.userSet) {
                TorqueDynamicUserGroup ug = new TorqueDynamicUserGroup();
                ug.setUserId((Integer)u.getId());
                ug.setGroupId(this.getEntityId());
                ug.save(con);
            }
        }
        if (this.roleSet != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicGroupRolePeer.GROUP_ID, (Object)this.getEntityId());
            TorqueDynamicGroupRolePeer.doDelete(criteria, con);
            for (Role r : this.roleSet) {
                TorqueDynamicGroupRole gr = new TorqueDynamicGroupRole();
                gr.setRoleId((Integer)r.getId());
                gr.setGroupId(this.getEntityId());
                gr.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueDynamicGroupPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

