/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.factory;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.batchee.container.cdi.BatchCDIInjectionExtension;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.services.factory.DefaultBatchArtifactFactory;
import org.apache.batchee.spi.BatchArtifactFactory;

public class CDIBatchArtifactFactory
extends DefaultBatchArtifactFactory {
    @Override
    public BatchArtifactFactory.Instance load(String batchId) {
        BeanManager bm = this.getBeanManager();
        if (bm == null) {
            return super.load(batchId);
        }
        Bean<?> bean = this.getBeanById(bm, batchId);
        if (bean == null) {
            return super.load(batchId);
        }
        Class clazz = bean.getBeanClass();
        final CreationalContext creationalContext = bm.createCreationalContext(bean);
        Object artifactInstance = bm.getReference(bean, (Type)clazz, creationalContext);
        if (Dependent.class.equals((Object)bean.getScope()) || !bm.isNormalScope(bean.getScope())) {
            return new BatchArtifactFactory.Instance(artifactInstance, new Closeable(){

                @Override
                public void close() throws IOException {
                    creationalContext.release();
                }
            });
        }
        return new BatchArtifactFactory.Instance(artifactInstance, null);
    }

    protected Bean<?> getBeanById(BeanManager bm, String id) {
        Bean<?> match = this.getUniqueBeanByBeanName(bm, id);
        if (match == null) {
            match = this.getUniqueBeanForBatchXMLEntry(bm, id);
        }
        if (match == null) {
            match = this.getUniqueBeanForClassName(bm, id);
        }
        return match;
    }

    protected Bean<?> getUniqueBeanByBeanName(BeanManager bm, String batchId) {
        Bean match;
        Set beans = bm.getBeans(batchId);
        try {
            match = bm.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            return null;
        }
        return match;
    }

    protected Bean<?> getUniqueBeanForBatchXMLEntry(BeanManager bm, String batchId) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        DefaultBatchArtifactFactory.ArtifactLocator artifactMap = this.createArtifactsLocator(tccl);
        Class<?> clazz = artifactMap.getArtifactClassById(batchId);
        if (clazz != null) {
            try {
                return this.findUniqueBeanForClass(bm, clazz);
            }
            catch (AmbiguousResolutionException e) {
                return null;
            }
        }
        return null;
    }

    protected Bean<?> getUniqueBeanForClassName(BeanManager bm, String className) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return this.findUniqueBeanForClass(bm, clazz);
        }
        catch (AmbiguousResolutionException e) {
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    protected Bean<?> findUniqueBeanForClass(BeanManager beanManager, Class<?> clazz) throws AmbiguousResolutionException {
        Bean retVal;
        HashSet<Bean> matches = new HashSet<Bean>();
        Set beans = beanManager.getBeans(clazz, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        for (Bean bean : beans) {
            if (!bean.getBeanClass().equals(clazz)) continue;
            matches.add(bean);
        }
        try {
            retVal = beanManager.resolve(matches);
        }
        catch (AmbiguousResolutionException e) {
            throw new AmbiguousResolutionException("Found beans = " + matches + ", and could not resolve unambiguously");
        }
        return retVal;
    }

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
    }

    protected BeanManager getBeanManager() {
        BatchCDIInjectionExtension instance = BatchCDIInjectionExtension.getInstance();
        if (instance == null) {
            return null;
        }
        return instance.getBeanManager();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

