/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.ConnectionPoolTimeoutException;
import org.apache.openejb.client.FlushableGZIPOutputStream;
import org.apache.openejb.client.KeepAliveStyle;
import org.apache.openejb.client.event.ConnectionOpened;
import org.apache.openejb.client.event.ConnectionPoolCreated;
import org.apache.openejb.client.event.ConnectionPoolTimeout;

public class SocketConnectionFactory
implements ConnectionFactory {
    private KeepAliveStyle keepAliveStyle = KeepAliveStyle.PING;
    public static final String PROPERTY_SOCKET_TIMEOUT = "openejb.client.connection.socket.timeout";
    public static final String PROPERTY_SOCKET_READ = "openejb.client.connection.socket.read";
    public static final String PROPERTY_POOL_TIMEOUT = "openejb.client.connection.pool.timeout";
    private static final String PROPERTY_POOL_TIMEOUT2 = "openejb.client.connectionpool.timeout";
    public static final String PROPERTY_POOL_SIZE = "openejb.client.connection.pool.size";
    private static final String PROPERTY_POOL_SIZE2 = "openejb.client.connectionpool.size";
    public static final String PROPERTY_KEEPALIVE = "openejb.client.keepalive";
    public static final String ENABLED_CIPHER_SUITES = "openejb.client.enabledCipherSuites";
    private static final Map<URI, Pool> connections = new ConcurrentHashMap<URI, Pool>();
    private int size = this.getSize();
    private long timeoutPool = this.getTimeoutPool();
    private int timeoutConnect = this.getTimeoutSocket();
    private int timeoutRead = 14400000;
    private int timeoutLinger = this.getTimeoutLinger();
    private String[] enabledCipherSuites;

    public SocketConnectionFactory() {
        this.timeoutRead = this.getTimeoutRead();
        this.enabledCipherSuites = this.getEnabledCipherSuites();
        try {
            String property = System.getProperty(PROPERTY_KEEPALIVE);
            if (property != null) {
                property = property.toUpperCase();
                this.keepAliveStyle = KeepAliveStyle.valueOf(property);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String[] getEnabledCipherSuites() {
        String property = System.getProperty(ENABLED_CIPHER_SUITES);
        if (property != null) {
            return property.split(",");
        }
        return new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"};
    }

    private long getTimeoutPool() {
        Properties p = System.getProperties();
        long timeout = SocketConnectionFactory.getLong(p, PROPERTY_POOL_TIMEOUT, this.timeoutPool);
        timeout = SocketConnectionFactory.getLong(p, PROPERTY_POOL_TIMEOUT2, timeout);
        return timeout;
    }

    private int getTimeoutLinger() {
        long pool = this.timeoutPool;
        if (pool < 1000L) {
            pool = 1000L;
        }
        return (int)(pool / 1000L);
    }

    private int getTimeoutSocket() {
        Properties p = System.getProperties();
        return SocketConnectionFactory.getInt(p, PROPERTY_SOCKET_TIMEOUT, this.timeoutConnect);
    }

    private int getTimeoutRead() {
        Properties p = System.getProperties();
        return SocketConnectionFactory.getInt(p, PROPERTY_SOCKET_READ, this.timeoutRead);
    }

    private int getSize() {
        Properties p = System.getProperties();
        int size = SocketConnectionFactory.getInt(p, PROPERTY_POOL_SIZE, this.size);
        size = SocketConnectionFactory.getInt(p, PROPERTY_POOL_SIZE2, size);
        return size;
    }

    public static int getInt(Properties p, String property, int defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static long getLong(Properties p, String property, long defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Long.parseLong(value);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public Connection getConnection(URI uri) throws IOException {
        Pool pool = this.getPool(uri);
        SocketConnection conn = pool.get();
        if (conn == null) {
            try {
                conn = new SocketConnection(uri, pool);
                conn.open(uri);
            }
            catch (IOException e) {
                conn.cleanUp();
                pool.put(null);
                throw e;
            }
        }
        try {
            if (!conn.lock.tryLock(2L, TimeUnit.SECONDS)) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            pool.put(conn);
            throw new IOException("Connection busy");
        }
        OutputStream ouputStream = conn.getOutputStream();
        if (conn.socket.isClosed()) {
            pool.put(null);
            return this.getConnection(uri);
        }
        try {
            ouputStream.write(this.keepAliveStyle.ordinal());
            ouputStream.flush();
            switch (this.keepAliveStyle) {
                case PING_PING: {
                    ouputStream.write(this.keepAliveStyle.ordinal());
                    ouputStream.flush();
                    break;
                }
                case PING_PONG: {
                    conn.getInputStream().read();
                }
            }
        }
        catch (IOException e) {
            pool.put(null);
            throw e;
        }
        return conn;
    }

    private Pool getPool(URI uri) {
        Pool pool = connections.get(uri);
        if (pool == null) {
            pool = new Pool(uri, this.getSize(), this.timeoutPool);
            connections.put(uri, pool);
        }
        return pool;
    }

    private static class Pool {
        private final Semaphore semaphore;
        private final Stack<SocketConnection> pool;
        private final long timeout;
        private final TimeUnit timeUnit;
        private final int size;
        private final URI uri;

        private Pool(URI uri, int size, long timeout) {
            this.uri = uri;
            this.size = size;
            this.semaphore = new Semaphore(size);
            this.pool = new Stack();
            this.timeout = timeout;
            this.timeUnit = TimeUnit.MILLISECONDS;
            for (int i = 0; i < size; ++i) {
                this.pool.push(null);
            }
            Client.fireEvent(new ConnectionPoolCreated(uri, size, timeout, this.timeUnit));
        }

        public SocketConnection get() throws IOException {
            try {
                if (this.semaphore.tryAcquire(this.timeout, this.timeUnit)) {
                    return this.pool.pop();
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            ConnectionPoolTimeoutException exception = new ConnectionPoolTimeoutException("No connections available in pool (size " + this.size + ").  Waited for " + this.timeout + " milliseconds for a connection.");
            exception.fillInStackTrace();
            Client.fireEvent(new ConnectionPoolTimeout(this.uri, this.size, this.timeout, this.timeUnit, exception));
            throw exception;
        }

        public void put(SocketConnection connection) {
            this.pool.push(connection);
            this.semaphore.release();
        }

        public String toString() {
            return "Pool{size=" + this.size + ", available=" + this.semaphore.availablePermits() + ", uri=" + String.valueOf(this.uri) + "}";
        }
    }

    class SocketConnection
    implements Connection {
        private Socket socket = null;
        private final URI uri;
        private boolean discarded;
        private final Pool pool;
        private final Lock lock = new ReentrantLock();
        private OutputStream out;
        private InputStream in;
        private boolean gzip = false;

        public SocketConnection(URI uri, Pool pool) {
            this.uri = uri;
            this.pool = pool;
        }

        protected void finalize() throws Throwable {
            try {
                this.cleanUp();
            }
            finally {
                super.finalize();
            }
        }

        private void cleanUp() {
            if (null != this.in) {
                try {
                    this.in.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.out) {
                try {
                    this.out.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.socket) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        protected void open(URI uri) throws IOException {
            InetSocketAddress address = new InetSocketAddress(uri.getHost(), uri.getPort());
            try {
                String scheme = uri.getScheme();
                if (scheme.equalsIgnoreCase("ejbds") || scheme.equalsIgnoreCase("zejbds")) {
                    SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
                    this.socket = sslSocket;
                    sslSocket.setEnabledCipherSuites(SocketConnectionFactory.this.enabledCipherSuites);
                } else {
                    this.socket = new Socket();
                }
                if (scheme.startsWith("z")) {
                    this.gzip = true;
                }
                this.socket.setTcpNoDelay(true);
                this.socket.setSoLinger(true, SocketConnectionFactory.this.timeoutLinger);
                this.socket.connect(address, SocketConnectionFactory.this.timeoutConnect);
                this.socket.setSoTimeout(SocketConnectionFactory.this.timeoutRead);
                Client.fireEvent(new ConnectionOpened(uri));
            }
            catch (ConnectException e) {
                throw this.failure("Cannot connect to server '" + uri.toString() + "'.  Check that the server is started and that the specified serverURL is correct.", e);
            }
            catch (IOException e) {
                throw this.failure("Cannot connect to server: '" + uri.toString() + "'.  Exception: " + e.getClass().getName() + " : " + e.getMessage(), e);
            }
            catch (SecurityException e) {
                throw this.failure("Cannot access server: '" + uri.toString() + "' due to security restrictions in the current VM: " + e.getClass().getName() + " : " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw this.failure("Cannot  connect to server: '" + uri.toString() + "' due to an unknown exception in the OpenEJB client: " + e.getClass().getName() + " : " + e.getMessage(), e);
            }
        }

        private IOException failure(String err, Throwable e) {
            this.discard();
            return new IOException(err, e);
        }

        @Override
        public void discard() {
            try {
                this.pool.put(null);
            }
            finally {
                this.discarded = true;
                this.cleanUp();
            }
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void close() throws IOException {
            if (this.discarded) {
                return;
            }
            this.pool.put(this);
            try {
                this.lock.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                if (this.in == null) {
                    this.in = !this.gzip ? new BufferedInputStream(this.socket.getInputStream()) : new GZIPInputStream(new BufferedInputStream(this.socket.getInputStream()));
                }
                return new Input(this.in);
            }
            catch (StreamCorruptedException e) {
                throw this.failure("Cannot open input stream to server, the stream has been corrupted: " + e.getClass().getName(), e);
            }
            catch (IOException e) {
                throw this.failure("Cannot open input stream to server: " + e.getClass().getName(), e);
            }
            catch (Throwable e) {
                throw this.failure("Cannot open output stream to server: " + e.getClass().getName(), e);
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            try {
                if (this.out == null) {
                    this.out = !this.gzip ? new BufferedOutputStream(this.socket.getOutputStream()) : new BufferedOutputStream(new FlushableGZIPOutputStream(this.socket.getOutputStream()));
                }
                return new Output(this.out);
            }
            catch (Throwable e) {
                throw this.failure("Cannot open output stream to server: " + e.getClass().getName(), e);
            }
        }
    }

    public class Output
    extends FilterOutputStream {
        public Output(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    public class Input
    extends FilterInputStream {
        public Input(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

