/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.Decoder;
import io.churchkey.Key;
import io.churchkey.pem.BeginDsaPrivateKey;
import io.churchkey.pem.BeginEcPrivateKey;
import io.churchkey.pem.BeginPrivateKey;
import io.churchkey.pem.BeginPublicKey;
import io.churchkey.pem.BeginRsaPrivateKey;
import io.churchkey.pem.BeginRsaPublicKey;
import io.churchkey.util.Pem;
import io.churchkey.util.Utils;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PemParser
implements Key.Format.Parser {
    private final PemDecoder decoder = new PemDecoder();

    @Override
    public Key decode(byte[] bytes) {
        return this.decoder.decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        switch (key.getType()) {
            case PUBLIC: {
                return BeginPublicKey.encode(key);
            }
            case PRIVATE: {
                return BeginPrivateKey.encode(key);
            }
            case SECRET: {
                throw new UnsupportedOperationException("Secret keys cannot be exported to PEM format.");
            }
        }
        throw new UnsupportedOperationException("Unsupported key type: " + (Object)((Object)key.getType()));
    }

    public static class PemDecoder
    implements Decoder {
        private final Map<String, Function<byte[], Key>> converters = new HashMap<String, Function<byte[], Key>>();

        public PemDecoder() {
            this.converters.put("PRIVATE KEY", BeginPrivateKey::decode);
            this.converters.put("PUBLIC KEY", BeginPublicKey::decode);
            this.converters.put("RSA PRIVATE KEY", BeginRsaPrivateKey::decode);
            this.converters.put("RSA PUBLIC KEY", BeginRsaPublicKey::decode);
            this.converters.put("DSA PRIVATE KEY", BeginDsaPrivateKey::decode);
            this.converters.put("EC PRIVATE KEY", BeginEcPrivateKey::decode);
        }

        @Override
        public Key decode(byte[] key) {
            if (Utils.startsWith("-----", key)) {
                Pem pem = Pem.parse(key);
                Function<byte[], Key> converter = this.converters.get(pem.getType());
                if (converter == null) {
                    throw new UnsupportedOperationException(String.format("Unsupported PEM format '%s'", pem.getType()));
                }
                return converter.apply(pem.getData());
            }
            if (Utils.startsWith("MI", key) || Utils.startsWith("MF", key)) {
                byte[] decoded = Base64.getDecoder().decode(key);
                for (Function<byte[], Key> converter : this.converters.values()) {
                    try {
                        return converter.apply(decoded);
                    }
                    catch (Exception exception) {
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported PEM base64 bytes '%s'", new String(key)));
            }
            return null;
        }
    }
}

