/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitioner;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoring;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoringCmax;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoringCmin;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFixedsize;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerNaive;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerStatic;
import org.apache.sysds.runtime.instructions.cp.IntObject;

public class TaskPartitionerFactory {
    public static TaskPartitioner createTaskPartitioner(ParForProgramBlock.PTaskPartitioner type, IntObject from, IntObject to, IntObject incr, long taskSize, int numThreads, String iterPredVar) {
        switch (type) {
            case FIXED: {
                return new TaskPartitionerFixedsize(taskSize, iterPredVar, from, to, incr);
            }
            case NAIVE: {
                return new TaskPartitionerNaive(taskSize, iterPredVar, from, to, incr);
            }
            case STATIC: {
                return new TaskPartitionerStatic(taskSize, numThreads, iterPredVar, from, to, incr);
            }
            case FACTORING: {
                return new TaskPartitionerFactoring(taskSize, numThreads, iterPredVar, from, to, incr);
            }
            case FACTORING_CMIN: {
                return new TaskPartitionerFactoringCmin(taskSize, numThreads, taskSize, iterPredVar, from, to, incr);
            }
            case FACTORING_CMAX: {
                return new TaskPartitionerFactoringCmax(taskSize, numThreads, taskSize, iterPredVar, from, to, incr);
            }
        }
        throw new DMLRuntimeException("Undefined task partitioner: '" + type + "'.");
    }
}

