/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;

public class DblArrayIntListHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DblArrayIntListHashMap.class.getName());
    protected static final int INIT_CAPACITY = 8;
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.8f;
    protected int _size;
    protected DArrayIListEntry[] _data;

    public DblArrayIntListHashMap() {
        this._data = new DArrayIListEntry[8];
        this._size = 0;
    }

    public DblArrayIntListHashMap(int init_capacity) {
        this._data = new DArrayIListEntry[Util.getPow2(init_capacity)];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public IntArrayList get(DblArray key) {
        int hash = key.hashCode();
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        return this._data[ix] == null ? null : this._data[ix].get(key);
    }

    public void appendValue(DblArray key, int value) {
        int hash = key.hashCode();
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        if (this._data[ix] == null) {
            this._data[ix] = new DArrayIListEntry(new DblArray(key), value);
            ++this._size;
        } else if (this._data[ix].add(key, value)) {
            ++this._size;
        }
        if ((float)this._size >= 0.8f * (float)this._data.length) {
            this.resize();
        }
    }

    public List<DArrayIListEntry> extractValues() {
        ArrayList<DArrayIListEntry> ret = new ArrayList<DArrayIListEntry>();
        for (DArrayIListEntry e : this._data) {
            while (e != null) {
                ret.add(e);
                e = e.next;
            }
        }
        return ret;
    }

    private void resize() {
        DArrayIListEntry[] olddata = this._data;
        this._data = new DArrayIListEntry[this._data.length * 2];
        this._size = 0;
        for (DArrayIListEntry e : olddata) {
            while (e != null) {
                this.reinsert(e.key, e.value);
                e = e.next;
            }
        }
    }

    private void reinsert(DblArray key, IntArrayList value) {
        int hash = key.hashCode();
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        if (this._data[ix] == null) {
            this._data[ix] = new DArrayIListEntry(key, value);
            ++this._size;
        } else {
            this._data[ix].reinsert(key, value);
            ++this._size;
        }
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("   " + this._size);
        for (int i = 0; i < this._data.length; ++i) {
            DArrayIListEntry ent = this._data[i];
            if (ent == null) continue;
            sb.append("\n");
            sb.append("[");
            ent.toString(sb);
            sb.append("]");
        }
        return sb.toString();
    }

    public static class DArrayIListEntry {
        public final DblArray key;
        public final IntArrayList value;
        private DArrayIListEntry next;

        private DArrayIListEntry(DblArray key, int value) {
            this.key = key;
            this.value = new IntArrayList();
            this.value.appendValue(value);
            this.next = null;
        }

        private DArrayIListEntry(DblArray key, IntArrayList value) {
            this.key = key;
            this.value = value;
            this.next = null;
        }

        private final boolean reinsert(DblArray key, IntArrayList value) {
            DArrayIListEntry e = this;
            while (e.next != null) {
                e = e.next;
            }
            e.next = new DArrayIListEntry(key, value);
            return true;
        }

        private final boolean add(DblArray key, int value) {
            DArrayIListEntry e = this;
            if (e.key.equals(key)) {
                this.value.appendValue(value);
                return false;
            }
            while (e.next != null) {
                e = e.next;
                if (!e.key.equals(key)) continue;
                e.value.appendValue(value);
                return false;
            }
            e.next = new DArrayIListEntry(new DblArray(key), new IntArrayList());
            e.next.value.appendValue(value);
            return true;
        }

        private IntArrayList get(DblArray key) {
            DArrayIListEntry e = this;
            boolean eq = e.key.equals(key);
            while (e.next != null && !eq) {
                e = e.next;
                eq = e.key.equals(key);
            }
            return eq ? e.value : null;
        }

        private void toString(StringBuilder sb) {
            DArrayIListEntry e = this;
            while (e != null) {
                sb.append(e.key);
                sb.append(":");
                sb.append(e.value);
                if (e.next != null) {
                    sb.append(" -> ");
                }
                e = e.next;
            }
        }
    }
}

