/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ExecutorResourceRequest$;
import org.apache.spark.resource.ResourceProfile$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\b\u0011\u0001eAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u0004B\u0001\u0001\u0006I!\u000b\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006#\u0002!\tA\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00065\u0002!\ta\u0017\u0005\u0006#\u0001!\t\u0001\u0019\u0005\bW\u0002\t\n\u0011\"\u0001m\u0011\u001d9\b!%A\u0005\u00021DQ\u0001\u001f\u0001\u0005Be\u0014\u0001$\u0012=fGV$xN\u001d*fg>,(oY3SKF,Xm\u001d;t\u0015\t\t\"#\u0001\u0005sKN|WO]2f\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003A\t!cX3yK\u000e,Ho\u001c:SKN|WO]2fgV\t\u0011\u0006\u0005\u0003+cMrT\"A\u0016\u000b\u00051j\u0013AC2p]\u000e,(O]3oi*\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005IZ#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\u000f\u000e\u0003]R!\u0001\u000f\r\u0002\rq\u0012xn\u001c;?\u0013\tQD$\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u001d!\t1s(\u0003\u0002A!\t9R\t_3dkR|'OU3t_V\u00148-\u001a*fcV,7\u000f^\u0001\u0014?\u0016DXmY;u_J\u0014Vm]8ve\u000e,7\u000fI\u0001\te\u0016\fX/Z:ugV\tA\t\u0005\u00035\u000bNr\u0014B\u0001$>\u0005\ri\u0015\r]\u0001\re\u0016\fX/Z:ug*k\u0015\r]\u000b\u0002\u0013B!!jS\u001a?\u001b\u0005i\u0013B\u0001$.\u0003\u0019iW-\\8ssR\u0011ajT\u0007\u0002\u0001!)\u0001K\u0002a\u0001g\u00051\u0011-\\8v]R\fQb\u001c4g\u0011\u0016\f\u0007/T3n_JLHC\u0001(T\u0011\u0015\u0001v\u00011\u00014\u00039iW-\\8ss>3XM\u001d5fC\u0012$\"A\u0014,\t\u000bAC\u0001\u0019A\u001a\u0002\u001bAL8\u000f]1sW6+Wn\u001c:z)\tq\u0015\fC\u0003Q\u0013\u0001\u00071'A\u0003d_J,7\u000f\u0006\u0002O9\")\u0001K\u0003a\u0001;B\u00111DX\u0005\u0003?r\u00111!\u00138u)\u0015q\u0015mY4j\u0011\u0015\u00117\u00021\u00014\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u0015\u00016\u00021\u0001e!\tYR-\u0003\u0002g9\t!Aj\u001c8h\u0011\u001dA7\u0002%AA\u0002M\nq\u0002Z5tG>4XM]=TGJL\u0007\u000f\u001e\u0005\bU.\u0001\n\u00111\u00014\u0003\u00191XM\u001c3pe\u0006\u0011\"/Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005i'FA\u001aoW\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003%)hn\u00195fG.,GM\u0003\u0002u9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\f(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\"/Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135\u0003!!xn\u0015;sS:<G#A\u001a)\t\u0001Y\u0018\u0011\u0001\t\u0003yzl\u0011! \u0006\u0003iJI!a`?\u0003\u000bMKgnY3\"\u0005\u0005\r\u0011!B\u001a/c9\u0002\u0004f\u0001\u0001\u0002\bA\u0019A0!\u0003\n\u0007\u0005-QP\u0001\u0005Fm>dg/\u001b8h\u0001")
public class ExecutorResourceRequests
implements Serializable {
    private final ConcurrentHashMap<String, ExecutorResourceRequest> _executorResources = new ConcurrentHashMap();

    private ConcurrentHashMap<String, ExecutorResourceRequest> _executorResources() {
        return this._executorResources;
    }

    public scala.collection.immutable.Map<String, ExecutorResourceRequest> requests() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this._executorResources()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, ExecutorResourceRequest> requestsJMap() {
        return (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.requests()).asJava();
    }

    public ExecutorResourceRequests memory(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.MEMORY(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.MEMORY(), req);
        return this;
    }

    public ExecutorResourceRequests offHeapMemory(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.OFFHEAP_MEM(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.OFFHEAP_MEM(), req);
        return this;
    }

    public ExecutorResourceRequests memoryOverhead(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.OVERHEAD_MEM(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.OVERHEAD_MEM(), req);
        return this;
    }

    public ExecutorResourceRequests pysparkMemory(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.PYSPARK_MEM(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.PYSPARK_MEM(), req);
        return this;
    }

    public ExecutorResourceRequests cores(int amount) {
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.CORES(), amount, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.CORES(), req);
        return this;
    }

    public ExecutorResourceRequests resource(String resourceName, long amount, String discoveryScript, String vendor) {
        ExecutorResourceRequest req = new ExecutorResourceRequest(resourceName, amount, discoveryScript, vendor);
        this._executorResources().put(resourceName, req);
        return this;
    }

    public String resource$default$3() {
        return "";
    }

    public String resource$default$4() {
        return "";
    }

    public String toString() {
        return new StringBuilder(28).append("Executor resource requests: ").append(this._executorResources()).toString();
    }
}

