/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.telemetry.internals.KafkaMetricsCollector;
import org.apache.kafka.common.telemetry.internals.MetricNamingStrategy;
import org.apache.kafka.common.telemetry.internals.MetricsEmitter;
import org.apache.kafka.common.telemetry.internals.SinglePointMetric;
import org.apache.kafka.common.telemetry.internals.TelemetryMetricNamingConvention;
import org.apache.kafka.common.telemetry.internals.TestEmitter;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KafkaMetricsCollectorTest {
    private static final String DOMAIN = "test.domain";
    private MetricName metricName;
    private Map<String, String> tags;
    private Metrics metrics;
    private MetricNamingStrategy<MetricName> metricNamingStrategy;
    private KafkaMetricsCollector collector;
    private TestEmitter testEmitter;
    private MockTime time;

    @BeforeEach
    public void setUp() {
        this.metrics = new Metrics();
        this.tags = Collections.singletonMap("tag", "value");
        this.metricName = this.metrics.metricName("name1", "group1", this.tags);
        this.time = new MockTime(0L, 1000L, TimeUnit.MILLISECONDS.toNanos(1000L));
        this.testEmitter = new TestEmitter();
        this.metricNamingStrategy = TelemetryMetricNamingConvention.getClientTelemetryMetricNamingStrategy((String)DOMAIN);
        this.collector = new KafkaMetricsCollector(this.metricNamingStrategy, (Time)this.time, Collections.emptySet());
        this.metrics.addReporter(this.getTestMetricsReporter());
    }

    @Test
    public void testMeasurableCounter() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new WindowedCount());
        sensor.record();
        sensor.record();
        this.time.sleep(60000L);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric counter = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        Assertions.assertTrue((boolean)counter.hasSum());
        Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(counter.getSum().getDataPoints(0).getAttributesList()));
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)counter.getSum().getAggregationTemporality());
        Assertions.assertTrue((boolean)counter.getSum().getIsMonotonic());
        NumberDataPoint point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)2.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(61L).getEpochSecond()) + (long)Instant.ofEpochSecond(61L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(1L).getEpochSecond()) + (long)Instant.ofEpochSecond(1L).getNano()), (long)point.getStartTimeUnixNano());
    }

    @Test
    public void testMeasurableCounterDeltaMetrics() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new WindowedCount());
        sensor.record();
        sensor.record();
        this.time.sleep(60000L);
        this.testEmitter.onlyDeltaMetrics(true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric counter = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        Assertions.assertTrue((boolean)counter.hasSum());
        Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(counter.getSum().getDataPoints(0).getAttributesList()));
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, (Object)counter.getSum().getAggregationTemporality());
        Assertions.assertTrue((boolean)counter.getSum().getIsMonotonic());
        NumberDataPoint point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)2.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(61L).getEpochSecond()) + (long)Instant.ofEpochSecond(61L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(1L).getEpochSecond()) + (long)Instant.ofEpochSecond(1L).getNano()), (long)point.getStartTimeUnixNano());
    }

    @Test
    public void testMeasurableTotal() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new CumulativeSum());
        sensor.record(10.0);
        sensor.record(5.0);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric counter = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        Assertions.assertTrue((boolean)counter.hasSum());
        Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(counter.getSum().getDataPoints(0).getAttributesList()));
        Assertions.assertEquals((double)15.0, (double)counter.getSum().getDataPoints(0).getAsDouble(), (double)0.0);
    }

    @Test
    public void testMeasurableTotalDeltaMetrics() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new CumulativeSum());
        sensor.record(10.0);
        sensor.record(5.0);
        this.testEmitter.onlyDeltaMetrics(true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric counter = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        Assertions.assertTrue((boolean)counter.hasSum());
        Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(counter.getSum().getDataPoints(0).getAttributesList()));
        Assertions.assertEquals((double)15.0, (double)counter.getSum().getDataPoints(0).getAsDouble(), (double)0.0);
    }

    @Test
    public void testMeasurableGauge() {
        this.metrics.addMetric(this.metricName, (config, now) -> 100.0);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric counter = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        Assertions.assertTrue((boolean)counter.hasGauge());
        Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(counter.getGauge().getDataPoints(0).getAttributesList()));
        Assertions.assertEquals((double)100.0, (double)counter.getGauge().getDataPoints(0).getAsDouble(), (double)0.0);
    }

    @Test
    public void testNonMeasurable() {
        this.metrics.addMetric(this.metrics.metricName("float", "group1", this.tags), (MetricValueProvider)((Gauge)(config, now) -> Float.valueOf(99.0f)));
        this.metrics.addMetric(this.metrics.metricName("double", "group1", this.tags), (MetricValueProvider)((Gauge)(config, now) -> 99.0));
        this.metrics.addMetric(this.metrics.metricName("int", "group1", this.tags), (MetricValueProvider)((Gauge)(config, now) -> 100));
        this.metrics.addMetric(this.metrics.metricName("long", "group1", this.tags), (MetricValueProvider)((Gauge)(config, now) -> 100L));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)5, (int)result.size());
        result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.(float|double)")).forEach(doubleGauge -> {
            Assertions.assertTrue((boolean)doubleGauge.hasGauge());
            Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(doubleGauge.getGauge().getDataPoints(0).getAttributesList()));
            Assertions.assertEquals((double)99.0, (double)doubleGauge.getGauge().getDataPoints(0).getAsDouble(), (double)0.0);
        });
        result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.(int|long)")).forEach(intGauge -> {
            Assertions.assertTrue((boolean)intGauge.hasGauge());
            Assertions.assertEquals(this.tags, KafkaMetricsCollectorTest.getTags(intGauge.getGauge().getDataPoints(0).getAttributesList()));
            Assertions.assertEquals((double)100.0, (double)intGauge.getGauge().getDataPoints(0).getAsDouble(), (double)0.0);
        });
    }

    @Test
    public void testMeasurableWithException() {
        this.metrics.addMetric(this.metricName, null, (config, now) -> {
            throw new RuntimeException();
        });
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"test.domain.kafka.count.count", (Object)result.get(0).builder().build().getName());
        Assertions.assertFalse((boolean)result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).anyMatch(metric -> metric.getName().equals("test.domain.group1.name1")));
    }

    @Test
    public void testMetricRemoval() {
        this.metrics.addMetric(this.metricName, (config, now) -> 100.0);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        Assertions.assertEquals((int)2, (int)this.testEmitter.emittedMetrics().size());
        this.metrics.removeMetric(this.metricName);
        Assertions.assertFalse((boolean)this.collector.getTrackedMetrics().contains(this.metricNamingStrategy.metricKey((Object)this.metricName)));
        this.testEmitter.reset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> collected = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)1, (int)collected.size());
        Assertions.assertEquals((Object)"test.domain.kafka.count.count", (Object)collected.get(0).builder().build().getName());
    }

    @Test
    public void testSecondCollectCumulative() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new CumulativeSum());
        sensor.record();
        sensor.record();
        this.time.sleep(60000L);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        sensor.record();
        sensor.record();
        sensor.record();
        sensor.record();
        sensor.record();
        this.time.sleep(60000L);
        this.testEmitter.reset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric cumulative = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        NumberDataPoint point = cumulative.getSum().getDataPoints(0);
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)cumulative.getSum().getAggregationTemporality());
        Assertions.assertTrue((boolean)cumulative.getSum().getIsMonotonic());
        Assertions.assertEquals((double)7.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(121L).getEpochSecond()) + (long)Instant.ofEpochSecond(121L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(1L).getEpochSecond()) + (long)Instant.ofEpochSecond(1L).getNano()), (long)point.getStartTimeUnixNano());
    }

    @Test
    public void testSecondDeltaCollectDouble() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new CumulativeSum());
        sensor.record();
        sensor.record();
        this.time.sleep(60000L);
        this.testEmitter.onlyDeltaMetrics(true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        sensor.record();
        sensor.record();
        sensor.record();
        sensor.record();
        sensor.record();
        this.time.sleep(60000L);
        this.testEmitter.reset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)2, (int)result.size());
        Metric cumulative = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(metric -> metric.getName().equals("test.domain.group1.name1")).findFirst().get();
        NumberDataPoint point = cumulative.getSum().getDataPoints(0);
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, (Object)cumulative.getSum().getAggregationTemporality());
        Assertions.assertTrue((boolean)cumulative.getSum().getIsMonotonic());
        Assertions.assertEquals((double)5.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(121L).getEpochSecond()) + (long)Instant.ofEpochSecond(121L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(61L).getEpochSecond()) + (long)Instant.ofEpochSecond(61L).getNano()), (long)point.getStartTimeUnixNano());
    }

    @Test
    public void testCollectFilter() {
        this.metrics.addMetric(this.metricName, (config, now) -> 100.0);
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".count"));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)1, (int)result.size());
        Metric counter = result.get(0).builder().build();
        Assertions.assertTrue((boolean)counter.hasGauge());
        Assertions.assertEquals((double)100.0, (double)counter.getGauge().getDataPoints(0).getAsDouble(), (double)0.0);
    }

    @Test
    public void testCollectFilterWithCumulativeTemporality() {
        MetricName name1 = this.metrics.metricName("nonMeasurable", "group1", this.tags);
        MetricName name2 = this.metrics.metricName("windowed", "group1", this.tags);
        MetricName name3 = this.metrics.metricName("cumulative", "group1", this.tags);
        this.metrics.addMetric(name1, (MetricValueProvider)((Gauge)(config, now) -> 99.0));
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(name2, (MeasurableStat)new WindowedCount());
        sensor.add(name3, (MeasurableStat)new CumulativeSum());
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)4, (int)result.size());
        this.testEmitter.reset();
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".count"));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)3, (int)result.size());
        this.testEmitter.reset();
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".nonmeasurable"));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)3, (int)result.size());
        this.testEmitter.reset();
        this.testEmitter.reconfigurePredicate(key -> true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)4, (int)result.size());
    }

    @Test
    public void testCollectFilterWithDeltaTemporality() {
        MetricName name1 = this.metrics.metricName("nonMeasurable", "group1", this.tags);
        MetricName name2 = this.metrics.metricName("windowed", "group1", this.tags);
        MetricName name3 = this.metrics.metricName("cumulative", "group1", this.tags);
        this.metrics.addMetric(name1, (MetricValueProvider)((Gauge)(config, now) -> 99.0));
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(name2, (MeasurableStat)new WindowedCount());
        sensor.add(name3, (MeasurableStat)new CumulativeSum());
        this.testEmitter.onlyDeltaMetrics(true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)4, (int)result.size());
        this.testEmitter.reset();
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".count"));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)3, (int)result.size());
        this.testEmitter.reset();
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".nonmeasurable"));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)3, (int)result.size());
        this.testEmitter.reset();
        this.testEmitter.reconfigurePredicate(key -> true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        Assertions.assertEquals((int)4, (int)result.size());
    }

    @Test
    public void testCollectMetricsWithTemporalityChange() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metricName, (MeasurableStat)new WindowedCount());
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".count"));
        sensor.record();
        this.time.sleep(60000L);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Metric counter = result.get(0).builder().build();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)counter.getSum().getAggregationTemporality());
        NumberDataPoint point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(61L).getEpochSecond()) + (long)Instant.ofEpochSecond(61L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(1L).getEpochSecond()) + (long)Instant.ofEpochSecond(1L).getNano()), (long)point.getStartTimeUnixNano());
        this.time.sleep(60000L);
        sensor.record();
        this.testEmitter.reset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        counter = result.get(0).builder().build();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)counter.getSum().getAggregationTemporality());
        point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)2.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(121L).getEpochSecond()) + (long)Instant.ofEpochSecond(121L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(1L).getEpochSecond()) + (long)Instant.ofEpochSecond(1L).getNano()), (long)point.getStartTimeUnixNano());
        this.time.sleep(60000L);
        sensor.record();
        this.testEmitter.reset();
        this.testEmitter.onlyDeltaMetrics(true);
        this.collector.metricsReset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        counter = result.get(0).builder().build();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, (Object)counter.getSum().getAggregationTemporality());
        point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)3.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(181L).getEpochSecond()) + (long)Instant.ofEpochSecond(181L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(181L).getEpochSecond()) + (long)Instant.ofEpochSecond(181L).getNano()), (long)point.getStartTimeUnixNano());
        this.time.sleep(60000L);
        sensor.record();
        this.testEmitter.reset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        counter = result.get(0).builder().build();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, (Object)counter.getSum().getAggregationTemporality());
        point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(241L).getEpochSecond()) + (long)Instant.ofEpochSecond(241L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(181L).getEpochSecond()) + (long)Instant.ofEpochSecond(181L).getNano()), (long)point.getStartTimeUnixNano());
        this.time.sleep(60000L);
        sensor.record();
        this.testEmitter.reset();
        this.testEmitter.onlyDeltaMetrics(false);
        this.collector.metricsReset();
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        counter = result.get(0).builder().build();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)counter.getSum().getAggregationTemporality());
        point = counter.getSum().getDataPoints(0);
        Assertions.assertEquals((double)5.0, (double)point.getAsDouble(), (double)0.0);
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(301L).getEpochSecond()) + (long)Instant.ofEpochSecond(301L).getNano()), (long)point.getTimeUnixNano());
        Assertions.assertEquals((long)(TimeUnit.SECONDS.toNanos(Instant.ofEpochSecond(301L).getEpochSecond()) + (long)Instant.ofEpochSecond(301L).getNano()), (long)point.getStartTimeUnixNano());
    }

    @Test
    public void testCollectMetricsWithExcludeLabels() {
        this.collector = new KafkaMetricsCollector(this.metricNamingStrategy, (Time)this.time, Collections.singleton("tag2"));
        this.tags = new HashMap<String, String>();
        this.tags.put("tag1", "value1");
        this.tags.put("tag2", "value2");
        MetricName name1 = this.metrics.metricName("nonMeasurable", "group1", this.tags);
        this.metrics.addMetric(name1, (MetricValueProvider)((Gauge)(config, now) -> 99.0));
        MetricName name2 = this.metrics.metricName("counter", "group1", this.tags);
        Sensor sensor = this.metrics.sensor("counter");
        sensor.add(name2, (MeasurableStat)new WindowedCount());
        sensor.record();
        this.testEmitter.reconfigurePredicate(k -> !k.key().name().endsWith(".count"));
        this.collector.collect((MetricsEmitter)this.testEmitter);
        List<SinglePointMetric> result = this.testEmitter.emittedMetrics();
        Metric metric = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(m -> m.getName().equals("test.domain.group1.nonmeasurable")).findFirst().get();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        NumberDataPoint point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag1", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value1", (Object)point.getAttributes(0).getValue().getStringValue());
        metric = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(m -> m.getName().equals("test.domain.group1.counter")).findFirst().get();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)metric.getSum().getAggregationTemporality());
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag1", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value1", (Object)point.getAttributes(0).getValue().getStringValue());
        this.testEmitter.reset();
        this.testEmitter.onlyDeltaMetrics(true);
        this.collector.collect((MetricsEmitter)this.testEmitter);
        result = this.testEmitter.emittedMetrics();
        metric = result.stream().flatMap(metrics -> Stream.of(metrics.builder().build())).filter(m -> m.getName().equals("test.domain.group1.counter")).findFirst().get();
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, (Object)metric.getSum().getAggregationTemporality());
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag1", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value1", (Object)point.getAttributes(0).getValue().getStringValue());
    }

    private MetricsReporter getTestMetricsReporter() {
        return new MetricsReporter(){

            public void init(List<KafkaMetric> metrics) {
                KafkaMetricsCollectorTest.this.collector.init(metrics);
            }

            public void metricChange(KafkaMetric metric) {
                KafkaMetricsCollectorTest.this.collector.metricChange(metric);
            }

            public void metricRemoval(KafkaMetric metric) {
                KafkaMetricsCollectorTest.this.collector.metricRemoval(metric);
            }

            public void close() {
            }

            public void configure(Map<String, ?> configs) {
            }
        };
    }

    public static Map<String, String> getTags(List<KeyValue> attributes) {
        return attributes.stream().filter(attr -> attr.getValue().hasStringValue()).collect(Collectors.toMap(KeyValue::getKey, attr -> attr.getValue().getStringValue()));
    }
}

