/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow.fingerprint;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintExtractor;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieDeviceFingerprintExtractor
implements DeviceFingerprintExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieDeviceFingerprintExtractor.class);
    private final CasCookieBuilder cookieGenerator;
    private final RandomStringGenerator randomStringGenerator;
    private int order = Integer.MAX_VALUE;

    @Override
    public Optional<String> extract(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        String cookieValue = Optional.ofNullable(this.cookieGenerator.retrieveCookieValue(request)).orElseGet(() -> {
            String newFingerprint = this.createDeviceFingerPrintCookieValue().get();
            this.cookieGenerator.addCookie(request, response, newFingerprint);
            LOGGER.debug("Added device fingerprint cookie value [{}]", (Object)newFingerprint);
            return newFingerprint;
        });
        LOGGER.debug("Device fingerprint cookie value is [{}]", (Object)cookieValue);
        return Optional.of(cookieValue);
    }

    protected Supplier<String> createDeviceFingerPrintCookieValue() {
        return () -> ((RandomStringGenerator)this.randomStringGenerator).getNewString();
    }

    @Generated
    public CasCookieBuilder getCookieGenerator() {
        return this.cookieGenerator;
    }

    @Generated
    public RandomStringGenerator getRandomStringGenerator() {
        return this.randomStringGenerator;
    }

    @Override
    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public CookieDeviceFingerprintExtractor(CasCookieBuilder cookieGenerator, RandomStringGenerator randomStringGenerator) {
        this.cookieGenerator = cookieGenerator;
        this.randomStringGenerator = randomStringGenerator;
    }
}

