/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

class AspectJMethodMatcher
implements MethodMatcher,
ClassFilter,
Pointcut {
    private static final PointcutParser parser;
    private final PointcutExpression expression;

    AspectJMethodMatcher(String expression) {
        this.expression = parser.parsePointcutExpression(expression);
    }

    public boolean matches(Class<?> clazz) {
        return this.expression.couldMatchJoinPointsInType(clazz);
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return this.expression.matchesMethodExecution(method).alwaysMatches();
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean matches(Method method, Class<?> targetClass, Object ... args) {
        return this.matches(method, targetClass);
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        return this;
    }

    static {
        HashSet<PointcutPrimitive> supportedPrimitives = new HashSet<PointcutPrimitive>(3);
        supportedPrimitives.add(PointcutPrimitive.EXECUTION);
        supportedPrimitives.add(PointcutPrimitive.ARGS);
        supportedPrimitives.add(PointcutPrimitive.REFERENCE);
        parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution(supportedPrimitives);
    }
}

