/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.QueryOperator;
import org.flowable.variable.service.impl.VariableServiceConfigurationVariableValueProvider;
import org.flowable.variable.service.impl.VariableValueProvider;
import org.flowable.variable.service.impl.types.ByteArrayType;
import org.flowable.variable.service.impl.types.JPAEntityListVariableType;
import org.flowable.variable.service.impl.types.JPAEntityVariableType;

public class QueryVariableValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Object value;
    private QueryOperator operator;
    private ValueFields valueField;
    private VariableType valueType;
    private boolean local;
    private String scopeType;

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local) {
        this.name = name;
        this.value = value;
        this.operator = operator;
        this.local = local;
    }

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local, String scopeType) {
        this(name, value, operator, local);
        this.scopeType = scopeType;
    }

    public void initialize(VariableValueProvider valueProvider) {
        if (this.valueField == null) {
            this.valueType = valueProvider.findVariableType(this.value);
            if (this.valueType instanceof ByteArrayType) {
                throw new FlowableIllegalArgumentException("Variables of type ByteArray cannot be used to query");
            }
            if (this.valueType instanceof JPAEntityVariableType && this.operator != QueryOperator.EQUALS) {
                throw new FlowableIllegalArgumentException("JPA entity variables can only be used in 'variableValueEquals'");
            }
            if (this.valueType instanceof JPAEntityListVariableType) {
                throw new FlowableIllegalArgumentException("Variables containing a list of JPA entities cannot be used to query");
            }
            this.valueField = valueProvider.createValueFields(this.name, this.valueType, this.value);
        }
    }

    public void initialize(VariableServiceConfiguration variableServiceConfiguration) {
        this.initialize(new VariableServiceConfigurationVariableValueProvider(variableServiceConfiguration));
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        if (this.operator != null) {
            return this.operator.toString();
        }
        return QueryOperator.EQUALS.toString();
    }

    public String getTextValue() {
        if (this.valueField != null) {
            return this.valueField.getTextValue();
        }
        return null;
    }

    public Long getLongValue() {
        if (this.valueField != null) {
            return this.valueField.getLongValue();
        }
        return null;
    }

    public Double getDoubleValue() {
        if (this.valueField != null) {
            return this.valueField.getDoubleValue();
        }
        return null;
    }

    public String getTextValue2() {
        if (this.valueField != null) {
            return this.valueField.getTextValue2();
        }
        return null;
    }

    public String getType() {
        if (this.valueType != null) {
            return this.valueType.getTypeName();
        }
        return null;
    }

    public boolean needsTypeCheck() {
        if (this.operator == QueryOperator.NOT_EQUALS || this.operator == QueryOperator.NOT_EQUALS_IGNORE_CASE) {
            return false;
        }
        if (this.valueField != null) {
            return !"null".equals(this.valueType.getTypeName());
        }
        return false;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getScopeType() {
        return this.scopeType;
    }
}

