/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.jsontype.impl;

import com.signalfx.shaded.fasterxml.jackson.annotation.JsonTypeInfo;
import com.signalfx.shaded.fasterxml.jackson.core.JsonGenerator;
import com.signalfx.shaded.fasterxml.jackson.core.JsonToken;
import com.signalfx.shaded.fasterxml.jackson.core.type.WritableTypeId;
import com.signalfx.shaded.fasterxml.jackson.databind.BeanProperty;
import com.signalfx.shaded.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.signalfx.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public abstract class TypeSerializerBase
extends TypeSerializer {
    protected final TypeIdResolver _idResolver;
    protected final BeanProperty _property;

    protected TypeSerializerBase(TypeIdResolver idRes, BeanProperty property) {
        this._idResolver = idRes;
        this._property = property;
    }

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator g2, WritableTypeId idMetadata) throws IOException {
        this._generateTypeId(idMetadata);
        if (idMetadata.id == null) {
            return this._writeTypePrefixForNull(g2, idMetadata);
        }
        return g2.writeTypePrefix(idMetadata);
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator g2, WritableTypeId idMetadata) throws IOException {
        if (idMetadata == null) {
            return this._writeTypeSuffixfixForNull(g2, idMetadata);
        }
        return g2.writeTypeSuffix(idMetadata);
    }

    private WritableTypeId _writeTypePrefixForNull(JsonGenerator g2, WritableTypeId typeIdDef) throws IOException {
        JsonToken valueShape = typeIdDef.valueShape;
        typeIdDef.wrapperWritten = false;
        if (valueShape == JsonToken.START_OBJECT) {
            g2.writeStartObject(typeIdDef.forValue);
        } else if (valueShape == JsonToken.START_ARRAY) {
            g2.writeStartArray(typeIdDef.forValue);
        }
        return typeIdDef;
    }

    private WritableTypeId _writeTypeSuffixfixForNull(JsonGenerator g2, WritableTypeId typeIdDef) throws IOException {
        JsonToken valueShape = typeIdDef.valueShape;
        if (valueShape == JsonToken.START_OBJECT) {
            g2.writeEndObject();
        } else if (valueShape == JsonToken.START_ARRAY) {
            g2.writeEndArray();
        }
        return typeIdDef;
    }

    protected void _generateTypeId(WritableTypeId idMetadata) {
        Object id = idMetadata.id;
        if (id == null) {
            Object value = idMetadata.forValue;
            Class<?> typeForId = idMetadata.forValueType;
            id = typeForId == null ? this.idFromValue(value) : this.idFromValueAndType(value, typeForId);
            idMetadata.id = id;
        }
    }

    protected String idFromValue(Object value) {
        String id = this._idResolver.idFromValue(value);
        if (id == null) {
            this.handleMissingId(value);
        }
        return id;
    }

    protected String idFromValueAndType(Object value, Class<?> type) {
        String id = this._idResolver.idFromValueAndType(value, type);
        if (id == null) {
            this.handleMissingId(value);
        }
        return id;
    }

    protected void handleMissingId(Object value) {
    }
}

