/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Exec;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.propagation.AbstractPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class PriorityPropagationTaskExecutor
extends AbstractPropagationTaskExecutor {
    protected final AsyncTaskExecutor taskExecutor;

    public PriorityPropagationTaskExecutor(ConnectorManager connectorManager, ConnObjectUtils connObjectUtils, TaskDAO taskDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, NotificationManager notificationManager, AuditManager auditManager, TaskDataBinder taskDataBinder, AnyUtilsFactory anyUtilsFactory, TaskUtilsFactory taskUtilsFactory, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, ApplicationEventPublisher publisher, AsyncTaskExecutor taskExecutor) {
        super(connectorManager, connObjectUtils, taskDAO, resourceDAO, plainSchemaDAO, notificationManager, auditManager, taskDataBinder, anyUtilsFactory, taskUtilsFactory, outboundMatcher, validator, publisher);
        this.taskExecutor = taskExecutor;
    }

    protected Callable<TaskExec<PropagationTask>> newPropagationTaskCallable(PropagationTaskInfo taskInfo, PropagationReporter reporter, String executor) {
        String domain = AuthContextUtils.getDomain();
        Set authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        return () -> (TaskExec)AuthContextUtils.callAs((String)domain, (String)executor, (Collection)authorities, () -> {
            LOG.debug("Execution started for {}", (Object)taskInfo);
            TaskExec<PropagationTask> execution = this.execute(taskInfo, reporter, executor);
            LOG.debug("Execution completed for {} with results {}", (Object)taskInfo, execution);
            return execution;
        });
    }

    protected boolean failed(PropagationTaskInfo taskInfpo, TaskExec<PropagationTask> exec, ExecStatus execStatus) {
        return execStatus == ExecStatus.FAILURE;
    }

    public PropagationReporter execute(Collection<PropagationTaskInfo> taskInfos, boolean nullPriorityAsync, String executor) {
        DefaultPropagationReporter reporter = new DefaultPropagationReporter();
        try {
            List<PropagationTaskInfo> prioritizedTasks = taskInfos.stream().filter(task -> task.getResource().getPropagationPriority() != null).sorted(Comparator.comparing(task -> task.getResource().getPropagationPriority())).toList();
            LOG.debug("Propagation tasks sorted by priority, for serial execution: {}", prioritizedTasks);
            List<PropagationTaskInfo> concurrentTasks = taskInfos.stream().filter(task -> !prioritizedTasks.contains(task)).toList();
            LOG.debug("Propagation tasks for concurrent execution: {}", concurrentTasks);
            prioritizedTasks.forEach(taskInfo -> {
                ExecStatus execStatus;
                TaskExec<PropagationTask> exec = null;
                String errorMessage = null;
                try {
                    exec = this.newPropagationTaskCallable((PropagationTaskInfo)taskInfo, reporter, executor).call();
                    execStatus = ExecStatus.valueOf((String)exec.getStatus());
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                    execStatus = ExecStatus.FAILURE;
                    errorMessage = e.getMessage();
                }
                if (this.failed((PropagationTaskInfo)taskInfo, exec, execStatus)) {
                    throw new PropagationException(taskInfo.getResource().getKey(), Optional.ofNullable(exec).map(Exec::getMessage).orElse(errorMessage));
                }
            });
            if (!concurrentTasks.isEmpty()) {
                ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)this.taskExecutor);
                ArrayList futures = new ArrayList();
                concurrentTasks.forEach(taskInfo -> {
                    try {
                        futures.add(completionService.submit(this.newPropagationTaskCallable((PropagationTaskInfo)taskInfo, reporter, executor)));
                        if (nullPriorityAsync) {
                            reporter.onSuccessOrNonPriorityResourceFailures((PropagationTaskInfo)taskInfo, ExecStatus.CREATED, null, null, null, null);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("While submitting task for async execution: {}", taskInfo, (Object)e);
                        this.rejected((PropagationTaskInfo)taskInfo, e.getMessage(), reporter, executor);
                    }
                });
                if (!nullPriorityAsync) {
                    futures.forEach(future -> {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            LOG.error("Unexpected exception", (Throwable)e);
                        }
                    });
                }
            }
        }
        catch (PropagationException e) {
            LOG.error("Error propagation priority resource", (Throwable)e);
            reporter.onPriorityResourceFailure(e.getResourceName(), taskInfos);
        }
        return reporter;
    }
}

