/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.apache.syncope.client.enduser.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.panels.ResultPanel;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SelfResult
extends BasePage {
    private static final long serialVersionUID = 3804053409052140145L;
    private static final String RESULT_PAGE = "page.resultPage";

    public SelfResult(PageParameters parameters) {
        this(null, parameters);
    }

    public SelfResult(ProvisioningResult<UserTO> provisioningResult, PageParameters parameters) {
        super(parameters, RESULT_PAGE);
        Class<Object> page;
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.contentWrapper.add(new Component[]{content});
        try {
            page = Class.forName(parameters.get("landingPage").toString("org.apache.syncope.client.enduser.pages.Login"));
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Login page not found", (Throwable)e);
            page = Login.class;
        }
        if (page.equals(Login.class)) {
            BookmarkablePageLink login = new BookmarkablePageLink("login", Login.class);
            content.add(new Component[]{login.setOutputMarkupId(true)});
            this.disableSidebarAndNavbar();
        } else {
            content.add(new Component[]{BookmarkablePageLinkBuilder.build("login", page)});
        }
        content.add(new Component[]{new Label("resultTitle", (Serializable)((Object)parameters.get("notificationTitle").toString()))});
        content.add(new Component[]{new Label("resultMessage", (Serializable)((Object)parameters.get("notificationMessage").toString()))});
        Fragment statusFragment = new Fragment("statusIcon", provisioningResult != null && SyncopeWebApplication.get().isReportPropagationErrors() && provisioningResult.getPropagationStatuses().stream().anyMatch(ps -> ExecStatus.SUCCESS != ps.getStatus()) ? "errorIcon" : "successIcon", (MarkupContainer)content);
        if (provisioningResult != null && provisioningResult.getPropagationStatuses().stream().anyMatch(ps -> ExecStatus.SUCCESS != ps.getStatus())) {
            statusFragment.add(new Component[]{new ResultPanel("propagationErrors", (Serializable)((Object)provisioningResult.getPropagationStatuses().stream().filter(ps -> ExecStatus.SUCCESS != ps.getStatus()).map(ps -> StatusUtils.getStatusBean((AnyTO)((AnyTO)provisioningResult.getEntity()), (String)ps.getResource(), (ConnObject)ps.getAfterObj(), (boolean)false)).collect(Collectors.toList())), this.getPageReference()).setOutputMarkupId(true).setVisible(SyncopeWebApplication.get().isReportPropagationErrorDetails())});
        }
        content.add(new Component[]{statusFragment});
    }
}

